/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.concurrent.ConcurrentHashMap;
import net.i2p.util.TryCache;

public final class SimpleByteCache {
    private static final ConcurrentHashMap<Integer, SimpleByteCache> _caches = new ConcurrentHashMap(8);
    private static final int DEFAULT_SIZE = 64;
    private final TryCache<byte[]> _available;
    private final int _entrySize;

    public static SimpleByteCache getInstance(int size) {
        return SimpleByteCache.getInstance(64, size);
    }

    public static SimpleByteCache getInstance(int cacheSize, int size) {
        SimpleByteCache old;
        Integer sz = size;
        SimpleByteCache cache = _caches.get(sz);
        if (cache == null && (old = _caches.putIfAbsent(sz, cache = new SimpleByteCache(cacheSize, size))) != null) {
            cache = old;
        }
        cache.resize(cacheSize);
        return cache;
    }

    public static void clearAll() {
        for (SimpleByteCache bc : _caches.values()) {
            bc.clear();
        }
    }

    private SimpleByteCache(int maxCachedEntries, int entrySize) {
        this._available = new TryCache<byte[]>(new ByteArrayFactory(entrySize), maxCachedEntries);
        this._entrySize = entrySize;
    }

    private void resize(int maxCachedEntries) {
    }

    public static byte[] acquire(int size) {
        return SimpleByteCache.getInstance(size).acquire();
    }

    private byte[] acquire() {
        return this._available.acquire();
    }

    public static void release(byte[] entry) {
        SimpleByteCache cache = _caches.get(entry.length);
        if (cache != null) {
            cache.releaseIt(entry);
        }
    }

    private void releaseIt(byte[] entry) {
        if (entry == null || entry.length != this._entrySize) {
            return;
        }
        this._available.release(entry);
    }

    private void clear() {
        this._available.clear();
    }

    private static class ByteArrayFactory
    implements TryCache.ObjectFactory<byte[]> {
        private final int sz;

        ByteArrayFactory(int entrySize) {
            this.sz = entrySize;
        }

        @Override
        public byte[] newInstance() {
            return new byte[this.sz];
        }
    }
}

