/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.format.enigma;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.format.enigma.EnigmaReader;

public final class EnigmaDirReader {
    public static void read(Path dir, MappingVisitor visitor) throws IOException {
        EnigmaDirReader.read(dir, "source", "target", visitor);
    }

    public static void read(Path dir, final String sourceNs, final String targetNs, final MappingVisitor visitor) throws IOException {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toString().endsWith("." + MappingFormat.ENIGMA.fileExt)) {
                    EnigmaReader.read(Files.newBufferedReader(file), sourceNs, targetNs, visitor);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        visitor.visitEnd();
    }
}

