/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.Template;
import org.opensearch.flowframework.transport.GetWorkflowResponse;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.util.EncryptorUtils;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetWorkflowTransportAction
extends HandledTransportAction<WorkflowRequest, GetWorkflowResponse> {
    private final Logger logger = LogManager.getLogger(GetWorkflowTransportAction.class);
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private final Client client;
    private final EncryptorUtils encryptorUtils;

    @Inject
    public GetWorkflowTransportAction(TransportService transportService, ActionFilters actionFilters, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, Client client, EncryptorUtils encryptorUtils) {
        super("cluster:admin/opensearch/flow_framework/workflow/get", transportService, actionFilters, WorkflowRequest::new);
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
        this.client = client;
        this.encryptorUtils = encryptorUtils;
    }

    protected void doExecute(Task task, WorkflowRequest request, ActionListener<GetWorkflowResponse> listener) {
        if (this.flowFrameworkIndicesHandler.doesIndexExist(".plugins-flow-framework-templates")) {
            String workflowId = request.getWorkflowId();
            GetRequest getRequest = new GetRequest(".plugins-flow-framework-templates", workflowId);
            try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
                this.logger.info("Querying workflow from global context: {}", (Object)workflowId);
                this.client.get(getRequest, ActionListener.wrap(response -> {
                    context.restore();
                    if (!response.isExists()) {
                        String errorMessage = "Failed to retrieve template (" + workflowId + ") from global context.";
                        this.logger.error(errorMessage);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND)));
                    } else {
                        User user = ParseUtils.getUserContext(this.client);
                        Template template = this.encryptorUtils.redactTemplateSecuredFields(user, Template.parse(response.getSourceAsString()));
                        listener.onResponse((Object)new GetWorkflowResponse(template));
                    }
                }, exception -> {
                    String errorMessage = "Failed to retrieve template (" + workflowId + ") from global context.";
                    this.logger.error(errorMessage, (Throwable)exception);
                    listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
                }));
            }
            catch (Exception e) {
                String errorMessage = "Failed to retrieve template (" + workflowId + ") from global context.";
                this.logger.error(errorMessage, (Throwable)e);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
            }
        } else {
            String errorMessage = "There are no templates in the global_context";
            this.logger.error(errorMessage);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND)));
        }
    }
}

