/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.AbstractXContentParser;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;

public class JsonToStringXContentParser
extends AbstractXContentParser {
    private final String fieldTypeName;
    private XContentParser parser;
    private ArrayList<String> valueList = new ArrayList();
    private ArrayList<String> valueAndPathList = new ArrayList();
    private ArrayList<String> keyList = new ArrayList();
    private XContentBuilder builder = XContentBuilder.builder((XContent)JsonXContent.jsonXContent);
    private NamedXContentRegistry xContentRegistry;
    private DeprecationHandler deprecationHandler;
    private static final String VALUE_AND_PATH_SUFFIX = "._valueAndPath";
    private static final String VALUE_SUFFIX = "._value";
    private static final String DOT_SYMBOL = ".";
    private static final String EQUAL_SYMBOL = "=";

    public JsonToStringXContentParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, XContentParser parser, String fieldTypeName) throws IOException {
        super(xContentRegistry, deprecationHandler);
        this.deprecationHandler = deprecationHandler;
        this.xContentRegistry = xContentRegistry;
        this.parser = parser;
        this.fieldTypeName = fieldTypeName;
    }

    public XContentParser parseObject() throws IOException {
        this.builder.startObject();
        StringBuilder path = new StringBuilder(this.fieldTypeName);
        this.parseToken(path, null);
        this.builder.field(this.fieldTypeName, this.keyList);
        this.builder.field(this.fieldTypeName + VALUE_SUFFIX, this.valueList);
        this.builder.field(this.fieldTypeName + VALUE_AND_PATH_SUFFIX, this.valueAndPathList);
        this.builder.endObject();
        String jString = XContentHelper.convertToJson(BytesReference.bytes((XContentBuilder)this.builder), false, MediaTypeRegistry.JSON);
        return JsonXContent.jsonXContent.createParser(this.xContentRegistry, this.deprecationHandler, String.valueOf(jString));
    }

    private void parseToken(StringBuilder path, String currentFieldName) throws IOException {
        while (this.parser.nextToken() != XContentParser.Token.END_OBJECT) {
            int dotIndex;
            if (this.parser.currentName() != null) {
                currentFieldName = this.parser.currentName();
            }
            StringBuilder parsedFields = new StringBuilder();
            if (this.parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                path.append(DOT_SYMBOL).append(currentFieldName);
                dotIndex = currentFieldName.indexOf(DOT_SYMBOL);
                String fieldNameSuffix = currentFieldName;
                while (dotIndex >= 0) {
                    String fieldNamePrefix = fieldNameSuffix.substring(0, dotIndex);
                    if (!fieldNamePrefix.isEmpty()) {
                        this.keyList.add(fieldNamePrefix);
                    }
                    fieldNameSuffix = fieldNameSuffix.substring(dotIndex + 1);
                    dotIndex = fieldNameSuffix.indexOf(DOT_SYMBOL);
                }
                if (fieldNameSuffix.isEmpty()) continue;
                this.keyList.add(fieldNameSuffix);
                continue;
            }
            if (this.parser.currentToken() == XContentParser.Token.START_ARRAY) {
                this.parseToken(path, currentFieldName);
                break;
            }
            if (this.parser.currentToken() == XContentParser.Token.END_ARRAY) continue;
            if (this.parser.currentToken() == XContentParser.Token.START_OBJECT) {
                this.parseToken(path, currentFieldName);
                dotIndex = path.lastIndexOf(DOT_SYMBOL, path.length());
                if (dotIndex == -1 || path.length() <= currentFieldName.length()) continue;
                path.setLength(path.length() - currentFieldName.length() - 1);
                continue;
            }
            if (!path.toString().contains(currentFieldName)) {
                path.append(DOT_SYMBOL).append(currentFieldName);
            }
            this.parseValue(parsedFields);
            this.valueList.add(parsedFields.toString());
            this.valueAndPathList.add(String.valueOf(path) + EQUAL_SYMBOL + String.valueOf(parsedFields));
            dotIndex = path.lastIndexOf(DOT_SYMBOL, path.length());
            if (dotIndex == -1 || path.length() <= currentFieldName.length()) continue;
            path.setLength(path.length() - currentFieldName.length() - 1);
        }
    }

    private void parseValue(StringBuilder parsedFields) throws IOException {
        switch (this.parser.currentToken()) {
            case VALUE_BOOLEAN: 
            case VALUE_NUMBER: 
            case VALUE_STRING: 
            case VALUE_NULL: {
                parsedFields.append(this.parser.textOrNull());
                break;
            }
            case FIELD_NAME: 
            case VALUE_EMBEDDED_OBJECT: 
            case END_ARRAY: 
            case START_ARRAY: {
                break;
            }
            default: {
                throw new IOException("Unsupported token type [" + String.valueOf(this.parser.currentToken()) + "]");
            }
        }
    }

    public MediaType contentType() {
        return MediaTypeRegistry.JSON;
    }

    public XContentParser.Token nextToken() throws IOException {
        return this.parser.nextToken();
    }

    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    public XContentParser.Token currentToken() {
        return this.parser.currentToken();
    }

    public String currentName() throws IOException {
        return this.parser.currentName();
    }

    public String text() throws IOException {
        return this.parser.text();
    }

    public CharBuffer charBuffer() throws IOException {
        return this.parser.charBuffer();
    }

    public Object objectText() throws IOException {
        return this.parser.objectText();
    }

    public Object objectBytes() throws IOException {
        return this.parser.objectBytes();
    }

    public boolean hasTextCharacters() {
        return this.parser.hasTextCharacters();
    }

    public char[] textCharacters() throws IOException {
        return this.parser.textCharacters();
    }

    public int textLength() throws IOException {
        return this.parser.textLength();
    }

    public int textOffset() throws IOException {
        return this.parser.textOffset();
    }

    public Number numberValue() throws IOException {
        return this.parser.numberValue();
    }

    public XContentParser.NumberType numberType() throws IOException {
        return this.parser.numberType();
    }

    public byte[] binaryValue() throws IOException {
        return this.parser.binaryValue();
    }

    public XContentLocation getTokenLocation() {
        return this.parser.getTokenLocation();
    }

    protected boolean doBooleanValue() throws IOException {
        return this.parser.booleanValue();
    }

    protected short doShortValue() throws IOException {
        return this.parser.shortValue();
    }

    protected int doIntValue() throws IOException {
        return this.parser.intValue();
    }

    protected long doLongValue() throws IOException {
        return this.parser.longValue();
    }

    protected float doFloatValue() throws IOException {
        return this.parser.floatValue();
    }

    protected double doDoubleValue() throws IOException {
        return this.parser.doubleValue();
    }

    protected BigInteger doBigIntegerValue() throws IOException {
        return this.parser.bigIntegerValue();
    }

    public boolean isClosed() {
        return this.parser.isClosed();
    }

    public void close() throws IOException {
        this.parser.close();
    }
}

