/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.geo.GeoLineDecomposer;
import org.opensearch.common.geo.GeoPolygonDecomposer;
import org.opensearch.common.geo.GeoShapeUtils;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.geometry.Circle;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.GeometryCollection;
import org.opensearch.geometry.GeometryVisitor;
import org.opensearch.geometry.Line;
import org.opensearch.geometry.LinearRing;
import org.opensearch.geometry.MultiLine;
import org.opensearch.geometry.MultiPoint;
import org.opensearch.geometry.MultiPolygon;
import org.opensearch.geometry.Point;
import org.opensearch.geometry.Polygon;
import org.opensearch.geometry.Rectangle;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;

public class VectorGeoShapeQueryProcessor {
    public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before((Version)LegacyESVersion.V_7_5_0)) {
            throw new QueryShardException(context, String.valueOf((Object)ShapeRelation.CONTAINS) + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context);
    }

    private Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        LuceneGeometryCollector visitor = new LuceneGeometryCollector(fieldName, context);
        queryShape.visit((GeometryVisitor)visitor);
        List<LatLonGeometry> geometries = visitor.geometries();
        if (geometries.size() == 0) {
            return new MatchNoDocsQuery();
        }
        return LatLonShape.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (LatLonGeometry[])geometries.toArray(new LatLonGeometry[geometries.size()]));
    }

    private static class LuceneGeometryCollector
    implements GeometryVisitor<Void, RuntimeException> {
        private final List<LatLonGeometry> geometries = new ArrayList<LatLonGeometry>();
        private final String name;
        private final QueryShardContext context;

        private LuceneGeometryCollector(String name, QueryShardContext context) {
            this.name = name;
            this.context = context;
        }

        List<LatLonGeometry> geometries() {
            return this.geometries;
        }

        public Void visit(Circle circle) {
            if (!circle.isEmpty()) {
                this.geometries.add((LatLonGeometry)GeoShapeUtils.toLuceneCircle(circle));
            }
            return null;
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry shape : collection) {
                shape.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            if (!line.isEmpty()) {
                ArrayList<Line> collector = new ArrayList<Line>();
                GeoLineDecomposer.decomposeLine(line, collector);
                this.collectLines(collector);
            }
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new QueryShardException(this.context, "Field [" + this.name + "] found and unsupported shape LinearRing", new Object[0]);
        }

        public Void visit(MultiLine multiLine) {
            ArrayList<Line> collector = new ArrayList<Line>();
            GeoLineDecomposer.decomposeMultiLine(multiLine, collector);
            this.collectLines(collector);
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            if (!multiPolygon.isEmpty()) {
                ArrayList<Polygon> collector = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposeMultiPolygon(multiPolygon, true, collector);
                this.collectPolygons(collector);
            }
            return null;
        }

        public Void visit(Point point) {
            if (!point.isEmpty()) {
                double quantizedLat = GeoEncodingUtils.decodeLatitude((int)GeoEncodingUtils.encodeLatitude((double)point.getLat()));
                double quantizedLon = GeoEncodingUtils.decodeLongitude((int)GeoEncodingUtils.encodeLongitude((double)point.getLon()));
                this.geometries.add((LatLonGeometry)new org.apache.lucene.geo.Point(quantizedLat, quantizedLon));
            }
            return null;
        }

        public Void visit(Polygon polygon) {
            if (!polygon.isEmpty()) {
                ArrayList<Polygon> collector = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposePolygon(polygon, true, collector);
                this.collectPolygons(collector);
            }
            return null;
        }

        public Void visit(Rectangle r) {
            if (!r.isEmpty()) {
                this.geometries.add((LatLonGeometry)GeoShapeUtils.toLuceneRectangle(r));
            }
            return null;
        }

        private void collectLines(List<Line> geometryLines) {
            for (Line line : geometryLines) {
                this.geometries.add((LatLonGeometry)GeoShapeUtils.toLuceneLine(line));
            }
        }

        private void collectPolygons(List<Polygon> geometryPolygons) {
            for (Polygon polygon : geometryPolygons) {
                this.geometries.add((LatLonGeometry)GeoShapeUtils.toLucenePolygon(polygon));
            }
        }
    }
}

