/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.threadpool;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.SizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.util.concurrent.OpenSearchThreadPoolExecutor;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.node.Node;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.RunnableTaskExecutionListener;
import org.opensearch.threadpool.ThreadPool;

public final class AutoQueueAdjustingExecutorBuilder
extends ExecutorBuilder<AutoExecutorSettings> {
    private final Setting<Integer> sizeSetting;
    private final Setting<Integer> queueSizeSetting;
    private final Setting<Integer> minQueueSizeSetting;
    private final Setting<Integer> maxQueueSizeSetting;
    private final Setting<TimeValue> targetedResponseTimeSetting;
    private final Setting<Integer> frameSizeSetting;
    private final AtomicReference<RunnableTaskExecutionListener> runnableTaskListener;

    AutoQueueAdjustingExecutorBuilder(Settings settings, String name, int size, int initialQueueSize, int minQueueSize, int maxQueueSize, int frameSize) {
        this(settings, name, size, initialQueueSize, minQueueSize, maxQueueSize, frameSize, null);
    }

    AutoQueueAdjustingExecutorBuilder(Settings settings, String name, int size, int initialQueueSize, int minQueueSize, int maxQueueSize, int frameSize, AtomicReference<RunnableTaskExecutionListener> runnableTaskListener) {
        super(name);
        String prefix = "thread_pool." + name;
        String sizeKey = AutoQueueAdjustingExecutorBuilder.settingsKey(prefix, "size");
        this.sizeSetting = new Setting<Integer>(sizeKey, s -> Integer.toString(size), s -> Setting.parseInt(s, 1, this.applyHardSizeLimit(settings, name), sizeKey), Setting.Property.NodeScope);
        String queueSizeKey = AutoQueueAdjustingExecutorBuilder.settingsKey(prefix, "queue_size");
        final String minSizeKey = AutoQueueAdjustingExecutorBuilder.settingsKey(prefix, "min_queue_size");
        String maxSizeKey = AutoQueueAdjustingExecutorBuilder.settingsKey(prefix, "max_queue_size");
        String frameSizeKey = AutoQueueAdjustingExecutorBuilder.settingsKey(prefix, "auto_queue_frame_size");
        String targetedResponseTimeKey = AutoQueueAdjustingExecutorBuilder.settingsKey(prefix, "target_response_time");
        this.targetedResponseTimeSetting = Setting.timeSetting(targetedResponseTimeKey, TimeValue.timeValueSeconds((long)1L), TimeValue.timeValueMillis((long)10L), Setting.Property.NodeScope, Setting.Property.Deprecated);
        this.queueSizeSetting = Setting.intSetting(queueSizeKey, initialQueueSize, Setting.Property.NodeScope);
        final Setting<Integer> tempMaxQueueSizeSetting = Setting.intSetting(maxSizeKey, maxQueueSize, Setting.Property.NodeScope, Setting.Property.Deprecated);
        final Setting<Integer> tempMinQueueSizeSetting = Setting.intSetting(minSizeKey, minQueueSize, Setting.Property.NodeScope, Setting.Property.Deprecated);
        this.minQueueSizeSetting = new Setting<Integer>(minSizeKey, Integer.toString(minQueueSize), s -> Setting.parseInt(s, 0, minSizeKey), new Setting.Validator<Integer>(){

            @Override
            public void validate(Integer value) {
            }

            @Override
            public void validate(Integer value, Map<Setting<?>, Object> settings) {
                if (value > (Integer)settings.get(tempMaxQueueSizeSetting)) {
                    throw new IllegalArgumentException("Failed to parse value [" + value + "] for setting [" + minSizeKey + "] must be <= " + String.valueOf(settings.get(tempMaxQueueSizeSetting)));
                }
            }

            @Override
            public Iterator<Setting<?>> settings() {
                List<Setting> settings = Collections.singletonList(tempMaxQueueSizeSetting);
                return settings.iterator();
            }
        }, Setting.Property.NodeScope);
        this.maxQueueSizeSetting = new Setting<Integer>(maxSizeKey, Integer.toString(maxQueueSize), s -> Setting.parseInt(s, 0, maxSizeKey), new Setting.Validator<Integer>(){

            @Override
            public void validate(Integer value) {
            }

            @Override
            public void validate(Integer value, Map<Setting<?>, Object> settings) {
                if (value < (Integer)settings.get(tempMinQueueSizeSetting)) {
                    throw new IllegalArgumentException("Failed to parse value [" + value + "] for setting [" + minSizeKey + "] must be >= " + String.valueOf(settings.get(tempMinQueueSizeSetting)));
                }
            }

            @Override
            public Iterator<Setting<?>> settings() {
                List<Setting> settings = Collections.singletonList(tempMinQueueSizeSetting);
                return settings.iterator();
            }
        }, Setting.Property.NodeScope, Setting.Property.Deprecated);
        this.frameSizeSetting = Setting.intSetting(frameSizeKey, frameSize, 100, Setting.Property.NodeScope, Setting.Property.Deprecated, Setting.Property.Deprecated);
        this.runnableTaskListener = runnableTaskListener;
    }

    @Override
    public List<Setting<?>> getRegisteredSettings() {
        return Arrays.asList(this.sizeSetting, this.queueSizeSetting, this.minQueueSizeSetting, this.maxQueueSizeSetting, this.frameSizeSetting, this.targetedResponseTimeSetting);
    }

    @Override
    AutoExecutorSettings getSettings(Settings settings) {
        String nodeName = Node.NODE_NAME_SETTING.get(settings);
        int size = this.sizeSetting.get(settings);
        int initialQueueSize = this.queueSizeSetting.get(settings);
        int minQueueSize = this.minQueueSizeSetting.get(settings);
        int maxQueueSize = this.maxQueueSizeSetting.get(settings);
        int frameSize = this.frameSizeSetting.get(settings);
        TimeValue targetedResponseTime = this.targetedResponseTimeSetting.get(settings);
        return new AutoExecutorSettings(nodeName, size, initialQueueSize, minQueueSize, maxQueueSize, frameSize, targetedResponseTime);
    }

    @Override
    ThreadPool.ExecutorHolder build(AutoExecutorSettings settings, ThreadContext threadContext) {
        int size = settings.size;
        int initialQueueSize = settings.initialQueueSize;
        int minQueueSize = settings.minQueueSize;
        int maxQueueSize = settings.maxQueueSize;
        int frameSize = settings.frameSize;
        TimeValue targetedResponseTime = settings.targetedResponseTime;
        ThreadFactory threadFactory = OpenSearchExecutors.daemonThreadFactory(OpenSearchExecutors.threadName(settings.nodeName, this.name()));
        OpenSearchThreadPoolExecutor executor = OpenSearchExecutors.newAutoQueueFixed(settings.nodeName + "/" + this.name(), size, initialQueueSize, minQueueSize, maxQueueSize, frameSize, targetedResponseTime, threadFactory, threadContext, this.runnableTaskListener);
        ThreadPool.Info info = new ThreadPool.Info(this.name(), ThreadPool.ThreadPoolType.FIXED_AUTO_QUEUE_SIZE, size, size, null, new SizeValue(initialQueueSize));
        return new ThreadPool.ExecutorHolder(executor, info);
    }

    @Override
    String formatInfo(ThreadPool.Info info) {
        return String.format(Locale.ROOT, "name [%s], size [%d], queue size [%s]", info.getName(), info.getMax(), info.getQueueSize() == null ? "unbounded" : info.getQueueSize());
    }

    static final class AutoExecutorSettings
    extends ExecutorBuilder.ExecutorSettings {
        final int size;
        final int initialQueueSize;
        final int minQueueSize;
        final int maxQueueSize;
        final int frameSize;
        final TimeValue targetedResponseTime;

        AutoExecutorSettings(String nodeName, int size, int initialQueueSize, int minQueueSize, int maxQueueSize, int frameSize, TimeValue targetedResponseTime) {
            super(nodeName);
            this.size = size;
            this.initialQueueSize = initialQueueSize;
            this.minQueueSize = minQueueSize;
            this.maxQueueSize = maxQueueSize;
            this.frameSize = frameSize;
            this.targetedResponseTime = targetedResponseTime;
        }
    }
}

