/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.memory;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.knn.index.IndexUtil;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.memory.NativeMemoryAllocation;
import org.opensearch.knn.index.memory.NativeMemoryLoadStrategy;

public abstract class NativeMemoryEntryContext<T extends NativeMemoryAllocation> {
    protected final String key;

    public NativeMemoryEntryContext(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public abstract Integer calculateSizeInKB();

    public abstract T load() throws IOException;

    public static class AnonymousEntryContext
    extends NativeMemoryEntryContext<NativeMemoryAllocation.AnonymousAllocation> {
        private final int size;
        private final NativeMemoryLoadStrategy.AnonymousLoadStrategy loadStrategy;

        public AnonymousEntryContext(int size, NativeMemoryLoadStrategy.AnonymousLoadStrategy loadStrategy) {
            super(UUID.randomUUID().toString());
            this.size = size;
            this.loadStrategy = loadStrategy;
        }

        @Override
        public Integer calculateSizeInKB() {
            return this.size;
        }

        @Override
        public NativeMemoryAllocation.AnonymousAllocation load() throws IOException {
            return this.loadStrategy.load(this);
        }
    }

    public static class TrainingDataEntryContext
    extends NativeMemoryEntryContext<NativeMemoryAllocation.TrainingDataAllocation> {
        private static final String KEY_PREFIX = "tdata#";
        private static final String DELIMETER = ":";
        private final int size;
        private final NativeMemoryLoadStrategy.TrainingLoadStrategy trainingLoadStrategy;
        private final ClusterService clusterService;
        private final String trainIndexName;
        private final String trainFieldName;
        private final int maxVectorCount;
        private final int searchSize;
        private final VectorDataType vectorDataType;

        public TrainingDataEntryContext(int size, String trainIndexName, String trainFieldName, NativeMemoryLoadStrategy.TrainingLoadStrategy trainingLoadStrategy, ClusterService clusterService, int maxVectorCount, int searchSize, VectorDataType vectorDataType) {
            super(TrainingDataEntryContext.generateKey(trainIndexName, trainFieldName));
            this.size = size;
            this.trainingLoadStrategy = trainingLoadStrategy;
            this.trainIndexName = trainIndexName;
            this.trainFieldName = trainFieldName;
            this.clusterService = clusterService;
            this.maxVectorCount = maxVectorCount;
            this.searchSize = searchSize;
            this.vectorDataType = vectorDataType;
        }

        @Override
        public Integer calculateSizeInKB() {
            return this.size;
        }

        @Override
        public NativeMemoryAllocation.TrainingDataAllocation load() {
            return this.trainingLoadStrategy.load(this);
        }

        public String getTrainIndexName() {
            return this.trainIndexName;
        }

        public String getTrainFieldName() {
            return this.trainFieldName;
        }

        public int getMaxVectorCount() {
            return this.maxVectorCount;
        }

        public int getSearchSize() {
            return this.searchSize;
        }

        public ClusterService getClusterService() {
            return this.clusterService;
        }

        public VectorDataType getVectorDataType() {
            return this.vectorDataType;
        }

        private static String generateKey(String trainIndexName, String trainFieldName) {
            return KEY_PREFIX + trainIndexName + DELIMETER + trainFieldName;
        }
    }

    public static class IndexEntryContext
    extends NativeMemoryEntryContext<NativeMemoryAllocation.IndexAllocation> {
        private final NativeMemoryLoadStrategy.IndexLoadStrategy indexLoadStrategy;
        private final String openSearchIndexName;
        private final Map<String, Object> parameters;
        @Nullable
        private final String modelId;

        public IndexEntryContext(String indexPath, NativeMemoryLoadStrategy.IndexLoadStrategy indexLoadStrategy, Map<String, Object> parameters, String openSearchIndexName) {
            this(indexPath, indexLoadStrategy, parameters, openSearchIndexName, null);
        }

        public IndexEntryContext(String indexPath, NativeMemoryLoadStrategy.IndexLoadStrategy indexLoadStrategy, Map<String, Object> parameters, String openSearchIndexName, String modelId) {
            super(indexPath);
            this.indexLoadStrategy = indexLoadStrategy;
            this.openSearchIndexName = openSearchIndexName;
            this.parameters = parameters;
            this.modelId = modelId;
        }

        @Override
        public Integer calculateSizeInKB() {
            return IndexSizeCalculator.INSTANCE.apply(this);
        }

        @Override
        public NativeMemoryAllocation.IndexAllocation load() throws IOException {
            return this.indexLoadStrategy.load(this);
        }

        public String getOpenSearchIndexName() {
            return this.openSearchIndexName;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public String getModelId() {
            return this.modelId;
        }

        private static class IndexSizeCalculator
        implements Function<IndexEntryContext, Integer> {
            static IndexSizeCalculator INSTANCE = new IndexSizeCalculator();

            IndexSizeCalculator() {
            }

            @Override
            public Integer apply(IndexEntryContext indexEntryContext) {
                return IndexUtil.getFileSizeInKB(indexEntryContext.getKey());
            }
        }
    }
}

