/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.util;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.KNNMethod;
import org.opensearch.knn.index.KNNMethodContext;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.util.EngineSpecificMethodContext;
import org.opensearch.knn.index.util.Faiss;
import org.opensearch.knn.index.util.KNNLibrary;
import org.opensearch.knn.index.util.Lucene;
import org.opensearch.knn.index.util.Nmslib;
import org.opensearch.knn.training.VectorSpaceInfo;

public enum KNNEngine implements KNNLibrary
{
    NMSLIB("nmslib", Nmslib.INSTANCE),
    FAISS("faiss", Faiss.INSTANCE),
    LUCENE("lucene", Lucene.INSTANCE);

    public static final KNNEngine DEFAULT;
    private static final Set<KNNEngine> CUSTOM_SEGMENT_FILE_ENGINES;
    private static final Set<KNNEngine> ENGINES_SUPPORTING_FILTERS;
    public static final Set<KNNEngine> ENGINES_SUPPORTING_RADIAL_SEARCH;
    private static Map<KNNEngine, Integer> MAX_DIMENSIONS_BY_ENGINE;
    private final String name;
    private final KNNLibrary knnLibrary;

    private KNNEngine(String name, KNNLibrary knnLibrary) {
        this.name = name;
        this.knnLibrary = knnLibrary;
    }

    public static KNNEngine getEngine(String name) {
        if (NMSLIB.getName().equalsIgnoreCase(name)) {
            return NMSLIB;
        }
        if (FAISS.getName().equalsIgnoreCase(name)) {
            return FAISS;
        }
        if (LUCENE.getName().equalsIgnoreCase(name)) {
            return LUCENE;
        }
        throw new IllegalArgumentException(String.format("Invalid engine type: %s", name));
    }

    public static KNNEngine getEngineNameFromPath(String path) {
        if (path.endsWith(NMSLIB.getExtension()) || path.endsWith(NMSLIB.getCompoundExtension())) {
            return NMSLIB;
        }
        if (path.endsWith(FAISS.getExtension()) || path.endsWith(FAISS.getCompoundExtension())) {
            return FAISS;
        }
        throw new IllegalArgumentException("No engine matches the path's suffix");
    }

    public static Set<KNNEngine> getEnginesThatCreateCustomSegmentFiles() {
        return CUSTOM_SEGMENT_FILE_ENGINES;
    }

    public static Set<KNNEngine> getEnginesThatSupportsFilters() {
        return ENGINES_SUPPORTING_FILTERS;
    }

    public static int getMaxDimensionByEngine(KNNEngine knnEngine) {
        return MAX_DIMENSIONS_BY_ENGINE.getOrDefault(knnEngine, MAX_DIMENSIONS_BY_ENGINE.get(DEFAULT));
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.knnLibrary.getVersion();
    }

    @Override
    public String getExtension() {
        return this.knnLibrary.getExtension();
    }

    @Override
    public String getCompoundExtension() {
        return this.knnLibrary.getCompoundExtension();
    }

    @Override
    public KNNMethod getMethod(String methodName) {
        return this.knnLibrary.getMethod(methodName);
    }

    @Override
    public EngineSpecificMethodContext getMethodContext(String methodName) {
        return this.knnLibrary.getMethodContext(methodName);
    }

    @Override
    public float score(float rawScore, SpaceType spaceType) {
        return this.knnLibrary.score(rawScore, spaceType);
    }

    @Override
    public Float distanceToRadialThreshold(Float distance, SpaceType spaceType) {
        return this.knnLibrary.distanceToRadialThreshold(distance, spaceType);
    }

    @Override
    public Float scoreToRadialThreshold(Float score, SpaceType spaceType) {
        return this.knnLibrary.scoreToRadialThreshold(score, spaceType);
    }

    @Override
    public ValidationException validateMethod(KNNMethodContext knnMethodContext) {
        return this.knnLibrary.validateMethod(knnMethodContext);
    }

    @Override
    public ValidationException validateMethodWithData(KNNMethodContext knnMethodContext, VectorSpaceInfo vectorSpaceInfo) {
        return this.knnLibrary.validateMethodWithData(knnMethodContext, vectorSpaceInfo);
    }

    @Override
    public boolean isTrainingRequired(KNNMethodContext knnMethodContext) {
        return this.knnLibrary.isTrainingRequired(knnMethodContext);
    }

    @Override
    public Map<String, Object> getMethodAsMap(KNNMethodContext knnMethodContext) {
        return this.knnLibrary.getMethodAsMap(knnMethodContext);
    }

    @Override
    public int estimateOverheadInKB(KNNMethodContext knnMethodContext, int dimension) {
        return this.knnLibrary.estimateOverheadInKB(knnMethodContext, dimension);
    }

    @Override
    public Boolean isInitialized() {
        return this.knnLibrary.isInitialized();
    }

    @Override
    public void setInitialized(Boolean isInitialized) {
        this.knnLibrary.setInitialized(isInitialized);
    }

    @Override
    public List<String> mmapFileExtensions() {
        return this.knnLibrary.mmapFileExtensions();
    }

    static {
        DEFAULT = NMSLIB;
        CUSTOM_SEGMENT_FILE_ENGINES = ImmutableSet.of((Object)NMSLIB, (Object)FAISS);
        ENGINES_SUPPORTING_FILTERS = ImmutableSet.of((Object)LUCENE, (Object)FAISS);
        ENGINES_SUPPORTING_RADIAL_SEARCH = ImmutableSet.of((Object)LUCENE, (Object)FAISS);
        MAX_DIMENSIONS_BY_ENGINE = Map.of(NMSLIB, 16000, FAISS, 16000, LUCENE, 16000);
    }
}

