/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless.ir;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.opensearch.painless.ClassWriter;
import org.opensearch.painless.Location;
import org.opensearch.painless.MethodWriter;
import org.opensearch.painless.ir.BlockNode;
import org.opensearch.painless.ir.CatchNode;
import org.opensearch.painless.ir.StatementNode;
import org.opensearch.painless.phase.IRTreeVisitor;
import org.opensearch.painless.symbol.WriteScope;

public class TryNode
extends StatementNode {
    private BlockNode blockNode;
    private final List<CatchNode> catchNodes = new ArrayList<CatchNode>();

    public void setBlockNode(BlockNode blockNode) {
        this.blockNode = blockNode;
    }

    public BlockNode getBlockNode() {
        return this.blockNode;
    }

    public void addCatchNode(CatchNode catchNode) {
        this.catchNodes.add(catchNode);
    }

    public List<CatchNode> getCatchsNodes() {
        return this.catchNodes;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitTry(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.blockNode.visit(irTreeVisitor, scope);
        for (CatchNode catchNode : this.catchNodes) {
            catchNode.visit(irTreeVisitor, scope);
        }
    }

    public TryNode(Location location) {
        super(location);
    }

    @Override
    protected void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        methodWriter.writeStatementOffset(this.getLocation());
        Label begin = new Label();
        Label end = new Label();
        Label exception = new Label();
        methodWriter.mark(begin);
        this.blockNode.continueLabel = this.continueLabel;
        this.blockNode.breakLabel = this.breakLabel;
        this.blockNode.write(classWriter, methodWriter, writeScope.newScope());
        if (!this.blockNode.doAllEscape()) {
            methodWriter.goTo(exception);
        }
        methodWriter.mark(end);
        for (CatchNode catchNode : this.catchNodes) {
            catchNode.begin = begin;
            catchNode.end = end;
            catchNode.exception = this.catchNodes.size() > 1 ? exception : null;
            catchNode.write(classWriter, methodWriter, writeScope.newScope());
        }
        if (!this.blockNode.doAllEscape() || this.catchNodes.size() > 1) {
            methodWriter.mark(exception);
        }
    }
}

