/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.ratelimit.ADResultWriteRequest;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.ADResultBulkAction;
import org.opensearch.ad.transport.ADResultBulkRequest;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexingPressure;
import org.opensearch.timeseries.transport.ResultBulkTransportAction;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.TransportService;

public class ADResultBulkTransportAction
extends ResultBulkTransportAction<AnomalyResult, ADResultWriteRequest, ADResultBulkRequest> {
    private static final Logger LOG = LogManager.getLogger(ADResultBulkTransportAction.class);

    @Inject
    public ADResultBulkTransportAction(TransportService transportService, ActionFilters actionFilters, IndexingPressure indexingPressure, Settings settings, ClusterService clusterService, Client client) {
        super(ADResultBulkAction.NAME, transportService, actionFilters, indexingPressure, settings, client, ((Float)AnomalyDetectorSettings.AD_INDEX_PRESSURE_SOFT_LIMIT.get(settings)).floatValue(), ((Float)AnomalyDetectorSettings.AD_INDEX_PRESSURE_HARD_LIMIT.get(settings)).floatValue(), ".opendistro-anomaly-results", ADResultBulkRequest::new);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_INDEX_PRESSURE_SOFT_LIMIT, it -> {
            this.softLimit = it.floatValue();
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.AD_INDEX_PRESSURE_HARD_LIMIT, it -> {
            this.hardLimit = it.floatValue();
        });
    }

    @Override
    protected BulkRequest prepareBulkRequest(float indexingPressurePercent, ADResultBulkRequest request) {
        BulkRequest bulkRequest = new BulkRequest();
        List results = request.getResults();
        if (indexingPressurePercent <= this.softLimit) {
            for (ADResultWriteRequest resultWriteRequest : results) {
                this.addResult(bulkRequest, (AnomalyResult)resultWriteRequest.getResult(), resultWriteRequest.getResultIndex());
            }
        } else if (indexingPressurePercent <= this.hardLimit) {
            float acceptProbability = 1.0f - indexingPressurePercent;
            for (ADResultWriteRequest resultWriteRequest : results) {
                AnomalyResult result = (AnomalyResult)resultWriteRequest.getResult();
                if (!result.isHighPriority() && !(this.random.nextFloat() < acceptProbability)) continue;
                this.addResult(bulkRequest, result, resultWriteRequest.getResultIndex());
            }
        } else {
            for (ADResultWriteRequest resultWriteRequest : results) {
                AnomalyResult result = (AnomalyResult)resultWriteRequest.getResult();
                if (!result.isHighPriority()) continue;
                this.addResult(bulkRequest, result, resultWriteRequest.getResultIndex());
            }
        }
        return bulkRequest;
    }

    private void addResult(BulkRequest bulkRequest, AnomalyResult result, String resultIndex) {
        String index = resultIndex == null ? this.indexName : resultIndex;
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            IndexRequest indexRequest = new IndexRequest(index).source(result.toXContent(builder, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITH_TYPE));
            bulkRequest.add(indexRequest);
        }
        catch (IOException e) {
            LOG.error("Failed to prepare bulk index request for index " + index, (Throwable)e);
        }
    }
}

