/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.forecast.model.ForecastTask;
import org.opensearch.forecast.model.ForecastTaskType;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.forecast.stats.ForecastStats;
import org.opensearch.forecast.task.ForecastTaskManager;
import org.opensearch.forecast.transport.ForecastResultRequest;
import org.opensearch.forecast.transport.ForecastResultResponse;
import org.opensearch.forecast.transport.ForecastSingleStreamResultAction;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.cluster.HashRing;
import org.opensearch.timeseries.feature.FeatureManager;
import org.opensearch.timeseries.model.FeatureData;
import org.opensearch.timeseries.stats.StatNames;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.transport.ResultProcessor;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.TransportService;

public class ForecastResultProcessor
extends ResultProcessor<ForecastResultRequest, ForecastResult, ForecastResultResponse, TaskCacheManager, ForecastTaskType, ForecastTask, ForecastIndex, ForecastIndexManagement, ForecastTaskManager> {
    private static final Logger LOG = LogManager.getLogger(ForecastResultProcessor.class);

    public ForecastResultProcessor(Setting<TimeValue> requestTimeoutSetting, float intervalRatioForRequests, String entityResultAction, StatNames hcRequestCountStat, Settings settings, ClusterService clusterService, ThreadPool threadPool, HashRing hashRing, NodeStateManager nodeStateManager, TransportService transportService, ForecastStats timeSeriesStats, ForecastTaskManager realTimeTaskManager, NamedXContentRegistry xContentRegistry, Client client, SecurityClientUtil clientUtil, IndexNameExpressionResolver indexNameExpressionResolver, Class<ForecastResultResponse> transportResultResponseClazz, FeatureManager featureManager, AnalysisType analysisType, boolean runOnce) {
        super(requestTimeoutSetting, intervalRatioForRequests, entityResultAction, hcRequestCountStat, settings, clusterService, threadPool, "forecast-threadpool", hashRing, nodeStateManager, transportService, timeSeriesStats, realTimeTaskManager, xContentRegistry, client, clientUtil, indexNameExpressionResolver, transportResultResponseClazz, featureManager, ForecastSettings.FORECAST_MAX_ENTITIES_PER_INTERVAL, ForecastSettings.FORECAST_PAGE_SIZE, analysisType, runOnce, ForecastSingleStreamResultAction.NAME);
    }

    @Override
    protected ForecastResultResponse createResultResponse(List<FeatureData> features, String error, Long rcfTotalUpdates, Long configInterval, Boolean isHC, String taskId) {
        return new ForecastResultResponse(features, error, rcfTotalUpdates, configInterval, isHC, taskId);
    }
}

