/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.executors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.opensearch.neuralsearch.executors.HybridQueryExecutorCollector;
import org.opensearch.neuralsearch.executors.HybridQueryExecutorCollectorManager;

public final class HybridQueryRewriteCollectorManager
implements HybridQueryExecutorCollectorManager<HybridQueryExecutorCollector> {
    @NonNull
    private IndexSearcher searcher;

    @Override
    public HybridQueryExecutorCollector<IndexSearcher, Map.Entry<Query, Boolean>> newCollector() {
        return HybridQueryExecutorCollector.newCollector(this.searcher);
    }

    public List<Query> getQueriesAfterRewrite(List<HybridQueryExecutorCollector<IndexSearcher, Map.Entry<Query, Boolean>>> collectors) {
        ArrayList<Query> rewrittenQueries = new ArrayList<Query>();
        for (HybridQueryExecutorCollector<IndexSearcher, Map.Entry<Query, Boolean>> collector : collectors) {
            if (collector.getResult().isPresent()) {
                rewrittenQueries.add(collector.getResult().get().getKey());
                continue;
            }
            rewrittenQueries.add(null);
        }
        return rewrittenQueries;
    }

    public boolean anyQueryRewrite(List<HybridQueryExecutorCollector<IndexSearcher, Map.Entry<Query, Boolean>>> collectors) {
        for (HybridQueryExecutorCollector<IndexSearcher, Map.Entry<Query, Boolean>> collector : collectors) {
            Optional<Map.Entry<Query, Boolean>> result = collector.getResult();
            if (!result.isPresent() || !result.get().getValue().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Generated
    public HybridQueryRewriteCollectorManager(@NonNull IndexSearcher searcher) {
        Objects.requireNonNull(searcher, "searcher is marked non-null but is null");
        this.searcher = searcher;
    }
}

