/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.securityanalytics.model.LogType;

public class GetMappingsViewResponse
extends ActionResponse
implements ToXContentObject {
    public static final String UNMAPPED_INDEX_FIELDS = "unmapped_index_fields";
    public static final String UNMAPPED_FIELD_ALIASES = "unmapped_field_aliases";
    public static final String THREAT_INTEL_FIELD_ALIASES = "threat_intel_field_aliases";
    private Map<String, Object> aliasMappings;
    List<String> unmappedIndexFields;
    List<String> unmappedFieldAliases;
    private List<LogType.IocFields> threatIntelFieldAliases;

    public GetMappingsViewResponse(Map<String, Object> aliasMappings, List<String> unmappedIndexFields, List<String> unmappedFieldAliases, List<LogType.IocFields> threatIntelFieldAliases) {
        this.aliasMappings = aliasMappings;
        this.unmappedIndexFields = unmappedIndexFields;
        this.unmappedFieldAliases = unmappedFieldAliases;
        this.threatIntelFieldAliases = threatIntelFieldAliases;
    }

    public GetMappingsViewResponse(StreamInput in) throws IOException {
        super(in);
        int unmappedFieldAliasesSize;
        int unmappedIndexFieldsSize;
        if (in.readBoolean()) {
            this.aliasMappings = in.readMap();
        }
        if ((unmappedIndexFieldsSize = in.readVInt()) > 0) {
            this.unmappedIndexFields = new ArrayList<String>(unmappedIndexFieldsSize);
            for (int i = 0; i < unmappedIndexFieldsSize; ++i) {
                this.unmappedIndexFields.add(in.readString());
            }
        }
        if ((unmappedFieldAliasesSize = in.readVInt()) > 0) {
            this.unmappedFieldAliases = new ArrayList<String>(unmappedFieldAliasesSize);
            for (int i = 0; i < unmappedFieldAliasesSize; ++i) {
                this.unmappedFieldAliases.add(in.readString());
            }
        }
        this.threatIntelFieldAliases = in.readList(LogType.IocFields::readFrom);
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.aliasMappings != null) {
            out.writeBoolean(true);
            out.writeMap(this.aliasMappings);
        } else {
            out.writeBoolean(false);
        }
        if (this.unmappedIndexFields != null) {
            out.writeVInt(this.unmappedIndexFields.size());
            for (String f : this.unmappedIndexFields) {
                out.writeString(f);
            }
        } else {
            out.writeVInt(0);
        }
        if (this.unmappedFieldAliases != null) {
            out.writeVInt(this.unmappedFieldAliases.size());
            for (String f : this.unmappedFieldAliases) {
                out.writeString(f);
            }
        } else {
            out.writeVInt(0);
        }
        if (this.threatIntelFieldAliases != null) {
            out.writeBoolean(true);
            out.writeCollection(this.threatIntelFieldAliases);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.aliasMappings != null && this.aliasMappings.size() > 0) {
            builder.field("properties", (Object)((Map)this.aliasMappings.get("properties")));
        }
        if (this.unmappedIndexFields != null && this.unmappedIndexFields.size() > 0) {
            builder.field(UNMAPPED_INDEX_FIELDS, this.unmappedIndexFields);
        }
        if (this.unmappedFieldAliases != null && this.unmappedFieldAliases.size() > 0) {
            builder.field(UNMAPPED_FIELD_ALIASES, this.unmappedFieldAliases);
        }
        if (this.threatIntelFieldAliases != null && !this.threatIntelFieldAliases.isEmpty()) {
            builder.field(THREAT_INTEL_FIELD_ALIASES, this.threatIntelFieldAliases);
        }
        return builder.endObject();
    }

    public Map<String, Object> aliasMappings() {
        return this.aliasMappings;
    }

    public List<String> unmappedFieldAliases() {
        return this.unmappedFieldAliases;
    }

    public List<String> unmappedIndexFields() {
        return this.unmappedIndexFields;
    }

    public Map<String, Object> getAliasMappings() {
        return this.aliasMappings;
    }

    public List<String> getUnmappedFieldAliases() {
        return this.unmappedFieldAliases;
    }

    public List<String> getUnmappedIndexFields() {
        return this.unmappedIndexFields;
    }

    public String toString() {
        return Strings.toString((MediaType)XContentType.JSON, (ToXContent)this);
    }

    public int hashCode() {
        return Objects.hash(this.aliasMappings, this.unmappedFieldAliases, this.unmappedIndexFields);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GetMappingsViewResponse other = (GetMappingsViewResponse)((Object)obj);
        return this.aliasMappings.equals(other.aliasMappings) && this.unmappedIndexFields.equals(other.unmappedIndexFields) && this.unmappedFieldAliases.equals(other.unmappedFieldAliases);
    }
}

