/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.commons.model.IOCType;
import org.opensearch.securityanalytics.model.STIX2IOC;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class STIX2IOCDto
implements Writeable,
ToXContentObject {
    private static final Logger logger = LogManager.getLogger(STIX2IOCDto.class);
    private String id;
    private String name;
    private IOCType type;
    private String value;
    private String severity;
    private Instant created;
    private Instant modified;
    private String description;
    private List<String> labels;
    private String specVersion;
    private String feedId;
    private String feedName;
    private long version;

    public STIX2IOCDto() {
    }

    public STIX2IOCDto(String id, String name, IOCType type, String value, String severity, Instant created, Instant modified, String description, List<String> labels, String specVersion, String feedId, String feedName, long version) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.value = value;
        this.severity = severity;
        this.created = created;
        this.modified = modified;
        this.description = description;
        this.labels = labels;
        this.specVersion = specVersion;
        this.feedId = feedId;
        this.feedName = feedName;
        this.version = version;
    }

    public STIX2IOCDto(STIX2IOC ioc) {
        this(ioc.getId(), ioc.getName(), ioc.getType(), ioc.getValue(), ioc.getSeverity(), ioc.getCreated(), ioc.getModified(), ioc.getDescription(), ioc.getLabels(), ioc.getSpecVersion(), ioc.getFeedId(), ioc.getFeedName(), ioc.getVersion());
    }

    public STIX2IOCDto(StreamInput sin) throws IOException {
        this(new STIX2IOC(sin));
    }

    public static STIX2IOCDto readFrom(StreamInput sin) throws IOException {
        return new STIX2IOCDto(sin);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.name);
        out.writeString(this.type.toString());
        out.writeString(this.value);
        out.writeString(this.severity);
        out.writeInstant(this.created);
        out.writeInstant(this.modified);
        out.writeString(this.description);
        out.writeStringCollection(this.labels);
        out.writeString(this.specVersion);
        out.writeString(this.feedId);
        out.writeString(this.feedName);
        out.writeLong(this.version);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field("id", this.id).field("name", this.name).field("type", this.type.toString()).field("value", this.value).field("severity", this.severity).timeField("created", (Object)this.created).timeField("modified", (Object)this.modified).field("description", this.description).field("labels", this.labels).field("spec_version", this.specVersion).field("feed_id", this.feedId).field("feed_name", this.feedName).field("version", this.version).endObject();
    }

    public static STIX2IOCDto parse(XContentParser xcp, String id, Long version) throws IOException {
        if (id == null) {
            id = "";
        }
        if (version == null) {
            version = 1L;
        }
        String name = null;
        IOCType type = null;
        String value = null;
        String severity = null;
        Instant created = null;
        Instant modified = null;
        String description = null;
        ArrayList<String> labels = new ArrayList<String>();
        String specVersion = null;
        String feedId = null;
        String feedName = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block32: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "id": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block32;
                    id = xcp.text();
                    continue block32;
                }
                case "version": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block32;
                    version = xcp.longValue();
                    continue block32;
                }
                case "name": {
                    name = xcp.text();
                    continue block32;
                }
                case "type": {
                    String typeString = xcp.text();
                    try {
                        type = new IOCType(typeString);
                        continue block32;
                    }
                    catch (Exception e) {
                        String error = String.format("Couldn't parse IOC type '%s' while deserializing STIX2IOCDto with ID '%s': ", typeString, id);
                        logger.error(error, (Throwable)e);
                        throw new SecurityAnalyticsException(error, RestStatus.BAD_REQUEST, e);
                    }
                }
                case "value": {
                    value = xcp.text();
                    continue block32;
                }
                case "severity": {
                    severity = xcp.text();
                    continue block32;
                }
                case "created": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        created = null;
                        continue block32;
                    }
                    if (xcp.currentToken().isValue()) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_STRING) {
                            created = Instant.parse(xcp.text());
                            continue block32;
                        }
                        if (xcp.currentToken() != XContentParser.Token.VALUE_NUMBER) continue block32;
                        created = Instant.ofEpochMilli(xcp.longValue());
                        continue block32;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    created = null;
                    continue block32;
                }
                case "modified": {
                    if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                        modified = null;
                        continue block32;
                    }
                    if (xcp.currentToken().isValue()) {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_STRING) {
                            modified = Instant.parse(xcp.text());
                            continue block32;
                        }
                        if (xcp.currentToken() != XContentParser.Token.VALUE_NUMBER) continue block32;
                        modified = Instant.ofEpochMilli(xcp.longValue());
                        continue block32;
                    }
                    XContentParserUtils.throwUnknownToken((XContentParser.Token)xcp.currentToken(), (XContentLocation)xcp.getTokenLocation());
                    modified = null;
                    continue block32;
                }
                case "description": {
                    description = xcp.text();
                    continue block32;
                }
                case "labels": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        String entry = xcp.textOrNull();
                        if (entry == null) continue;
                        labels.add(entry);
                    }
                    continue block32;
                }
                case "spec_version": {
                    specVersion = xcp.text();
                    continue block32;
                }
                case "feed_id": {
                    feedId = xcp.text();
                    continue block32;
                }
                case "feed_name": {
                    feedName = xcp.text();
                    continue block32;
                }
            }
            xcp.skipChildren();
        }
        return new STIX2IOCDto(id, name, type, value, severity, created, modified, description, labels, specVersion, feedId, feedName, version);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IOCType getType() {
        return this.type;
    }

    public void setType(IOCType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public Instant getCreated() {
        return this.created;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public Instant getModified() {
        return this.modified;
    }

    public void setModified(Instant modified) {
        this.modified = modified;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
}

