/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.resthandler;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.commons.alerting.model.Table;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.threatIntel.action.GetIocFindingsAction;
import org.opensearch.securityanalytics.threatIntel.action.GetIocFindingsRequest;

public class RestGetIocFindingsAction
extends BaseRestHandler {
    public String getName() {
        return "get_ioc_findings_action_sa";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String sortString = request.param("sortString", "timestamp");
        String sortOrder = request.param("sortOrder", "asc");
        String missing = request.param("missing");
        int size = request.paramAsInt("size", 20);
        int startIndex = request.paramAsInt("startIndex", 0);
        String searchString = request.param("searchString", "");
        List<String> findingIds = null;
        if (request.param("findingIds") != null) {
            findingIds = Arrays.asList(request.param("findingIds").split(","));
        }
        List<String> iocIds = null;
        if (request.param("iocIds") != null) {
            iocIds = Arrays.asList(request.param("iocIds").split(","));
        }
        Instant startTime = null;
        String startTimeParam = request.param("startTime");
        if (startTimeParam != null && !startTimeParam.isEmpty()) {
            try {
                startTime = Instant.ofEpochMilli(Long.parseLong(startTimeParam));
            }
            catch (NullPointerException | NumberFormatException | DateTimeException e) {
                startTime = Instant.now();
            }
        }
        Instant endTime = null;
        String endTimeParam = request.param("endTime");
        if (endTimeParam != null && !endTimeParam.isEmpty()) {
            try {
                endTime = Instant.ofEpochMilli(Long.parseLong(endTimeParam));
            }
            catch (NullPointerException | NumberFormatException | DateTimeException e) {
                endTime = Instant.now();
            }
        }
        Table table = new Table(sortOrder, sortString, missing, size, startIndex, searchString);
        GetIocFindingsRequest getIocFindingsRequest = new GetIocFindingsRequest(findingIds, iocIds, startTime, endTime, table);
        return channel -> client.execute((ActionType)GetIocFindingsAction.INSTANCE, (ActionRequest)getIocFindingsRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_security_analytics/threat_intel/findings/_search"));
    }
}

