/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.service;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.securityanalytics.model.STIX2IOC;
import org.opensearch.securityanalytics.model.STIX2IOCDto;
import org.opensearch.securityanalytics.services.STIX2IOCFetchService;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.common.SourceConfigType;
import org.opensearch.securityanalytics.threatIntel.common.TIFJobState;
import org.opensearch.securityanalytics.threatIntel.common.TIFLockService;
import org.opensearch.securityanalytics.threatIntel.model.DefaultIocStoreConfig;
import org.opensearch.securityanalytics.threatIntel.model.IocStoreConfig;
import org.opensearch.securityanalytics.threatIntel.model.IocUploadSource;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfig;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfigDto;
import org.opensearch.securityanalytics.threatIntel.service.SATIFSourceConfigService;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class SATIFSourceConfigManagementService {
    private static final Logger log = LogManager.getLogger(SATIFSourceConfigManagementService.class);
    private final SATIFSourceConfigService saTifSourceConfigService;
    private final TIFLockService lockService;
    private final STIX2IOCFetchService stix2IOCFetchService;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;

    @Inject
    public SATIFSourceConfigManagementService(SATIFSourceConfigService saTifSourceConfigService, TIFLockService lockService, STIX2IOCFetchService stix2IOCFetchService, NamedXContentRegistry xContentRegistry, ClusterService clusterService) {
        this.saTifSourceConfigService = saTifSourceConfigService;
        this.lockService = lockService;
        this.stix2IOCFetchService = stix2IOCFetchService;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
    }

    public void createOrUpdateTifSourceConfig(SATIFSourceConfigDto saTifSourceConfigDto, LockModel lock, RestRequest.Method restMethod, User user, ActionListener<SATIFSourceConfigDto> listener) {
        if (restMethod == RestRequest.Method.POST) {
            this.createIocAndTIFSourceConfig(saTifSourceConfigDto, lock, user, listener);
        } else if (restMethod == RestRequest.Method.PUT) {
            this.updateIocAndTIFSourceConfig(saTifSourceConfigDto, lock, user, listener);
        }
    }

    public void createIocAndTIFSourceConfig(SATIFSourceConfigDto saTifSourceConfigDto, LockModel lock, User createdByUser, ActionListener<SATIFSourceConfigDto> listener) {
        try {
            List<STIX2IOC> iocs;
            SATIFSourceConfig saTifSourceConfig = this.convertToSATIFConfig(saTifSourceConfigDto, null, TIFJobState.CREATING, createdByUser);
            if (saTifSourceConfig.getSource() instanceof IocUploadSource) {
                List<STIX2IOCDto> iocDtos = ((IocUploadSource)saTifSourceConfigDto.getSource()).getIocs();
                ((IocUploadSource)saTifSourceConfig.getSource()).setIocs(List.of());
                iocs = this.convertToIocs(iocDtos, saTifSourceConfig.getName(), saTifSourceConfig.getId());
            } else {
                iocs = null;
            }
            saTifSourceConfig.setLastRefreshedTime(Instant.now());
            saTifSourceConfig.setLastRefreshedUser(createdByUser);
            this.saTifSourceConfigService.indexTIFSourceConfig(saTifSourceConfig, lock, (ActionListener<SATIFSourceConfig>)ActionListener.wrap(indexSaTifSourceConfigResponse -> {
                log.debug("Indexed threat intel source config as CREATING for [{}]", (Object)indexSaTifSourceConfigResponse.getId());
                this.downloadAndSaveIOCs((SATIFSourceConfig)indexSaTifSourceConfigResponse, iocs, (ActionListener<STIX2IOCFetchService.STIX2IOCFetchResponse>)ActionListener.wrap(r -> this.markSourceConfigAsAction((SATIFSourceConfig)indexSaTifSourceConfigResponse, TIFJobState.AVAILABLE, (ActionListener<SATIFSourceConfig>)ActionListener.wrap(updateSaTifSourceConfigResponse -> {
                    log.debug("Updated threat intel source config as AVAILABLE for [{}]", (Object)indexSaTifSourceConfigResponse.getId());
                    SATIFSourceConfigDto returnedSaTifSourceConfigDto = new SATIFSourceConfigDto((SATIFSourceConfig)updateSaTifSourceConfigResponse);
                    listener.onResponse((Object)returnedSaTifSourceConfigDto);
                }, e -> {
                    log.error("Failed to index threat intel source config with id [{}]", (Object)indexSaTifSourceConfigResponse.getId());
                    listener.onFailure(e);
                })), e -> {
                    log.error("Failed to download and save IOCs for threat intel source config [{}]", (Object)indexSaTifSourceConfigResponse.getId());
                    this.saTifSourceConfigService.deleteTIFSourceConfig((SATIFSourceConfig)indexSaTifSourceConfigResponse, (ActionListener<DeleteResponse>)ActionListener.wrap(deleteResponse -> {
                        log.debug("Successfully deleted threat intel source config [{}]", (Object)indexSaTifSourceConfigResponse.getId());
                        listener.onFailure(e);
                    }, ex -> {
                        log.error("Failed to delete threat intel source config [{}]", (Object)indexSaTifSourceConfigResponse.getId());
                        listener.onFailure(ex);
                    }));
                }));
            }, e -> {
                log.error("Failed to index threat intel source config with id [{}]", (Object)saTifSourceConfig.getId());
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to create IOCs and threat intel source config");
            listener.onFailure(e2);
        }
    }

    public void downloadAndSaveIOCs(SATIFSourceConfig saTifSourceConfig, List<STIX2IOC> stix2IOCList, ActionListener<STIX2IOCFetchService.STIX2IOCFetchResponse> actionListener) {
        switch (saTifSourceConfig.getType()) {
            case S3_CUSTOM: {
                this.stix2IOCFetchService.downloadAndIndexIOCs(saTifSourceConfig, actionListener);
                break;
            }
            case URL_DOWNLOAD: {
                this.stix2IOCFetchService.downloadFromUrlAndIndexIOCs(saTifSourceConfig, actionListener);
                break;
            }
            case IOC_UPLOAD: {
                ArrayList<STIX2IOC> validStix2IocList = new ArrayList<STIX2IOC>();
                for (STIX2IOC stix2IOC : stix2IOCList) {
                    if (saTifSourceConfig.getIocTypes().contains(stix2IOC.getType().toString())) {
                        validStix2IocList.add(stix2IOC);
                        continue;
                    }
                    log.error("{} is not a supported Ioc type for threat intel source config {}. Skipping IOC {}: of type {} value {}", (Object)stix2IOC.getType().toString(), (Object)saTifSourceConfig.getId(), (Object)stix2IOC.getId(), (Object)stix2IOC.getType().toString(), (Object)stix2IOC.getValue());
                }
                if (validStix2IocList.isEmpty()) {
                    log.error("No supported IOCs to index");
                    actionListener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("No compatible Iocs were uploaded for threat intel source config " + saTifSourceConfig.getName(), RestStatus.BAD_REQUEST, new Object[0]))));
                    return;
                }
                this.stix2IOCFetchService.onlyIndexIocs(saTifSourceConfig, validStix2IocList, actionListener);
            }
        }
    }

    public void getTIFSourceConfig(String saTifSourceConfigId, ActionListener<SATIFSourceConfigDto> listener) {
        this.saTifSourceConfigService.getTIFSourceConfig(saTifSourceConfigId, (ActionListener<SATIFSourceConfig>)ActionListener.wrap(saTifSourceConfigResponse -> {
            SATIFSourceConfigDto returnedSaTifSourceConfigDto = new SATIFSourceConfigDto((SATIFSourceConfig)saTifSourceConfigResponse);
            listener.onResponse((Object)returnedSaTifSourceConfigDto);
        }, e -> {
            log.error("Failed to get threat intel source config for [{}]", (Object)saTifSourceConfigId);
            listener.onFailure(e);
        }));
    }

    public void searchTIFSourceConfigs(SearchSourceBuilder searchSourceBuilder, ActionListener<SearchResponse> listener) {
        try {
            this.saTifSourceConfigService.searchTIFSourceConfigs(searchSourceBuilder, (ActionListener<SearchResponse>)ActionListener.wrap(searchResponse -> {
                for (SearchHit hit : searchResponse.getHits()) {
                    XContentParser xcp = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                    SATIFSourceConfigDto satifSourceConfigDto = SATIFSourceConfigDto.docParse(xcp, hit.getId(), hit.getVersion());
                    XContentBuilder xcb = satifSourceConfigDto.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);
                    hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
                }
                listener.onResponse(searchResponse);
            }, e -> {
                log.error("Failed to fetch all threat intel source configs for search request [{}]", (Object)searchSourceBuilder, e);
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to search and parse all threat intel source configs");
            listener.onFailure(e2);
        }
    }

    public void updateIocAndTIFSourceConfig(SATIFSourceConfigDto saTifSourceConfigDto, LockModel lock, User updatedByUser, ActionListener<SATIFSourceConfigDto> listener) {
        try {
            this.saTifSourceConfigService.getTIFSourceConfig(saTifSourceConfigDto.getId(), (ActionListener<SATIFSourceConfig>)ActionListener.wrap(retrievedSaTifSourceConfig -> {
                List<STIX2IOC> iocs;
                if (!TIFJobState.AVAILABLE.equals((Object)retrievedSaTifSourceConfig.getState()) && !TIFJobState.REFRESH_FAILED.equals((Object)retrievedSaTifSourceConfig.getState())) {
                    log.error("Invalid threat intel source config state. Expecting {} or {} but received {}", (Object)TIFJobState.AVAILABLE, (Object)TIFJobState.REFRESH_FAILED, (Object)retrievedSaTifSourceConfig.getState());
                    listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "Invalid threat intel source config state. Expecting %s or %s but received %s", new Object[]{TIFJobState.AVAILABLE, TIFJobState.REFRESH_FAILED, retrievedSaTifSourceConfig.getState()}), RestStatus.BAD_REQUEST, new Object[0]))));
                    return;
                }
                if (!saTifSourceConfigDto.getType().equals((Object)retrievedSaTifSourceConfig.getType())) {
                    log.error("Unable to update threat intel source config, type cannot change from {} to {}", (Object)retrievedSaTifSourceConfig.getType(), (Object)saTifSourceConfigDto.getType());
                    listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "Unable to update threat intel source config, type cannot change from %s to %s", new Object[]{retrievedSaTifSourceConfig.getType(), saTifSourceConfigDto.getType()}), RestStatus.BAD_REQUEST, new Object[0]))));
                    return;
                }
                SATIFSourceConfig updatedSaTifSourceConfig = this.updateSaTifSourceConfig(saTifSourceConfigDto, (SATIFSourceConfig)retrievedSaTifSourceConfig);
                if (updatedSaTifSourceConfig.getSource() instanceof IocUploadSource) {
                    List<STIX2IOCDto> iocDtos = ((IocUploadSource)saTifSourceConfigDto.getSource()).getIocs();
                    ((IocUploadSource)updatedSaTifSourceConfig.getSource()).setIocs(List.of());
                    iocs = this.convertToIocs(iocDtos, updatedSaTifSourceConfig.getName(), updatedSaTifSourceConfig.getId());
                } else {
                    iocs = null;
                }
                updatedSaTifSourceConfig.setLastRefreshedTime(Instant.now());
                updatedSaTifSourceConfig.setLastRefreshedUser(updatedByUser);
                this.markSourceConfigAsAction(updatedSaTifSourceConfig, TIFJobState.REFRESHING, (ActionListener<SATIFSourceConfig>)ActionListener.wrap(r -> {
                    log.info("Set threat intel source config as REFRESHING for [{}]", (Object)updatedSaTifSourceConfig.getId());
                    switch (updatedSaTifSourceConfig.getType()) {
                        case S3_CUSTOM: {
                            this.downloadAndSaveIocsToRefresh(listener, updatedSaTifSourceConfig, null);
                            break;
                        }
                        case IOC_UPLOAD: {
                            this.downloadAndSaveIocsToRefresh(listener, updatedSaTifSourceConfig, iocs);
                        }
                    }
                }, e -> {
                    log.error("Failed to set threat intel source config as REFRESH_FAILED for [{}]", (Object)updatedSaTifSourceConfig.getId());
                    listener.onFailure(e);
                }));
            }, e -> {
                log.error("Failed to get threat intel source config for [{}]", (Object)saTifSourceConfigDto.getId());
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to update IOCs and threat intel source config for [{}]", (Object)saTifSourceConfigDto.getId());
            listener.onFailure(e2);
        }
    }

    public void internalUpdateTIFSourceConfig(SATIFSourceConfig saTifSourceConfig, ActionListener<SATIFSourceConfig> listener) {
        try {
            saTifSourceConfig.setLastUpdateTime(Instant.now());
            this.saTifSourceConfigService.updateTIFSourceConfig(saTifSourceConfig, listener);
        }
        catch (Exception e) {
            log.error("Failed to update threat intel source config [{}]", (Object)saTifSourceConfig.getId());
            listener.onFailure(e);
        }
    }

    public void refreshTIFSourceConfig(String saTifSourceConfigId, User user, ActionListener<SATIFSourceConfigDto> listener) {
        this.saTifSourceConfigService.getTIFSourceConfig(saTifSourceConfigId, (ActionListener<SATIFSourceConfig>)ActionListener.wrap(saTifSourceConfig -> {
            if (saTifSourceConfig.getType() == SourceConfigType.IOC_UPLOAD) {
                log.error("Unable to refresh threat intel source config [{}] with a source type of [{}]", (Object)saTifSourceConfig.getId(), (Object)SourceConfigType.IOC_UPLOAD);
                listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "Unable to refresh threat intel source config [%s] with a source type of [%s]", new Object[]{saTifSourceConfig.getId(), SourceConfigType.IOC_UPLOAD}), RestStatus.BAD_REQUEST, new Object[0]))));
                return;
            }
            if (!TIFJobState.AVAILABLE.equals((Object)saTifSourceConfig.getState()) && !TIFJobState.REFRESH_FAILED.equals((Object)saTifSourceConfig.getState())) {
                log.error("Invalid threat intel source config state. Expecting {} or {} but received {}", (Object)TIFJobState.AVAILABLE, (Object)TIFJobState.REFRESH_FAILED, (Object)saTifSourceConfig.getState());
                listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "Invalid threat intel source config state. Expecting %s or %s but received %s", new Object[]{TIFJobState.AVAILABLE, TIFJobState.REFRESH_FAILED, saTifSourceConfig.getState()}), RestStatus.BAD_REQUEST, new Object[0]))));
                return;
            }
            if (user != null) {
                saTifSourceConfig.setLastRefreshedUser(user);
            }
            log.debug("Refreshing IOCs and updating threat intel source config");
            saTifSourceConfig.setLastRefreshedTime(Instant.now());
            this.markSourceConfigAsAction((SATIFSourceConfig)saTifSourceConfig, TIFJobState.REFRESHING, (ActionListener<SATIFSourceConfig>)ActionListener.wrap(updatedSourceConfig -> this.downloadAndSaveIocsToRefresh(listener, (SATIFSourceConfig)updatedSourceConfig, null), e -> {
                log.error("Failed to set threat intel source config as REFRESHING for [{}]", (Object)saTifSourceConfig.getId());
                listener.onFailure(e);
            }));
        }, e -> {
            log.error("Failed to get threat intel source config [{}]", (Object)saTifSourceConfigId);
            listener.onFailure(e);
        }));
    }

    private void downloadAndSaveIocsToRefresh(ActionListener<SATIFSourceConfigDto> listener, SATIFSourceConfig updatedSourceConfig, List<STIX2IOC> stix2IOCList) {
        this.downloadAndSaveIOCs(updatedSourceConfig, stix2IOCList, (ActionListener<STIX2IOCFetchService.STIX2IOCFetchResponse>)ActionListener.wrap(response -> this.deleteOldIocIndices(updatedSourceConfig, (ActionListener<IocStoreConfig>)ActionListener.wrap(newIocStoreConfig -> this.markSourceConfigAsAction(updatedSourceConfig, TIFJobState.AVAILABLE, (ActionListener<SATIFSourceConfig>)ActionListener.wrap(r -> {
            log.debug("Set threat intel source config as AVAILABLE for [{}]", (Object)updatedSourceConfig.getId());
            SATIFSourceConfigDto returnedSaTifSourceConfigDto = new SATIFSourceConfigDto(updatedSourceConfig);
            listener.onResponse((Object)returnedSaTifSourceConfigDto);
        }, ex -> {
            log.error("Failed to set threat intel source config as AVAILABLE for [{}]", (Object)updatedSourceConfig.getId());
            listener.onFailure(ex);
        })), deleteIocIndicesError -> {
            log.error("Failed to delete old IOC indices", (Throwable)deleteIocIndicesError);
            listener.onFailure(deleteIocIndicesError);
        })), downloadAndSaveIocsError -> {
            log.error("Failed to download and save IOCs for threat intel source config [{}]", (Object)updatedSourceConfig.getId(), downloadAndSaveIocsError);
            this.markSourceConfigAsAction(updatedSourceConfig, TIFJobState.REFRESH_FAILED, (ActionListener<SATIFSourceConfig>)ActionListener.wrap(r -> {
                log.info("Set threat intel source config as REFRESH_FAILED for [{}]", (Object)updatedSourceConfig.getId());
                listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap(new OpenSearchException(String.format(Locale.getDefault(), "Failed to download and save IOCs for threat intel source config [%s]. Set source config as REFRESH_FAILED", updatedSourceConfig.getId()), (Throwable)downloadAndSaveIocsError, new Object[0]))));
            }, ex -> {
                log.error("Failed to set threat intel source config as REFRESH_FAILED for [{}]", (Object)updatedSourceConfig.getId());
                listener.onFailure(ex);
            }));
        }));
    }

    public void deleteTIFSourceConfig(String saTifSourceConfigId, ActionListener<DeleteResponse> listener) {
        this.saTifSourceConfigService.getTIFSourceConfig(saTifSourceConfigId, (ActionListener<SATIFSourceConfig>)ActionListener.wrap(saTifSourceConfig -> {
            if (SourceConfigType.URL_DOWNLOAD.equals((Object)saTifSourceConfig.getType())) {
                log.error("Cannot delete tif source config {} as it's a built-in config and not user-defined.", (Object)saTifSourceConfigId);
                listener.onFailure((Exception)new IllegalArgumentException("Cannot delete built-in tif source config " + saTifSourceConfigId));
                return;
            }
            this.saTifSourceConfigService.checkAndEnsureThreatIntelMonitorsDeleted((ActionListener<Boolean>)ActionListener.wrap(isDeleted -> this.deleteAllIocsAndSourceConfig(saTifSourceConfigId, listener, (SATIFSourceConfig)saTifSourceConfig, (Boolean)isDeleted), e -> {
                log.error("Failed to check if all threat intel monitors are deleted or if multiple threat intel source configs exist");
                listener.onFailure(e);
            }));
        }, e -> {
            log.error("Failed to get threat intel source config for [{}]", (Object)saTifSourceConfigId);
            if (e instanceof IndexNotFoundException) {
                listener.onFailure((Exception)((Object)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException(String.format(Locale.getDefault(), "Threat intel source config [%s] not found.", saTifSourceConfigId), RestStatus.NOT_FOUND, new Object[0]))));
            } else {
                listener.onFailure(e);
            }
        }));
    }

    public void deleteOldIocIndices(SATIFSourceConfig saTifSourceConfig, ActionListener<IocStoreConfig> listener) {
        HashSet activeIndices = new HashSet();
        IocStoreConfig iocStoreConfig = saTifSourceConfig.getIocStoreConfig();
        HashSet iocIndexPatterns = new HashSet();
        if (iocStoreConfig instanceof DefaultIocStoreConfig) {
            DefaultIocStoreConfig defaultIocStoreConfig = (DefaultIocStoreConfig)saTifSourceConfig.getIocStoreConfig();
            defaultIocStoreConfig.getIocToIndexDetails().forEach(e -> activeIndices.add(e.getActiveIndex()));
            defaultIocStoreConfig.getIocToIndexDetails().forEach(e -> iocIndexPatterns.add(e.getIndexPattern()));
        }
        this.saTifSourceConfigService.getClusterState((ActionListener<ClusterStateResponse>)ActionListener.wrap(clusterStateResponse -> {
            Set<String> concreteIndices = SATIFSourceConfigService.getConcreteIndices(clusterStateResponse);
            List<String> indicesToDeleteByAge = this.getIocIndicesToDeleteByAge(clusterStateResponse.getState(), activeIndices);
            List<String> indicesToDeleteBySize = this.getIocIndicesToDeleteBySize(clusterStateResponse.getState(), indicesToDeleteByAge.size(), activeIndices, concreteIndices);
            HashSet<String> iocIndicesToDelete = new HashSet<String>();
            iocIndicesToDelete.addAll(indicesToDeleteByAge);
            iocIndicesToDelete.addAll(indicesToDeleteBySize);
            this.saTifSourceConfigService.deleteAllIocIndices(iocIndicesToDelete, true, null);
            listener.onResponse((Object)iocStoreConfig);
        }, e -> {
            log.error("Failed to get the cluster metadata");
            listener.onFailure(e);
        }), iocIndexPatterns.toArray(new String[0]));
    }

    private List<String> getIocIndicesToDeleteByAge(ClusterState clusterState, Set<String> activeIndices) {
        ArrayList<String> indicesToDelete = new ArrayList<String>();
        Long maxRetentionPeriod = ((TimeValue)this.clusterService.getClusterSettings().get(SecurityAnalyticsSettings.IOC_INDEX_RETENTION_PERIOD)).millis();
        for (IndexMetadata indexMetadata : clusterState.metadata().indices().values()) {
            String indexToDelete;
            Long creationTime = indexMetadata.getCreationDate();
            if (Instant.now().toEpochMilli() - creationTime <= maxRetentionPeriod || activeIndices.contains(indexToDelete = indexMetadata.getIndex().getName())) continue;
            indicesToDelete.add(indexToDelete);
        }
        return indicesToDelete;
    }

    private List<String> getIocIndicesToDeleteBySize(ClusterState clusterState, Integer totalNumIndicesDeleteByAge, Set<String> activeIndices, Set<String> concreteIndices) {
        Integer numIndicesToDelete = this.numOfIndicesToDelete(concreteIndices.size(), totalNumIndicesDeleteByAge);
        ArrayList<String> indicesToDelete = new ArrayList<String>();
        if (numIndicesToDelete > 0) {
            LinkedHashMap<String, Long> indexToAgeMap = new LinkedHashMap<String, Long>();
            SortedMap lookup = clusterState.getMetadata().getIndicesLookup();
            for (String indexName : concreteIndices) {
                IndexAbstraction index = (IndexAbstraction)lookup.get(indexName);
                IndexMetadata indexMetadata = clusterState.getMetadata().index(indexName);
                if (index == null || index.getType() != IndexAbstraction.Type.CONCRETE_INDEX) continue;
                indexToAgeMap.putIfAbsent(indexName, indexMetadata.getCreationDate());
            }
            ArrayList sortedList = new ArrayList(indexToAgeMap.entrySet());
            sortedList.sort(Map.Entry.comparingByValue());
            int endIndex = totalNumIndicesDeleteByAge + numIndicesToDelete;
            endIndex = Math.min(endIndex, concreteIndices.size());
            for (int i = totalNumIndicesDeleteByAge.intValue(); i < endIndex; ++i) {
                if (activeIndices.contains(((Map.Entry)sortedList.get(i)).getKey())) continue;
                indicesToDelete.add((String)((Map.Entry)sortedList.get(i)).getKey());
            }
        }
        return indicesToDelete;
    }

    private Integer numOfIndicesToDelete(Integer totalNumIndices, Integer totalNumIndicesDeleteByAge) {
        Integer maxIndicesPerIndexPattern = (Integer)this.clusterService.getClusterSettings().get(SecurityAnalyticsSettings.IOC_MAX_INDICES_PER_INDEX_PATTERN);
        Integer numIndicesAfterDeletingByAge = totalNumIndices - totalNumIndicesDeleteByAge;
        if (numIndicesAfterDeletingByAge > maxIndicesPerIndexPattern) {
            return numIndicesAfterDeletingByAge - maxIndicesPerIndexPattern;
        }
        return 0;
    }

    private void deleteAllIocsAndSourceConfig(String saTifSourceConfigId, ActionListener<DeleteResponse> listener, SATIFSourceConfig saTifSourceConfig, Boolean isDeleted) {
        if (!isDeleted.booleanValue()) {
            listener.onFailure((Exception)new IllegalArgumentException("All threat intel monitors need to be deleted before deleting last threat intel source config"));
        } else {
            log.debug("All threat intel monitors are deleted or multiple threat intel source configs exist, can delete threat intel source config [{}]", (Object)saTifSourceConfigId);
            this.markSourceConfigAsAction(saTifSourceConfig, TIFJobState.DELETING, (ActionListener<SATIFSourceConfig>)ActionListener.wrap(updateSaTifSourceConfigResponse -> {
                HashSet iocIndexPatterns = new HashSet();
                if (saTifSourceConfig.getIocStoreConfig() instanceof DefaultIocStoreConfig) {
                    DefaultIocStoreConfig defaultIocStoreConfig = (DefaultIocStoreConfig)saTifSourceConfig.getIocStoreConfig();
                    defaultIocStoreConfig.getIocToIndexDetails().forEach(e -> iocIndexPatterns.add(e.getIndexPattern()));
                }
                this.saTifSourceConfigService.getClusterState((ActionListener<ClusterStateResponse>)ActionListener.wrap(clusterStateResponse -> {
                    Set<String> concreteIndices = SATIFSourceConfigService.getConcreteIndices(clusterStateResponse);
                    this.saTifSourceConfigService.deleteAllIocIndices(concreteIndices, false, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(r -> {
                        log.debug("Successfully deleted all ioc indices");
                        this.saTifSourceConfigService.deleteTIFSourceConfig((SATIFSourceConfig)updateSaTifSourceConfigResponse, (ActionListener<DeleteResponse>)ActionListener.wrap(deleteResponse -> {
                            log.debug("Successfully deleted threat intel source config [{}]", (Object)updateSaTifSourceConfigResponse.getId());
                            listener.onResponse(deleteResponse);
                        }, e -> {
                            log.error("Failed to delete threat intel source config [{}]", (Object)saTifSourceConfigId);
                            listener.onFailure(e);
                        }));
                    }, e -> {
                        log.error("Failed to delete IOC indices for threat intel source config [{}]", (Object)updateSaTifSourceConfigResponse.getId());
                        listener.onFailure(e);
                    }));
                }, e -> {
                    log.error("Failed to get the cluster metadata");
                    listener.onFailure(e);
                }), iocIndexPatterns.toArray(new String[0]));
            }, e -> {
                log.error("Failed to update threat intel source config with state as {}", (Object)TIFJobState.DELETING);
                listener.onFailure(e);
            }));
        }
    }

    public void markSourceConfigAsAction(SATIFSourceConfig saTifSourceConfig, TIFJobState state, ActionListener<SATIFSourceConfig> actionListener) {
        TIFJobState previousState = saTifSourceConfig.getState();
        saTifSourceConfig.setState(state);
        try {
            this.internalUpdateTIFSourceConfig(saTifSourceConfig, actionListener);
        }
        catch (Exception e) {
            log.error("Failed to mark threat intel source config from {} to {} for [{}]", (Object)previousState, (Object)state, (Object)saTifSourceConfig.getId(), (Object)e);
            actionListener.onFailure(e);
        }
    }

    public SATIFSourceConfig convertToSATIFConfig(SATIFSourceConfigDto saTifSourceConfigDto, IocStoreConfig iocStoreConfig, TIFJobState state, User createdByUser) {
        LinkedHashSet<String> iocTypes = new LinkedHashSet<String>(saTifSourceConfigDto.getIocTypes());
        return new SATIFSourceConfig(saTifSourceConfigDto.getId(), saTifSourceConfigDto.getVersion(), saTifSourceConfigDto.getName(), saTifSourceConfigDto.getFormat(), saTifSourceConfigDto.getType(), saTifSourceConfigDto.getDescription(), createdByUser, saTifSourceConfigDto.getCreatedAt(), saTifSourceConfigDto.getSource(), saTifSourceConfigDto.getEnabledTime(), saTifSourceConfigDto.getLastUpdateTime(), saTifSourceConfigDto.getSchedule(), state, saTifSourceConfigDto.getRefreshType(), saTifSourceConfigDto.getLastRefreshedTime(), saTifSourceConfigDto.getLastRefreshedUser(), saTifSourceConfigDto.isEnabled(), iocStoreConfig, new ArrayList<String>(iocTypes), saTifSourceConfigDto.isEnabledForScan());
    }

    private SATIFSourceConfig updateSaTifSourceConfig(SATIFSourceConfigDto saTifSourceConfigDto, SATIFSourceConfig saTifSourceConfig) {
        if (SourceConfigType.URL_DOWNLOAD.equals((Object)saTifSourceConfig.getType())) {
            return new SATIFSourceConfig(saTifSourceConfig.getId(), saTifSourceConfig.getVersion(), saTifSourceConfig.getName(), saTifSourceConfig.getFormat(), saTifSourceConfig.getType(), saTifSourceConfig.getDescription(), saTifSourceConfig.getCreatedByUser(), saTifSourceConfig.getCreatedAt(), saTifSourceConfig.getSource(), saTifSourceConfig.getEnabledTime(), saTifSourceConfig.getLastUpdateTime(), saTifSourceConfig.getSchedule(), saTifSourceConfig.getState(), saTifSourceConfig.getRefreshType(), saTifSourceConfig.getLastRefreshedTime(), saTifSourceConfig.getLastRefreshedUser(), saTifSourceConfig.isEnabled(), saTifSourceConfig.getIocStoreConfig(), saTifSourceConfig.getIocTypes(), saTifSourceConfigDto.isEnabledForScan());
        }
        if (!saTifSourceConfig.getSource().getClass().equals(saTifSourceConfigDto.getSource().getClass())) {
            throw new IllegalArgumentException("");
        }
        LinkedHashSet<String> iocTypes = new LinkedHashSet<String>(saTifSourceConfigDto.getIocTypes());
        return new SATIFSourceConfig(saTifSourceConfig.getId(), saTifSourceConfig.getVersion(), saTifSourceConfigDto.getName(), saTifSourceConfigDto.getFormat(), saTifSourceConfig.getType(), saTifSourceConfigDto.getDescription(), saTifSourceConfig.getCreatedByUser(), saTifSourceConfig.getCreatedAt(), saTifSourceConfigDto.getSource(), saTifSourceConfig.getEnabledTime(), saTifSourceConfig.getLastUpdateTime(), saTifSourceConfigDto.getSchedule(), saTifSourceConfig.getState(), saTifSourceConfigDto.getRefreshType(), saTifSourceConfig.getLastRefreshedTime(), saTifSourceConfig.getLastRefreshedUser(), saTifSourceConfigDto.isEnabled(), saTifSourceConfig.getIocStoreConfig(), new ArrayList<String>(iocTypes), saTifSourceConfigDto.isEnabledForScan());
    }

    public List<STIX2IOC> convertToIocs(List<STIX2IOCDto> stix2IocDtoList, String name, String id) {
        if (stix2IocDtoList == null) {
            return null;
        }
        return stix2IocDtoList.stream().map(dto -> new STIX2IOC((STIX2IOCDto)dto, id, name)).collect(Collectors.toList());
    }
}

