/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.testutils;

import com.amazon.randomcutforest.testutils.MultiDimDataWithKey;
import java.util.Arrays;
import java.util.Random;

public class NormalMixtureTestData {
    private final double baseMu;
    private final double baseSigma;
    private final double anomalyMu;
    private final double anomalySigma;
    private final double transitionToAnomalyProbability;
    private final double transitionToBaseProbability;

    public NormalMixtureTestData(double baseMu, double baseSigma, double anomalyMu, double anomalySigma, double transitionToAnomalyProbability, double transitionToBaseProbability) {
        this.baseMu = baseMu;
        this.baseSigma = baseSigma;
        this.anomalyMu = anomalyMu;
        this.anomalySigma = anomalySigma;
        this.transitionToAnomalyProbability = transitionToAnomalyProbability;
        this.transitionToBaseProbability = transitionToBaseProbability;
    }

    public NormalMixtureTestData() {
        this(0.0, 1.0, 4.0, 2.0, 0.01, 0.3);
    }

    public NormalMixtureTestData(double baseMu, double anomalyMu) {
        this(baseMu, 1.0, anomalyMu, 2.0, 0.01, 0.3);
    }

    public double[][] generateTestData(int numberOfRows, int numberOfColumns) {
        return this.generateTestData(numberOfRows, numberOfColumns, 0);
    }

    public double[][] generateTestData(int numberOfRows, int numberOfColumns, int seed) {
        double[][] result = new double[numberOfRows][numberOfColumns];
        boolean anomaly = false;
        NormalDistribution dist = seed != 0 ? new NormalDistribution(new Random(seed)) : new NormalDistribution(new Random());
        for (int i = 0; i < numberOfRows; ++i) {
            if (!anomaly) {
                this.fillRow(result[i], dist, this.baseMu, this.baseSigma);
                if (!(Math.random() < this.transitionToAnomalyProbability)) continue;
                anomaly = true;
                continue;
            }
            this.fillRow(result[i], dist, this.anomalyMu, this.anomalySigma);
            if (!(Math.random() < this.transitionToBaseProbability)) continue;
            anomaly = false;
        }
        return result;
    }

    public MultiDimDataWithKey generateTestDataWithKey(int numberOfRows, int numberOfColumns, int seed) {
        double[][] resultData = new double[numberOfRows][numberOfColumns];
        int[] change = new int[numberOfRows];
        int numberOfChanges = 0;
        boolean anomaly = false;
        NormalDistribution dist = seed != 0 ? new NormalDistribution(new Random(seed)) : new NormalDistribution(new Random());
        for (int i = 0; i < numberOfRows; ++i) {
            if (!anomaly) {
                this.fillRow(resultData[i], dist, this.baseMu, this.baseSigma);
                if (!(Math.random() < this.transitionToAnomalyProbability)) continue;
                change[numberOfChanges++] = i + 1;
                anomaly = true;
                continue;
            }
            this.fillRow(resultData[i], dist, this.anomalyMu, this.anomalySigma);
            if (!(Math.random() < this.transitionToBaseProbability)) continue;
            anomaly = false;
            change[numberOfChanges++] = i + 1;
        }
        return new MultiDimDataWithKey(resultData, Arrays.copyOf(change, numberOfChanges), null);
    }

    private void fillRow(double[] row, NormalDistribution dist, double mu, double sigma) {
        for (int j = 0; j < row.length; ++j) {
            row[j] = dist.nextDouble(mu, sigma);
        }
    }

    static class NormalDistribution {
        private final Random rng;
        private final double[] buffer;
        private int index;

        NormalDistribution(Random rng) {
            this.rng = rng;
            this.buffer = new double[2];
            this.index = 0;
        }

        double nextDouble() {
            if (this.index == 0) {
                double u = this.rng.nextDouble();
                double v = this.rng.nextDouble();
                double r = Math.sqrt(-2.0 * Math.log(u));
                this.buffer[0] = r * Math.cos(Math.PI * 2 * v);
                this.buffer[1] = r * Math.sin(Math.PI * 2 * v);
            }
            double result = this.buffer[this.index];
            this.index = (this.index + 1) % 2;
            return result;
        }

        double nextDouble(double mu, double sigma) {
            return mu + sigma * this.nextDouble();
        }
    }
}

