/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.Segment;

public class RTextAreaDocument
extends AbstractDocument {
    public static final String tabSizeAttribute = "tabSize";
    private AbstractDocument.BranchElement root;
    private Vector added = new Vector();
    private Vector removed = new Vector();
    private transient Segment s;

    public RTextAreaDocument() {
        this(new GapContent());
    }

    public RTextAreaDocument(AbstractDocument.Content content) {
        super(content);
        this.putProperty(tabSizeAttribute, new Integer(5));
        this.root = this.createDefaultRoot();
        this.s = new Segment();
    }

    public Element getDefaultRootElement() {
        return this.root;
    }

    protected AbstractDocument.BranchElement createDefaultRoot() {
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.createBranchElement(null, null);
        Element element = this.createLeafElement(branchElement, null, 0, 1);
        Element[] elementArray = new Element[]{element};
        branchElement.replace(0, 0, elementArray);
        return branchElement;
    }

    public Element getParagraphElement(int n) {
        return this.root.getElement(this.root.getElementIndex(n));
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        this.removed.removeAllElements();
        this.added.removeAllElements();
        int n = defaultDocumentEvent.getOffset();
        int n2 = defaultDocumentEvent.getLength();
        if (n > 0) {
            --n;
            ++n2;
        }
        int n3 = this.root.getElementIndex(n);
        Element element = this.root.getElement(n3);
        int n4 = element.getStartOffset();
        int n5 = element.getEndOffset();
        int n6 = n4;
        try {
            int n7;
            this.getContent().getChars(n, n2, this.s);
            boolean bl = false;
            for (n7 = 0; n7 < n2; ++n7) {
                char c = this.s.array[this.s.offset + n7];
                if (c != '\n') continue;
                int n8 = n + n7 + 1;
                this.added.addElement(this.createLeafElement(this.root, null, n6, n8));
                n6 = n8;
                bl = true;
            }
            if (bl) {
                n7 = 1;
                this.removed.addElement(element);
                if (n + n2 == n5 && n6 != n5 && n3 + 1 < this.root.getElementCount()) {
                    ++n7;
                    Element element2 = this.root.getElement(n3 + 1);
                    this.removed.addElement(element2);
                    n5 = element2.getEndOffset();
                }
                if (n6 < n5) {
                    this.added.addElement(this.createLeafElement(this.root, null, n6, n5));
                }
                Object[] objectArray = new Element[this.added.size()];
                this.added.copyInto(objectArray);
                Object[] objectArray2 = new Element[this.removed.size()];
                this.removed.copyInto(objectArray2);
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(this.root, n3, (Element[])objectArray2, (Element[])objectArray);
                defaultDocumentEvent.addEdit(elementEdit);
                this.root.replace(n3, objectArray2.length, (Element[])objectArray);
            }
        }
        catch (BadLocationException badLocationException) {
            throw new Error("Internal error: " + badLocationException.toString());
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        this.removed.removeAllElements();
        int n = defaultDocumentEvent.getOffset();
        int n2 = defaultDocumentEvent.getLength();
        int n3 = this.root.getElementIndex(n);
        int n4 = this.root.getElementIndex(n + n2);
        if (n3 != n4) {
            int n5;
            for (n5 = n3; n5 <= n4; ++n5) {
                this.removed.addElement(this.root.getElement(n5));
            }
            n5 = this.root.getElement(n3).getStartOffset();
            int n6 = this.root.getElement(n4).getEndOffset();
            Element[] elementArray = new Element[]{this.createLeafElement(this.root, null, n5, n6)};
            Object[] objectArray = new Element[this.removed.size()];
            this.removed.copyInto(objectArray);
            AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(this.root, n3, (Element[])objectArray, elementArray);
            defaultDocumentEvent.addEdit(elementEdit);
            this.root.replace(n3, objectArray.length, elementArray);
        }
        super.removeUpdate(defaultDocumentEvent);
    }
}

