/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import org.pentaho.di.core.Const;

public class PluginVersion {
    public static final int UNKNOWN_MAJOR_VERSION = 2;
    public static final int UNKNOWN_MINOR_VERSION = 2;
    public static final int UNKNOWN_POINT_VERSION = 0;
    public static final int DEFAULT_MAJOR_VERSION = 3;
    public static final int DEFAULT_MINOR_VERSION = 0;
    public static final int DEFAULT_POINT_VERSION = 0;
    private int majorVersion;
    private int minorVersion;
    private int pointVersion;
    public static PluginVersion UNKNOWN_VERSION = new PluginVersion(2, 2, 0);
    public static PluginVersion DEFAULT_VERSION = new PluginVersion(3, 0, 0);

    public PluginVersion(int majorVersion, int minorVersion, int pointVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.pointVersion = pointVersion;
    }

    public String toString() {
        return this.majorVersion + "." + this.minorVersion + "." + this.pointVersion;
    }

    public static PluginVersion fromString(String versionString) {
        if (Const.isEmpty(versionString)) {
            return UNKNOWN_VERSION;
        }
        String[] strings = versionString.split("\\.");
        int majorVersion = Integer.parseInt(strings[0]);
        int minorVersion = strings.length > 1 ? Integer.parseInt(strings[1]) : 0;
        int pointVersion = strings.length > 2 ? Integer.parseInt(strings[2]) : 0;
        return new PluginVersion(majorVersion, minorVersion, pointVersion);
    }

    public boolean isCompatible() {
        return this.majorVersion == 3;
    }

    public boolean isMoreRecentThan(PluginVersion version) {
        if (this.majorVersion > version.majorVersion) {
            return true;
        }
        if (this.majorVersion == version.majorVersion) {
            if (this.minorVersion > version.minorVersion) {
                return true;
            }
            if (this.minorVersion == version.minorVersion && this.pointVersion > version.pointVersion) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(PluginVersion version) {
        return this.majorVersion == version.majorVersion && this.minorVersion == version.minorVersion && this.pointVersion == version.pointVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getPointVersion() {
        return this.pointVersion;
    }

    public void setPointVersion(int pointVersion) {
        this.pointVersion = pointVersion;
    }
}

