/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.ObjectWithId;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Introspector;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;

public abstract class FreeColObject
implements Comparable<FreeColObject>,
ObjectWithId {
    protected static final Logger logger = Logger.getLogger(FreeColObject.class.getName());
    public static final Comparator<? super FreeColObject> fcoComparator = new Comparator<FreeColObject>(){

        @Override
        public int compare(FreeColObject fco1, FreeColObject fco2) {
            return FreeColObject.compareIds(fco1, fco2);
        }
    };
    protected static final int DEFAULT_CLASS_INDEX = 1000;
    private String id;
    private PropertyChangeSupport pcs = null;
    public static final String ID_ATTRIBUTE_TAG = "id";
    public static final String ARRAY_SIZE_TAG = "xLength";
    public static final String PARTIAL_ATTRIBUTE_TAG = "partial";
    protected static final String VALUE_TAG = "value";

    public static <T extends FreeColObject> Class<T> getFreeColObjectClassByName(String name) {
        String type = "net.sf.freecol.common.model." + StringUtils.capitalize(name);
        Class<?> c = Introspector.getClassByName(type);
        if (c != null) {
            return c;
        }
        logger.warning("getFreeColObjectClass could not find: " + type);
        return null;
    }

    public <T extends FreeColObject> Class<T> getFreeColObjectClass() {
        return this.getClass();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public boolean idEquals(FreeColObject other) {
        return other != null && this.id != null && this.id.equals(other.getId());
    }

    public final String getSuffix(String prefix) {
        return this.getId().startsWith(prefix) ? this.getId().substring(prefix.length()) : this.getId();
    }

    public final String getSuffix() {
        String id = this.getId();
        return id == null ? null : StringUtils.lastPart(id, ".");
    }

    public static String getIdTypeByName(String id) {
        if (id != null) {
            int col = id.lastIndexOf(58);
            return col >= 0 ? id.substring(0, col) : id;
        }
        return null;
    }

    public String getIdType() {
        return FreeColObject.getIdTypeByName(this.getId());
    }

    public int getIdNumber() {
        int col;
        if (this.id != null && (col = this.id.lastIndexOf(58)) >= 0) {
            String s = this.id.substring(col + 1);
            if (s.startsWith("am")) {
                s = s.substring(2);
            }
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static int compareIds(FreeColObject fco1, FreeColObject fco2) {
        if (fco1 == null) {
            return fco2 == null ? 0 : -1;
        }
        if (fco2 == null) {
            return 1;
        }
        String id1 = fco1.getId();
        String id2 = fco2.getId();
        if (id1 == null) {
            return id2 == null ? 0 : -1;
        }
        if (id2 == null) {
            return 1;
        }
        int cmp = fco1.getIdType().compareTo(fco2.getIdType());
        return cmp > 0 ? 1 : (cmp < 0 ? -1 : Integer.compare(fco1.getIdNumber(), fco2.getIdNumber()));
    }

    public int getClassIndex() {
        return 1000;
    }

    public static int getObjectClassIndex(Object o) {
        return o instanceof FreeColObject ? ((FreeColObject)o).getClassIndex() : 1000;
    }

    public Specification getSpecification() {
        return null;
    }

    protected void setSpecification(Specification specification) {
    }

    public Game getGame() {
        return null;
    }

    public void setGame(Game game) {
    }

    protected PropertyChangeSupport getPropertyChangeSupport() {
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        if (this.pcs != null) {
            this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        }
    }

    public void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        if (this.pcs != null) {
            this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        }
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        if (this.pcs != null) {
            this.pcs.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        }
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(event);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs == null ? new PropertyChangeListener[]{} : this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs == null ? new PropertyChangeListener[]{} : this.pcs.getPropertyChangeListeners(propertyName);
    }

    public boolean hasListeners(String propertyName) {
        return this.pcs == null ? false : this.pcs.hasListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyName, listener);
        }
    }

    public FeatureContainer getFeatureContainer() {
        return null;
    }

    public final boolean hasAbility(String id) {
        return this.hasAbility(id, null);
    }

    public final boolean hasAbility(String id, FreeColSpecObjectType fcgot) {
        return this.hasAbility(id, fcgot, null);
    }

    public final boolean hasAbility(String id, FreeColSpecObjectType fcgot, Turn turn) {
        return FeatureContainer.allAbilities(this.getAbilities(id, fcgot, turn));
    }

    public boolean containsAbilityKey(String key) {
        return CollectionUtils.first(this.getAbilities(key, null, null)) != null;
    }

    public final List<Ability> getSortedAbilities() {
        return CollectionUtils.sort(this.getAbilities());
    }

    public final Stream<Ability> getAbilities() {
        return this.getAbilities(null);
    }

    public final Stream<Ability> getAbilities(String id) {
        return this.getAbilities(id, null);
    }

    public final Stream<Ability> getAbilities(String id, FreeColSpecObjectType fcgot) {
        return this.getAbilities(id, fcgot, null);
    }

    public Stream<Ability> getAbilities(String id, FreeColSpecObjectType fcgot, Turn turn) {
        FeatureContainer fc = this.getFeatureContainer();
        return fc == null ? Stream.empty() : fc.getAbilities(id, fcgot, turn);
    }

    public boolean addAbility(Ability ability) {
        FeatureContainer fc = this.getFeatureContainer();
        return fc == null ? false : fc.addAbility(ability);
    }

    public Ability removeAbility(Ability ability) {
        FeatureContainer fc = this.getFeatureContainer();
        return fc == null ? null : fc.removeAbility(ability);
    }

    public void removeAbilities(String id) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc != null) {
            fc.removeAbilities(id);
        }
    }

    public final boolean hasModifier(String id) {
        return this.hasModifier(id, null);
    }

    public final boolean hasModifier(String id, FreeColSpecObjectType fcgot) {
        return this.hasModifier(id, fcgot, null);
    }

    public boolean hasModifier(String id, FreeColSpecObjectType fcgot, Turn turn) {
        return CollectionUtils.any(this.getModifiers(id, fcgot, turn));
    }

    public final boolean containsModifierKey(String key) {
        return CollectionUtils.any(this.getModifiers(key));
    }

    public final List<Modifier> getSortedModifiers() {
        return CollectionUtils.sort(this.getModifiers(), Modifier.ascendingModifierIndexComparator);
    }

    public final Stream<Modifier> getModifiers() {
        FeatureContainer fc = this.getFeatureContainer();
        return fc == null ? Stream.empty() : fc.getModifierValues().stream();
    }

    public final Stream<Modifier> getModifiers(String id) {
        return this.getModifiers(id, null);
    }

    public final Stream<Modifier> getModifiers(String id, FreeColSpecObjectType fcgot) {
        return this.getModifiers(id, fcgot, null);
    }

    public Stream<Modifier> getModifiers(String id, FreeColSpecObjectType fcgot, Turn turn) {
        FeatureContainer fc = this.getFeatureContainer();
        return fc == null ? Stream.empty() : fc.getModifiers(id, fcgot, turn);
    }

    public final float apply(float number, Turn turn, String id) {
        return this.apply(number, turn, id, null);
    }

    public final float apply(float number, Turn turn, String id, FreeColSpecObjectType fcgot) {
        return FreeColObject.applyModifiers(number, turn, this.getModifiers(id, fcgot, turn));
    }

    public static final float applyModifiers(float number, Turn turn, Stream<Modifier> mods) {
        return FeatureContainer.applyModifiers(number, turn, mods);
    }

    public static final float applyModifiers(float number, Turn turn, Collection<Modifier> mods) {
        return FeatureContainer.applyModifiers(number, turn, mods);
    }

    public boolean addModifier(Modifier modifier) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc == null) {
            return false;
        }
        return fc.addModifier(modifier);
    }

    public Modifier removeModifier(Modifier modifier) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc == null) {
            return null;
        }
        return fc.removeModifier(modifier);
    }

    public void removeModifiers(String id) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc != null) {
            fc.removeModifiers(id);
        }
    }

    public void addFeatures(FreeColObject fco) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc != null) {
            fc.addFeatures(fco);
        }
    }

    public void removeFeatures(FreeColObject fco) {
        FeatureContainer fc = this.getFeatureContainer();
        if (fc != null) {
            fc.removeFeatures(fco);
        }
    }

    public List<Modifier> getDefenceModifiers() {
        return CollectionUtils.toList(this.getModifiers("model.modifier.defence"));
    }

    @Override
    public int compareTo(FreeColObject other) {
        return FreeColObject.compareIds(this, other);
    }

    public static <T extends FreeColObject> void logFreeColObjects(Collection<T> c, LogBuilder lb) {
        lb.add("[");
        for (FreeColObject t : c) {
            lb.add(t.getSuffix(), " ");
        }
        lb.shrink(" ");
        lb.add("]");
    }

    protected <T> T invokeMethod(String methodName, Class<T> returnClass, T defaultValue) {
        if (methodName != null && returnClass != null) {
            try {
                return Introspector.invokeMethod(this, methodName, returnClass);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Invoke failed: " + methodName, ex);
            }
        }
        return defaultValue;
    }

    public FreeColObject getDisplayObject() {
        return this;
    }

    public void dumpObject() {
        this.save(System.err, FreeColXMLWriter.WriteScope.toSave(), false);
    }

    public boolean save(File file) {
        return this.save(file, FreeColXMLWriter.WriteScope.toSave());
    }

    public boolean save(File file, FreeColXMLWriter.WriteScope scope) {
        return this.save(file, scope, false);
    }

    public boolean save(File file, FreeColXMLWriter.WriteScope scope, boolean pretty) {
        boolean bl;
        block8: {
            OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);
            try {
                bl = this.save(fos, scope, pretty);
                if (fos == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Error creating output stream", ioe);
                    return false;
                }
            }
            fos.close();
        }
        return bl;
    }

    public boolean save(OutputStream out, FreeColXMLWriter.WriteScope scope, boolean pretty) {
        boolean ret = false;
        if (scope == null) {
            scope = FreeColXMLWriter.WriteScope.toSave();
        }
        try (FreeColXMLWriter xw = new FreeColXMLWriter(out, scope, pretty);){
            xw.writeStartDocument("UTF-8", "1.0");
            this.toXML(xw);
            xw.writeEndDocument();
            ret = true;
        }
        catch (XMLStreamException xse) {
            logger.log(Level.WARNING, "Exception writing object.", xse);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error creating FreeColXMLWriter.", ioe);
        }
        return ret;
    }

    public String serialize() throws XMLStreamException {
        return this.serialize(FreeColXMLWriter.WriteScope.toServer());
    }

    public String serialize(Player player) throws XMLStreamException {
        return this.serialize(FreeColXMLWriter.WriteScope.toClient(player));
    }

    public String serialize(FreeColXMLWriter.WriteScope scope) throws XMLStreamException {
        return this.serialize(scope, null);
    }

    public String serialize(FreeColXMLWriter.WriteScope scope, List<String> fields) throws XMLStreamException {
        StringWriter sw = new StringWriter();
        try (FreeColXMLWriter xw = new FreeColXMLWriter(sw, scope);){
            if (fields == null) {
                this.toXML(xw);
            } else {
                this.toXMLPartial(xw, fields);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Error creating FreeColXMLWriter,", ioe);
            return null;
        }
        return sw.toString();
    }

    public <T extends FreeColObject> T copy(Game game) {
        Class<?> returnClass = this.getClass();
        return (T)this.copy(game, returnClass);
    }

    public <T extends FreeColObject> T copy(Game game, Player player) {
        Class<?> returnClass = this.getClass();
        return (T)this.copy(game, returnClass, player);
    }

    public <T extends FreeColObject> T copy(Game game, Class<T> returnClass) {
        T ret = null;
        try (FreeColXMLReader xr = new FreeColXMLReader(new StringReader(this.serialize()));){
            ret = xr.copy(game, returnClass);
        }
        catch (XMLStreamException xse) {
            logger.log(Level.WARNING, "Copy of " + this.getId() + " to " + returnClass.getName() + "failed", xse);
        }
        return ret;
    }

    public <T extends FreeColObject> T copy(Game game, Class<T> returnClass, Player player) {
        T ret = null;
        try (FreeColXMLReader xr = new FreeColXMLReader(new StringReader(this.serialize(player)));){
            ret = xr.copy(game, returnClass);
        }
        catch (XMLStreamException xse) {
            logger.log(Level.WARNING, "Copy of " + this.getId() + " to " + returnClass.getName() + " for " + player.getId() + "failed", xse);
        }
        return ret;
    }

    public <T extends FreeColObject> boolean copyIn(T other) {
        FreeColObject fco = this.copyInCast(other, FreeColObject.class);
        if (fco == null) {
            return false;
        }
        for (PropertyChangeListener pcl : fco.getPropertyChangeListeners()) {
            fco.removePropertyChangeListener(pcl);
            this.addPropertyChangeListener(pcl);
        }
        return true;
    }

    protected <T extends FreeColObject, R extends FreeColObject> R copyInCast(T other, Class<R> returnClass) {
        if (other == null) {
            return (R)((FreeColObject)null);
        }
        if (!this.idEquals(other)) {
            logger.warning("copyInCast " + other.getId() + " onto " + this.getId());
            return (R)((FreeColObject)null);
        }
        try {
            return (R)((FreeColObject)returnClass.cast(other));
        }
        catch (ClassCastException classCastException) {
            return (R)((FreeColObject)null);
        }
    }

    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        this.toXML(xw, this.getXMLTagName());
    }

    public void toXML(FreeColXMLWriter xw, String tag) throws XMLStreamException {
        xw.writeStartElement(tag);
        this.writeAttributes(xw);
        this.writeChildren(xw);
        xw.writeEndElement();
    }

    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.getId() == null) {
            logger.warning("FreeColObject with null identifier: " + this);
        } else {
            xw.writeAttribute(ID_ATTRIBUTE_TAG, this.getId());
        }
    }

    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
    }

    public final void toXMLPartial(FreeColXMLWriter xw, String[] fields) throws XMLStreamException {
        Class<?> theClass = this.getClass();
        xw.writeStartElement(this.getXMLTagName());
        xw.writeAttribute(ID_ATTRIBUTE_TAG, this.getId());
        xw.writeAttribute(PARTIAL_ATTRIBUTE_TAG, true);
        for (String field : fields) {
            Introspector intro = new Introspector(theClass, field);
            try {
                String value = intro.getter(this);
                xw.writeAttribute(field, value);
            }
            catch (Introspector.IntrospectorException ie) {
                logger.log(Level.WARNING, "Failed to write field: " + field, ie);
            }
        }
        xw.writeEndElement();
    }

    public final void toXMLPartial(FreeColXMLWriter xw, List<String> fields) throws XMLStreamException {
        Class<?> theClass = this.getClass();
        try {
            xw.writeStartElement(this.getXMLTagName());
            xw.writeAttribute(ID_ATTRIBUTE_TAG, this.getId());
            xw.writeAttribute(PARTIAL_ATTRIBUTE_TAG, true);
            int n = fields.size();
            for (int i = 0; i < n - 1; i += 2) {
                xw.writeAttribute(fields.get(i), fields.get(i + 1));
            }
            xw.writeEndElement();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Partial write failed for " + theClass.getName(), e);
        }
    }

    public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.hasAttribute(PARTIAL_ATTRIBUTE_TAG)) {
            this.readFromXMLPartial(xr);
        } else {
            this.readAttributes(xr);
            this.readChildren(xr);
        }
    }

    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        String newId = xr.readId();
        if (newId != null) {
            this.setId(newId);
        }
    }

    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (tag == null) {
            throw new XMLStreamException("Parse error, null opening tag: " + this);
        }
        try {
            while (xr.moreTags()) {
                this.readChild(xr);
            }
        }
        catch (XMLStreamException xse) {
            logger.log(Level.SEVERE, "nextTag failed at " + tag, xse);
        }
        xr.expectTag(tag);
    }

    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        xr.unexpectedTag(this.getXMLTagName());
    }

    public final void readFromXMLPartial(FreeColXMLReader xr) throws XMLStreamException {
        Class<?> theClass = this.getClass();
        String tag = xr.getLocalName();
        int n = xr.getAttributeCount();
        this.setId(xr.readId());
        for (int i = 0; i < n; ++i) {
            String name = xr.getAttributeLocalName(i);
            if (ID_ATTRIBUTE_TAG.equals(name) || PARTIAL_ATTRIBUTE_TAG.equals(name)) continue;
            try {
                Introspector intro = new Introspector(theClass, name);
                intro.setter(this, xr.getAttributeValue(i));
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not set field " + name, e);
            }
        }
        xr.closeTag(tag);
    }

    public static String arrayKey(int i) {
        return "x" + String.valueOf(i);
    }

    public abstract String getXMLTagName();

    public boolean equals(Object o) {
        if (o instanceof FreeColObject) {
            FreeColObject other = (FreeColObject)o;
            return Utils.equals(this.id, other.id);
        }
        return false;
    }

    public int hashCode() {
        return Utils.hashCode(this.id);
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getId();
    }
}

