/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.util.test.FreeColTestCase;

public class IndianSettlementTest
extends FreeColTestCase {
    private static final GoodsType horsesType = IndianSettlementTest.spec().getGoodsType("model.goods.horses");
    private static final GoodsType musketsType = IndianSettlementTest.spec().getGoodsType("model.goods.muskets");
    private static final Role armedBraveRole = IndianSettlementTest.spec().getRole("model.role.armedBrave");
    private static final Role nativeDragoonRole = IndianSettlementTest.spec().getRole("model.role.nativeDragoon");

    public void testAutomaticEquipBraves() {
        Game game = IndianSettlementTest.getStandardGame();
        Map map = IndianSettlementTest.getTestMap();
        game.changeMap(map);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.initialBravesInCamp(1).build();
        Unit indianBrave = camp.getUnitList().get(0);
        IndianSettlementTest.assertNull((String)"No auto-equip, no muskets", (Object)indianBrave.getAutomaticRole());
        camp.addGoods(musketsType, 100);
        IndianSettlementTest.assertEquals((String)"Auto-equip to armed brave, muskets present", (Object)armedBraveRole, (Object)indianBrave.getAutomaticRole());
        camp.addGoods(horsesType, 100);
        IndianSettlementTest.assertEquals((String)"Auto-equip to native dragoon, horses and muskets present", (Object)nativeDragoonRole, (Object)indianBrave.getAutomaticRole());
    }

    public void testSettlementDoesNotOwnWaterTiles() {
        Game game = IndianSettlementTest.getStandardGame();
        Map map = IndianSettlementTest.getCoastTestMap(IndianSettlementTest.spec().getTileType("model.tile.plains"));
        game.changeMap(map);
        Tile campTile = map.getTile(9, 9);
        Tile landTile = map.getTile(8, 9);
        Tile waterTile = map.getTile(10, 9);
        IndianSettlementTest.assertTrue((String)"Setup error, camp tile should be land", (boolean)campTile.isLand());
        IndianSettlementTest.assertTrue((String)"Setup error, tile should be land", (boolean)landTile.isLand());
        IndianSettlementTest.assertFalse((String)"Setup error, tile should be water", (boolean)waterTile.isLand());
        IndianSettlementTest.assertTrue((String)"Setup error, tiles should be adjacent", (boolean)campTile.isAdjacent(waterTile));
        IndianSettlementTest.assertTrue((String)"Setup error, tiles should be adjacent", (boolean)campTile.isAdjacent(landTile));
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.settlementTile(campTile).build();
        Player indianPlayer = camp.getOwner();
        IndianSettlementTest.assertTrue((String)"Indian player should own camp tile", (campTile.getOwner() == indianPlayer ? 1 : 0) != 0);
        IndianSettlementTest.assertTrue((String)"Indian player should own land tile", (landTile.getOwner() == indianPlayer ? 1 : 0) != 0);
        IndianSettlementTest.assertFalse((String)"Indian player should not own water tile", (waterTile.getOwner() == indianPlayer ? 1 : 0) != 0);
    }

    public void testTradeGoodsWithSetlement() {
        Game game = IndianSettlementTest.getStandardGame();
        Map map = IndianSettlementTest.getTestMap();
        game.changeMap(map);
        Tile camp2Tile = map.getTile(3, 3);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp1 = builder.build();
        IndianSettlement camp2 = builder.reset().settlementTile(camp2Tile).build();
        int notEnoughToShare = 50;
        int enoughToShare = 100;
        boolean none = false;
        camp1.addGoods(horsesType, 50);
        camp1.addGoods(musketsType, 100);
        String wrongQtyMusketsMsg = "Wrong quantity of muskets";
        String wrongQtyHorsesMsg = "Wrong quantity of horses";
        IndianSettlementTest.assertEquals((String)wrongQtyMusketsMsg, (int)100, (int)camp1.getGoodsCount(musketsType));
        IndianSettlementTest.assertEquals((String)wrongQtyHorsesMsg, (int)50, (int)camp1.getGoodsCount(horsesType));
        IndianSettlementTest.assertEquals((String)wrongQtyMusketsMsg, (int)0, (int)camp2.getGoodsCount(musketsType));
        IndianSettlementTest.assertEquals((String)wrongQtyHorsesMsg, (int)0, (int)camp2.getGoodsCount(horsesType));
        camp1.tradeGoodsWithSettlement(camp2);
        IndianSettlementTest.assertEquals((String)wrongQtyMusketsMsg, (int)50, (int)camp1.getGoodsCount(musketsType));
        IndianSettlementTest.assertEquals((String)wrongQtyHorsesMsg, (int)50, (int)camp1.getGoodsCount(horsesType));
        IndianSettlementTest.assertEquals((String)wrongQtyMusketsMsg, (int)50, (int)camp2.getGoodsCount(musketsType));
        IndianSettlementTest.assertEquals((String)wrongQtyHorsesMsg, (int)0, (int)camp2.getGoodsCount(horsesType));
    }
}

