/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;

public class InciteMessage
extends AttributeMessage {
    public static final String TAG = "incite";
    private static final String ENEMY_TAG = "enemy";
    private static final String GOLD_TAG = "gold";
    private static final String SETTLEMENT_TAG = "settlement";
    private static final String UNIT_TAG = "unit";

    public InciteMessage(Unit unit, IndianSettlement is, Player enemy, int gold) {
        super(TAG, UNIT_TAG, unit.getId(), SETTLEMENT_TAG, is.getId(), ENEMY_TAG, enemy.getId(), GOLD_TAG, String.valueOf(gold));
    }

    public InciteMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, UNIT_TAG, SETTLEMENT_TAG, ENEMY_TAG, GOLD_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Player player = freeColClient.getMyPlayer();
        Unit unit = this.getUnit(player);
        IndianSettlement is = this.getSettlement(unit);
        Player enemy = this.getEnemy(game);
        int gold = this.getGold();
        this.igc(freeColClient).inciteHandler(unit, is, enemy, gold);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        IndianSettlement is;
        ServerUnit unit;
        ServerGame game = freeColServer.getGame();
        try {
            unit = (ServerUnit)this.getUnit(serverPlayer);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        try {
            is = this.getSettlement(unit);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        Player enemy = this.getEnemy(game);
        if (enemy == null) {
            return serverPlayer.clientError("Not a player: " + this.getStringAttribute(ENEMY_TAG));
        }
        if (enemy == serverPlayer) {
            return serverPlayer.clientError("Inciting against oneself!");
        }
        if (!enemy.isEuropean()) {
            return serverPlayer.clientError("Inciting against non-European!");
        }
        Unit.MoveType type = unit.getMoveType(is.getTile());
        if (type != Unit.MoveType.ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY) {
            return serverPlayer.clientError("Unable to enter " + is.getName() + ": " + type.whyIllegal());
        }
        int gold = this.getGold();
        return this.igc(freeColServer).incite(serverPlayer, unit, is, enemy, gold);
    }

    public Unit getUnit(Player player) {
        return player.getOurFreeColGameObject(this.getStringAttribute(UNIT_TAG), Unit.class);
    }

    public IndianSettlement getSettlement(Unit unit) {
        return unit.getAdjacentSettlement(this.getStringAttribute(SETTLEMENT_TAG), IndianSettlement.class);
    }

    public Player getEnemy(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(ENEMY_TAG), Player.class);
    }

    public int getGold() {
        return this.getIntegerAttribute(GOLD_TAG, -1);
    }
}

