/*
 * Decompiled with CFR 0.152.
 */
package training.lang;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.impl.OpenProjectTaskKt;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangSupport;
import training.learn.exceptons.NoSdkException;
import training.project.FileUtils;
import training.project.ProjectUtils;
import training.project.ReadMeCreator;
import training.util.OnboardingFeedbackData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J=\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152!\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00110\u0017H\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u001a\u0010&\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u001c\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u00152\b\u0010.\u001a\u0004\u0018\u00010,H\u0016J\u0018\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0015H\u0016J\u0010\u00101\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0015H\u0016J\b\u00102\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0016\u0010'\u001a\u0004\u0018\u00010(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u00063"}, d2={"Ltraining/lang/AbstractLangSupport;", "Ltraining/lang/LangSupport;", "<init>", "()V", "contentRootDirectoryName", "", "getContentRootDirectoryName", "()Ljava/lang/String;", "getProjectFilePath", "projectName", "onboardingFeedbackData", "Ltraining/util/OnboardingFeedbackData;", "getOnboardingFeedbackData", "()Ltraining/util/OnboardingFeedbackData;", "setOnboardingFeedbackData", "(Ltraining/util/OnboardingFeedbackData;)V", "installAndOpenLearningProject", "", "contentRoot", "Ljava/nio/file/Path;", "projectToClose", "Lcom/intellij/openapi/project/Project;", "postInitCallback", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "learnProject", "openOrImportLearningProject", "projectRootDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "openProjectTask", "Lcom/intellij/ide/impl/OpenProjectTask;", "copyLearningProjectFiles", "", "projectDirectory", "Ljava/io/File;", "destinationFilter", "Ljava/io/FileFilter;", "copyGeneratedFiles", "readMeCreator", "Ltraining/project/ReadMeCreator;", "getReadMeCreator", "()Ltraining/project/ReadMeCreator;", "getSdkForProject", "Lcom/intellij/openapi/projectRoots/Sdk;", "project", "selectedSdk", "applyProjectSdk", "sdk", "cleanupBeforeLessons", "toString", "intellij.featuresTrainer"})
public abstract class AbstractLangSupport
implements LangSupport {
    @Nullable
    private OnboardingFeedbackData onboardingFeedbackData;
    @Nullable
    private final ReadMeCreator readMeCreator;

    @Override
    @NotNull
    public String getContentRootDirectoryName() {
        return "LearnProject";
    }

    @Override
    @NotNull
    public String getProjectFilePath(@NotNull String projectName) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        return ProjectUtil.getBaseDir() + File.separator + projectName;
    }

    @Override
    @Nullable
    public OnboardingFeedbackData getOnboardingFeedbackData() {
        return this.onboardingFeedbackData;
    }

    @Override
    public void setOnboardingFeedbackData(@Nullable OnboardingFeedbackData onboardingFeedbackData) {
        this.onboardingFeedbackData = onboardingFeedbackData;
    }

    @Override
    public void installAndOpenLearningProject(@NotNull Path contentRoot, @Nullable Project projectToClose, @NotNull Function1<? super Project, Unit> postInitCallback) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        Intrinsics.checkNotNullParameter(postInitCallback, (String)"postInitCallback");
        ProjectUtils.INSTANCE.simpleInstallAndOpenLearningProject(contentRoot, this, OpenProjectTaskKt.OpenProjectTask(arg_0 -> AbstractLangSupport.installAndOpenLearningProject$lambda$0(projectToClose, arg_0)), postInitCallback);
    }

    @Override
    @NotNull
    public Project openOrImportLearningProject(@NotNull VirtualFile projectRootDirectory, @NotNull OpenProjectTask openProjectTask) {
        Intrinsics.checkNotNullParameter((Object)projectRootDirectory, (String)"projectRootDirectory");
        Intrinsics.checkNotNullParameter((Object)openProjectTask, (String)"openProjectTask");
        Path path = projectRootDirectory.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path nioPath = path;
        Project project = ProjectUtil.openOrImport((Path)nioPath, (OpenProjectTask)openProjectTask);
        if (project == null) {
            throw new IllegalStateException(("Cannot create project for " + this.getPrimaryLanguage() + " at " + nioPath).toString());
        }
        return project;
    }

    @Override
    public boolean copyLearningProjectFiles(@NotNull File projectDirectory, @Nullable FileFilter destinationFilter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        URL inputUrl = ProjectUtils.INSTANCE.learningProjectUrl(this);
        boolean it = bl = FileUtils.INSTANCE.copyResourcesRecursively(inputUrl, projectDirectory, destinationFilter);
        boolean bl2 = false;
        if (it) {
            this.copyGeneratedFiles(projectDirectory, destinationFilter);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyGeneratedFiles(File projectDirectory, FileFilter destinationFilter) {
        ReadMeCreator generator = this.getReadMeCreator();
        if (generator != null) {
            File readme = new File(projectDirectory, "README.md");
            if (destinationFilter == null || destinationFilter.accept(readme)) {
                Closeable closeable = new PrintWriter(readme, StandardCharsets.UTF_8);
                Throwable throwable = null;
                try {
                    PrintWriter it = (PrintWriter)closeable;
                    boolean bl = false;
                    it.print(generator.createReadmeMdText());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
    }

    @Nullable
    public ReadMeCreator getReadMeCreator() {
        return this.readMeCreator;
    }

    @Override
    @Nullable
    public Sdk getSdkForProject(@NotNull Project project, @Nullable Sdk selectedSdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            this.checkSdk(null, project);
            return null;
        }
        catch (Throwable throwable) {
            return (Sdk)ApplicationManager.getApplication().runReadAction(() -> AbstractLangSupport.getSdkForProject$lambda$4(this, project));
        }
    }

    @Override
    public void applyProjectSdk(@NotNull Sdk sdk, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CommandProcessor.getInstance().executeCommand(project, () -> AbstractLangSupport.applyProjectSdk$lambda$6(project, sdk), null, null);
    }

    @Override
    public void cleanupBeforeLessons(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectUtils.INSTANCE.restoreProject(this, project);
    }

    @NotNull
    public String toString() {
        return this.getPrimaryLanguage();
    }

    private static final Unit installAndOpenLearningProject$lambda$0(Project $projectToClose, OpenProjectTaskBuilder $this$OpenProjectTask) {
        Intrinsics.checkNotNullParameter((Object)$this$OpenProjectTask, (String)"$this$OpenProjectTask");
        $this$OpenProjectTask.setProjectToClose($projectToClose);
        return Unit.INSTANCE;
    }

    private static final Sdk getSdkForProject$lambda$4(AbstractLangSupport this$0, Project $project) {
        Sdk sdkOrNull;
        Object object;
        block4: {
            Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
            Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getAllJdks(...)");
            for (Object object2 : (Object[])sdkArray) {
                boolean bl;
                Sdk it = (Sdk)object2;
                boolean bl2 = false;
                try {
                    this$0.checkSdk(it, $project);
                    bl = true;
                }
                catch (Throwable e) {
                    bl = false;
                }
                if (!bl) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        Sdk sdk = sdkOrNull = (Sdk)object;
        if (sdk == null) {
            throw new NoSdkException();
        }
        return sdk;
    }

    private static final void applyProjectSdk$lambda$6$lambda$5(Project $project, Sdk $sdk) {
        ProjectRootManagerEx rootManager = ProjectRootManagerEx.getInstanceEx((Project)$project);
        rootManager.setProjectSdk($sdk);
    }

    private static final void applyProjectSdk$lambda$6(Project $project, Sdk $sdk) {
        ApplicationManager.getApplication().runWriteAction(() -> AbstractLangSupport.applyProjectSdk$lambda$6$lambda$5($project, $sdk));
    }
}

