/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.java;

public final class JVMFlags {
    public static final JVMFlags EMPTY = new JVMFlags(0);
    private static final int LOCAL_MASK = 0x1000000;
    private static final int ANON_MASK = 0x2000000;
    private static final int GENERATED_MASK = 0x4000000;
    private static final int SEALED_MASK = 0x8000000;
    private final int myFlags;

    public JVMFlags(int access) {
        this.myFlags = access;
    }

    public JVMFlags deriveIsLocal() {
        return new JVMFlags(this.myFlags | 0x1000000);
    }

    public JVMFlags deriveIsAnonymous() {
        return new JVMFlags(this.myFlags | 0x2000000);
    }

    public JVMFlags deriveIsGenerated() {
        return new JVMFlags(this.myFlags | 0x4000000);
    }

    public JVMFlags deriveIsSealed() {
        return new JVMFlags(this.myFlags | 0x8000000);
    }

    public JVMFlags deriveAdded(JVMFlags past) {
        return new JVMFlags(~past.myFlags & this.myFlags);
    }

    public JVMFlags deriveRemoved(JVMFlags past) {
        return new JVMFlags(~this.myFlags & past.myFlags);
    }

    public boolean isWeakerAccess(JVMFlags than) {
        return this.isPrivate() && !than.isPrivate() || this.isProtected() && than.isPublic() || this.isPackageLocal() && (than.myFlags & 5) != 0;
    }

    public boolean isPublic() {
        return this.isSet(1);
    }

    public boolean isPrivate() {
        return this.isSet(2);
    }

    public boolean isProtected() {
        return this.isSet(4);
    }

    public boolean isPackageLocal() {
        return (this.myFlags & 7) == 0;
    }

    public boolean isStatic() {
        return this.isSet(8);
    }

    public boolean isFinal() {
        return this.isSet(16);
    }

    public boolean isSuper() {
        return this.isSet(32);
    }

    public boolean isSynchronized() {
        return this.isSet(32);
    }

    public boolean isOpen() {
        return this.isSet(32);
    }

    public boolean isTransitive() {
        return this.isSet(32);
    }

    public boolean isVolatile() {
        return this.isSet(64);
    }

    public boolean isBridge() {
        return this.isSet(64);
    }

    public boolean isStaticPhase() {
        return this.isSet(64);
    }

    public boolean isVarargs() {
        return this.isSet(128);
    }

    public boolean isTransient() {
        return this.isSet(128);
    }

    public boolean isNative() {
        return this.isSet(256);
    }

    public boolean isInterface() {
        return this.isSet(512);
    }

    public boolean isAbstract() {
        return this.isSet(1024);
    }

    public boolean isStrict() {
        return this.isSet(2048);
    }

    public boolean isSynthetic() {
        return this.isSet(4096);
    }

    public boolean isAnnotation() {
        return this.isSet(8192);
    }

    boolean isEnum() {
        return this.isSet(16384);
    }

    public boolean isMandated() {
        return this.isSet(32768);
    }

    public boolean isModule() {
        return this.isSet(32768);
    }

    public boolean isRecord() {
        return this.isSet(65536);
    }

    public boolean isDeprecated() {
        return this.isSet(131072);
    }

    public boolean isLocal() {
        return this.isSet(0x1000000);
    }

    public boolean isAnonymous() {
        return this.isSet(0x2000000);
    }

    public boolean isGenerated() {
        return this.isSet(0x4000000);
    }

    public boolean isSealed() {
        return this.isSet(0x8000000);
    }

    public boolean isAllSet(JVMFlags flags) {
        return (this.myFlags & flags.myFlags) == flags.myFlags;
    }

    private boolean isSet(int mask) {
        return (this.myFlags & mask) != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JVMFlags jvmFlags = (JVMFlags)o;
        return this.myFlags == jvmFlags.myFlags;
    }

    public int getValue() {
        return this.myFlags;
    }

    public int hashCode() {
        return this.myFlags;
    }
}

