/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarDefinitionHelper;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersion;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsProcessor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.TextUtil;

public class VarProcessor {
    public static final int VAR_NON_FINAL = 1;
    public static final int VAR_EXPLICIT_FINAL = 2;
    public static final int VAR_FINAL = 3;
    private final VarNamesCollector varNamesCollector = new VarNamesCollector();
    private final StructMethod method;
    private final MethodDescriptor methodDescriptor;
    private Map<VarVersion, String> mapVarNames = new HashMap<VarVersion, String>();
    private final Map<VarVersion, String> mapPurgedAssignmentNames = new HashMap<VarVersion, String>();
    private final Map<VarVersion, StructLocalVariableTableAttribute.LocalVariable> mapVarLVTs = new HashMap<VarVersion, StructLocalVariableTableAttribute.LocalVariable>();
    private VarVersionsProcessor varVersions;
    private final Map<VarVersion, String> thisVars = new HashMap<VarVersion, String>();
    private final Set<VarVersion> externalVars = new HashSet<VarVersion>();
    private final BitSet finalParameters = new BitSet();
    private final int firstParameterVarIndex;
    private final int firstParameterPosition;

    public StructMethod getMethod() {
        return this.method;
    }

    public VarProcessor(StructClass cl, StructMethod mt, MethodDescriptor md) {
        boolean isEnumInit;
        this.method = mt;
        this.methodDescriptor = md;
        boolean isEnum = cl.hasModifier(16384) && DecompilerContext.getOption("den");
        boolean bl = isEnumInit = isEnum && "<init>".equals(mt.getName());
        this.firstParameterVarIndex = isEnumInit ? 3 : (!mt.hasModifier(8) ? 1 : 0);
        this.firstParameterPosition = isEnumInit ? 2 : 0;
    }

    public void setVarVersions(RootStatement root) {
        VarVersionsProcessor oldProcessor = this.varVersions;
        this.varVersions = new VarVersionsProcessor(this.method, this.methodDescriptor);
        this.varVersions.setVarVersions(root, oldProcessor);
    }

    public void setVarDefinitions(Statement root) {
        this.mapVarNames = new HashMap<VarVersion, String>();
        new VarDefinitionHelper(root, this.method, this).setVarDefinitions();
    }

    public void setDebugVarNames(Map<VarVersion, String> mapDebugVarNames) {
        if (this.varVersions == null) {
            return;
        }
        Map<Integer, VarVersion> mapOriginalVarIndices = this.varVersions.getMapOriginalVarIndices();
        ArrayList<VarVersion> listVars = new ArrayList<VarVersion>(this.mapVarNames.keySet());
        listVars.sort(Comparator.comparing(o -> !this.mapPurgedAssignmentNames.containsKey(o)).thenComparingInt(o -> o.var));
        HashMap<String, Integer> mapNames = new HashMap<String, Integer>();
        for (VarVersion pair : listVars) {
            Integer counter;
            String debugName;
            Object name = this.mapVarNames.get(pair);
            boolean lvtName = false;
            VarVersion key = mapOriginalVarIndices.get(pair.var);
            if (key != null && (debugName = mapDebugVarNames.get(key)) != null && TextUtil.isValidIdentifier(debugName, this.method.getBytecodeVersion())) {
                name = debugName;
                lvtName = true;
            }
            mapNames.put((String)name, (counter = (Integer)mapNames.get(name)) == null ? (counter = Integer.valueOf(0)) : (counter = Integer.valueOf(counter + 1)));
            if (counter > 0 && !lvtName && !this.mapPurgedAssignmentNames.containsKey(pair)) {
                name = (String)name + String.valueOf(counter);
            }
            this.mapVarNames.put(pair, (String)name);
        }
    }

    public Integer getVarOriginalIndex(int index) {
        if (this.varVersions == null) {
            return null;
        }
        VarVersion pair = this.varVersions.getMapOriginalVarIndices().get(index);
        return pair == null ? null : Integer.valueOf(pair.var);
    }

    public void refreshVarNames(VarNamesCollector vc) {
        HashMap<VarVersion, String> tempVarNames = new HashMap<VarVersion, String>(this.mapVarNames);
        for (Map.Entry ent : tempVarNames.entrySet()) {
            this.mapVarNames.put((VarVersion)ent.getKey(), this.mapPurgedAssignmentNames.containsKey(ent.getKey()) ? (String)ent.getValue() : vc.getFreeName((String)ent.getValue()));
        }
    }

    public VarNamesCollector getVarNamesCollector() {
        return this.varNamesCollector;
    }

    public VarType getVarType(VarVersion pair) {
        return this.varVersions == null ? null : this.varVersions.getVarType(pair);
    }

    public void setVarType(VarVersion pair, VarType type) {
        if (this.varVersions != null) {
            this.varVersions.setVarType(pair, type);
        }
    }

    public String getVarName(VarVersion pair) {
        return this.mapVarNames == null ? null : this.mapVarNames.get(pair);
    }

    public void setVarName(VarVersion pair, String name) {
        this.mapVarNames.put(pair, name);
    }

    public String getAssignedVarName(VarVersion pair) {
        return this.mapPurgedAssignmentNames.get(pair);
    }

    public void setAssignedVarName(VarVersion pair, String name) {
        if (name == null) {
            this.mapPurgedAssignmentNames.remove(pair);
            return;
        }
        this.mapPurgedAssignmentNames.put(pair, name);
    }

    public Collection<String> getVarNames() {
        return this.mapVarNames != null ? this.mapVarNames.values() : Collections.emptySet();
    }

    public int getVarFinal(VarVersion pair) {
        return this.varVersions == null ? 3 : this.varVersions.getVarFinal(pair);
    }

    public void setVarFinal(VarVersion pair, int finalType) {
        this.varVersions.setVarFinal(pair, finalType);
    }

    public Map<VarVersion, String> getThisVars() {
        return this.thisVars;
    }

    public Set<VarVersion> getExternalVars() {
        return this.externalVars;
    }

    public boolean isParameterFinal(VarVersion pair) {
        return this.finalParameters.get(pair.var);
    }

    public void setParameterFinal(VarVersion pair) {
        this.finalParameters.set(pair.var);
    }

    public int getFirstParameterVarIndex() {
        return this.firstParameterVarIndex;
    }

    public int getFirstParameterPosition() {
        return this.firstParameterPosition;
    }

    public List<StructLocalVariableTableAttribute.LocalVariable> getCandidates(int origindex) {
        if (!this.hasLVT()) {
            return null;
        }
        return this.method.getLocalVariableAttr().matchingVars(origindex).collect(Collectors.toList());
    }

    public void findLVT(VarExprent exprent, int start) {
        if (!this.hasLVT()) {
            return;
        }
        this.method.getLocalVariableAttr().getVariables().filter(v -> v.getVersion().var == exprent.getIndex() && v.getStart() == start).findFirst().ifPresent(exprent::setLVTEntry);
    }

    public boolean hasLVT() {
        return this.method.getLocalVariableAttr() != null;
    }

    public VarVersionsProcessor getVarVersions() {
        return this.varVersions;
    }

    public void setVarLVTEntry(VarVersion var, StructLocalVariableTableAttribute.LocalVariable lvt) {
        this.mapVarLVTs.put(var, lvt);
    }

    public StructLocalVariableTableAttribute.LocalVariable getVarLVTEntry(VarVersion var) {
        return this.mapVarLVTs.get(var);
    }
}

