/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.UISettingsUtils;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProviderImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NoMatchFoundException;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.Scopes;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceCommand;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.ConfigurationUtil;
import com.intellij.structuralsearch.plugin.ui.ExistingTemplatesComponent;
import com.intellij.structuralsearch.plugin.ui.FileTypeChooser;
import com.intellij.structuralsearch.plugin.ui.LinkComboBox;
import com.intellij.structuralsearch.plugin.ui.ScopePanel;
import com.intellij.structuralsearch.plugin.ui.SearchCommand;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialogKeys;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchTemplateBuilder;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIState;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterPanel;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.ui.BadgeIconSupplier;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StructuralSearchDialog
extends DialogWrapper
implements DocumentListener {
    @NonNls
    private static final String SEARCH_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog";
    @NonNls
    private static final String REPLACE_DIMENSION_SERVICE_KEY = "#com.intellij.structuralsearch.plugin.ui.StructuralReplaceDialog";
    private static final Key<Configuration> STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION = Key.create((String)"STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION");
    @NotNull
    private final Project myProject;
    @NotNull
    private final SearchContext mySearchContext;
    private Editor myEditor;
    private ReplaceConfiguration myConfiguration;
    @Nullable
    @NonNls
    private LanguageFileType myFileType;
    private Language myDialect;
    private PatternContext myPatternContext;
    private final List<RangeHighlighter> myRangeHighlighters;
    private final DocumentListener myRestartHighlightingListener;
    private boolean myChangedConfiguration;
    private final Alarm myAlarm;
    private boolean myConfigurationLoaded;
    private volatile boolean myPinned;
    private final boolean myEditConfigOnly;
    private boolean myReplace;
    private final FileTypeChooser myFileTypeChooser;
    private ActionToolbarImpl myOptionsToolbar;
    private EditorTextField mySearchCriteriaEdit;
    private EditorTextField myReplaceCriteriaEdit;
    private OnePixelSplitter mySearchEditorPanel;
    private OnePixelSplitter myMainSplitter;
    private FilterPanel myFilterPanel;
    private ExistingTemplatesComponent myExistingTemplatesComponent;
    private LinkComboBox myTargetComboBox;
    private ScopePanel myScopePanel;
    private JCheckBox myOpenInNewTab;
    private JComponent myReplacePanel;
    private final ArrayList<JComponent> myComponentsWithEditorBackground;
    private JComponent mySearchWrapper;
    private JBCheckBox myInjected;
    private JBCheckBox myMatchCase;
    private JComponent myReplaceWrapper;
    private JBCheckBox myShortenFqn;
    private JBCheckBox myStaticImport;
    private JBCheckBox myReformat;
    private Balloon myBalloon;

    public StructuralSearchDialog(@NotNull SearchContext searchContext, boolean replace) {
        if (searchContext == null) {
            StructuralSearchDialog.$$$reportNull$$$0(0);
        }
        this(searchContext, replace, false);
    }

    public StructuralSearchDialog(@NotNull SearchContext searchContext, boolean replace, boolean editConfigOnly) {
        if (searchContext == null) {
            StructuralSearchDialog.$$$reportNull$$$0(1);
        }
        super(searchContext.getProject(), true);
        this.myFileType = StructuralSearchUtil.getDefaultFileType();
        this.myRangeHighlighters = new SmartList();
        this.myRestartHighlightingListener = new DocumentListener(){
            final Runnable runnable = () -> StructuralSearchDialog.this.addMatchHighlights();

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (StructuralSearchDialog.this.myAlarm.isDisposed()) {
                    return;
                }
                StructuralSearchDialog.this.myAlarm.cancelRequest(this.runnable);
                StructuralSearchDialog.this.myAlarm.addRequest(this.runnable, 100);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$1", "documentChanged"));
            }
        };
        this.myFileTypeChooser = new FileTypeChooser();
        this.myComponentsWithEditorBackground = new ArrayList();
        if (!editConfigOnly) {
            this.setModal(false);
            this.setOKButtonText(FindBundle.message((String)"find.dialog.find.button", (Object[])new Object[0]));
        }
        this.myReplace = replace;
        this.myEditConfigOnly = editConfigOnly;
        this.myProject = searchContext.getProject();
        this.mySearchContext = searchContext;
        this.myEditor = searchContext.getEditor();
        this.addRestartHighlightingListenerToCurrentEditor();
        FileEditorManagerListener listener2 = new FileEditorManagerListener(){
            FileEditor myNewEditor;
            final Runnable runnable = () -> {
                StructuralSearchDialog.this.removeRestartHighlightingListenerFromCurrentEditor();
                StructuralSearchDialog.this.removeMatchHighlights();
                if (this.myNewEditor instanceof TextEditor) {
                    StructuralSearchDialog.this.myEditor = ((TextEditor)this.myNewEditor).getEditor();
                    StructuralSearchDialog.this.addMatchHighlights();
                    StructuralSearchDialog.this.addRestartHighlightingListenerToCurrentEditor();
                } else {
                    StructuralSearchDialog.this.myEditor = null;
                }
            };

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (StructuralSearchDialog.this.myAlarm.isDisposed()) {
                    return;
                }
                StructuralSearchDialog.this.myAlarm.cancelRequest(this.runnable);
                this.myNewEditor = event.getNewEditor();
                StructuralSearchDialog.this.myAlarm.addRequest(this.runnable, 100);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$2", "selectionChanged"));
            }
        };
        MessageBusConnection connection = this.myProject.getMessageBus().connect(this.getDisposable());
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener2);
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                StructuralSearchDialog.this.close(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$3", "beforePluginUnload"));
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            public void appClosing() {
                StructuralSearchDialog.this.close(1);
            }
        });
        connection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosing(@NotNull Project project2) {
                if (project2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (project2 == StructuralSearchDialog.this.myProject) {
                    StructuralSearchDialog.this.close(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$5", "projectClosing"));
            }
        });
        connection.subscribe(EditorColorsManager.TOPIC, uiSettings -> this.updateColors());
        this.setTitle(this.getDefaultTitle());
        this.init();
        this.loadUIState();
        if (!this.myConfigurationLoaded) {
            this.myConfiguration = this.createConfiguration(null);
        }
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.myDisposable);
        this.setValidationDelay(100);
    }

    private void addRestartHighlightingListenerToCurrentEditor() {
        if (this.myEditor != null) {
            this.myEditor.getDocument().addDocumentListener(this.myRestartHighlightingListener);
        }
    }

    private void removeRestartHighlightingListenerFromCurrentEditor() {
        if (this.myEditor != null) {
            this.myEditor.getDocument().removeDocumentListener(this.myRestartHighlightingListener);
        }
    }

    private EditorTextField createEditor(boolean replace) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        assert (profile != null);
        Document document = UIUtil.createDocument(this.myProject, this.myFileType, this.myDialect, this.myPatternContext, "", profile);
        document.addDocumentListener((DocumentListener)this, this.myDisposable);
        document.putUserData(StructuralSearchDialogKeys.STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)(this.myPatternContext == null ? "" : this.myPatternContext.getId()));
        MyEditorTextField textField = new MyEditorTextField(document, replace);
        textField.setFont(EditorFontType.getGlobalPlainFont().deriveFont(UISettingsUtils.getInstance().getScaledEditorFontSize()));
        textField.setPreferredSize(new Dimension(550, 150));
        textField.setMinimumSize(new Dimension(200, 50));
        this.myComponentsWithEditorBackground.add((JComponent)((Object)textField));
        return textField;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            StructuralSearchDialog.$$$reportNull$$$0(2);
        }
        this.initValidation();
        if (!this.myChangedConfiguration) {
            this.myExistingTemplatesComponent.templateChanged();
        }
    }

    private void initializeFilterPanel(@Nullable CompiledPattern compiledPattern) {
        CompiledPattern finalCompiledPattern;
        MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
        CompiledPattern compiledPattern2 = finalCompiledPattern = compiledPattern == null ? PatternCompiler.compilePattern(this.myProject, matchOptions, false, false) : compiledPattern;
        if (finalCompiledPattern == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            SubstitutionShortInfoHandler.updateEditorInlays(this.mySearchCriteriaEdit.getEditor());
            if (this.myReplace) {
                SubstitutionShortInfoHandler.updateEditorInlays(this.myReplaceCriteriaEdit.getEditor());
            }
            this.myFilterPanel.setCompiledPattern(finalCompiledPattern);
            if (this.myFilterPanel.getVariable() == null) {
                this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
            }
        }, ModalityState.stateForComponent((Component)this.myFilterPanel.getComponent()));
    }

    @NotNull
    private ReplaceConfiguration createConfiguration(Configuration template) {
        ReplaceConfiguration result2;
        ReplaceConfiguration replaceConfiguration = result2 = template == null ? new ReplaceConfiguration(SSRBundle.message("new.template.defaultname", new Object[0]), SSRBundle.message("user.defined.category", new Object[0])) : new ReplaceConfiguration(template);
        if (!this.myEditConfigOnly) {
            MatchOptions matchOptions = result2.getMatchOptions();
            matchOptions.setSearchInjectedCode(this.myInjected.isSelected());
            matchOptions.setCaseSensitiveMatch(this.myMatchCase.isSelected());
            ReplaceOptions replaceOptions = result2.getReplaceOptions();
            replaceOptions.setToShortenFQN(this.myShortenFqn.isSelected());
            replaceOptions.setToUseStaticImport(this.myStaticImport.isSelected());
            replaceOptions.setToReformatAccordingToStyle(this.myReformat.isSelected());
        }
        ReplaceConfiguration replaceConfiguration2 = result2;
        if (replaceConfiguration2 == null) {
            StructuralSearchDialog.$$$reportNull$$$0(3);
        }
        return replaceConfiguration2;
    }

    private void setTextFromContext() {
        SelectionModel selectionModel;
        String selectedText;
        Editor editor = this.myEditor;
        if (editor != null && (selectedText = (selectionModel = editor.getSelectionModel()).getSelectedText()) != null) {
            if (this.loadConfiguration(selectedText)) {
                return;
            }
            String text2 = selectedText.trim();
            this.setTextForEditor(text2.trim(), this.mySearchCriteriaEdit);
            this.setTextForEditor(text2, this.myReplaceCriteriaEdit);
            this.myScopePanel.setScopesFromContext(null);
            Document document = editor.getDocument();
            PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (file != null) {
                PsiElement start2 = file.findElementAt(selectionModel.getSelectionStart());
                PsiElement end = file.findElementAt(selectionModel.getSelectionEnd() - 1);
                PsiElement element = start2 == null || end == null || start2.getContainingFile() != end.getContainingFile() ? null : PsiTreeUtil.findCommonParent((PsiElement)start2, (PsiElement)end);
                Language language = element == null ? file.getLanguage() : element.getLanguage();
                this.myFileTypeChooser.setSelectedItem(language.getAssociatedFileType(), language, null);
                if (language != file.getLanguage() && !this.myInjected.isSelected()) {
                    this.myInjected.doClick();
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> this.startTemplate());
            return;
        }
        Configuration previousConfiguration = (Configuration)this.myProject.getUserData(STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION);
        if (previousConfiguration != null) {
            this.loadConfiguration(previousConfiguration);
        } else {
            Configuration configuration = ConfigurationManager.getInstance(this.myProject).getMostRecentConfiguration();
            if (configuration != null) {
                this.loadConfiguration(configuration);
            }
        }
    }

    private void setTextForEditor(String text2, EditorTextField editor) {
        editor.setText(text2);
        editor.selectAll();
        Document document = editor.getDocument();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        documentManager.commitDocument(document);
        PsiFile file = documentManager.getPsiFile(document);
        if (file == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)SSRBundle.message("command.name.adjust.line.indent", new Object[0]), (String)"Structural Search", () -> CodeStyleManager.getInstance((Project)this.myProject).adjustLineIndent(file, new TextRange(0, document.getTextLength())), (PsiFile[])new PsiFile[]{file});
    }

    private void startSearching() {
        if (this.myReplace) {
            new ReplaceCommand(this.getConfiguration(), this.mySearchContext).startSearching();
        } else {
            new SearchCommand(this.getConfiguration(), this.mySearchContext).startSearching();
        }
    }

    @NotNull
    @Nls
    @NlsContexts.DialogTitle
    private String getDefaultTitle() {
        String string2 = this.myReplace ? SSRBundle.message("structural.replace.title", new Object[0]) : SSRBundle.message("structural.search.title", new Object[0]);
        if (string2 == null) {
            StructuralSearchDialog.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            StructuralSearchDialog.$$$reportNull$$$0(5);
        }
        return dialogStyle;
    }

    protected JComponent createCenterPanel() {
        JPanel searchPanel = this.createSearchPanel();
        this.myReplacePanel = this.createReplacePanel();
        this.myReplacePanel.setVisible(this.myReplace);
        this.myScopePanel = new ScopePanel(this.myProject, this.myDisposable);
        if (!this.myEditConfigOnly) {
            this.myScopePanel.setRecentDirectories(FindInProjectSettings.getInstance((Project)this.myProject).getRecentDirectories());
            this.myScopePanel.setScopeConsumer(scope -> {
                if (this.myConfiguration != null) {
                    this.myConfiguration.getMatchOptions().setScope((SearchScope)scope);
                    this.initValidation();
                }
            });
        } else {
            this.myScopePanel.setVisible(false);
        }
        GridBag centerConstraint = new GridBag().setDefaultFill(1).setDefaultWeightX(1.0).setDefaultWeightY(1.0);
        JPanel centerPanel2 = new JPanel(new GridBagLayout());
        centerPanel2.add((Component)searchPanel, centerConstraint.nextLine());
        centerPanel2.add((Component)this.myReplacePanel, centerConstraint.nextLine());
        centerPanel2.add((Component)this.myScopePanel, centerConstraint.nextLine().weighty(0.0));
        this.myExistingTemplatesComponent = new ExistingTemplatesComponent(this.myProject, this.getContentPanel(), new ImportConfigurationAction(), new ExportConfigurationAction());
        this.myExistingTemplatesComponent.onConfigurationSelected(this::loadConfiguration);
        this.myExistingTemplatesComponent.setConfigurationProducer(() -> this.getConfiguration());
        this.myMainSplitter = new OnePixelSplitter(false, 0.2f);
        this.myMainSplitter.setFirstComponent(this.myExistingTemplatesComponent.getTemplatesPanel());
        this.myMainSplitter.setSecondComponent((JComponent)centerPanel2);
        this.updateColors();
        this.updateOptions();
        return this.myMainSplitter;
    }

    private JPanel createSearchPanel() {
        List<PatternContext> contexts;
        JBLabel searchTemplateLabel = new JBLabel(SSRBundle.message("search.template", new Object[0]));
        this.myFileType = UIUtil.detectFileType(this.mySearchContext);
        this.myDialect = this.myFileType.getLanguage();
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        if (profile != null && !(contexts = profile.getPatternContexts()).isEmpty()) {
            this.myPatternContext = contexts.get(0);
        }
        this.myFileTypeChooser.setSelectedItem(this.myFileType, this.myDialect, this.myPatternContext);
        this.myFileTypeChooser.setFileTypeInfoConsumer(info -> {
            this.myFileType = info.getFileType();
            this.myDialect = info.getDialect();
            this.myPatternContext = info.getContext();
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            matchOptions.setFileType(this.myFileType);
            matchOptions.setDialect(this.myDialect);
            matchOptions.setPatternContext(this.myPatternContext);
            this.myOptionsToolbar.updateActionsImmediately();
            this.myFilterPanel.setFileType(this.myFileType);
            String contextId = this.myPatternContext == null ? "" : this.myPatternContext.getId();
            StructuralSearchProfile profile1 = StructuralSearchUtil.getProfileByFileType(this.myFileType);
            Document searchDocument = UIUtil.createDocument(this.myProject, this.myFileType, this.myDialect, this.myPatternContext, this.mySearchCriteriaEdit.getText(), profile1);
            searchDocument.addDocumentListener((DocumentListener)this, this.myDisposable);
            this.mySearchCriteriaEdit.setNewDocumentAndFileType((FileType)(this.myFileType == null ? PlainTextFileType.INSTANCE : this.myFileType), searchDocument);
            searchDocument.putUserData(StructuralSearchDialogKeys.STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)contextId);
            Document replaceDocument = UIUtil.createDocument(this.myProject, this.myFileType, this.myDialect, this.myPatternContext, this.myReplaceCriteriaEdit.getText(), profile1);
            replaceDocument.addDocumentListener((DocumentListener)this, this.myDisposable);
            this.myReplaceCriteriaEdit.setNewDocumentAndFileType((FileType)(this.myFileType == null ? PlainTextFileType.INSTANCE : this.myFileType), replaceDocument);
            replaceDocument.putUserData(StructuralSearchDialogKeys.STRUCTURAL_SEARCH_PATTERN_CONTEXT_ID, (Object)contextId);
            this.updateOptions();
            this.initValidation();
        });
        this.myFileTypeChooser.setUserActionFileTypeInfoConsumer(info -> this.myExistingTemplatesComponent.selectFileType(info.getFileType()));
        DumbAwareToggleAction showTemplatesAction = new DumbAwareToggleAction(SSRBundle.message("templates.button", new Object[0]), SSRBundle.message("templates.button.description", new Object[0]), AllIcons.Actions.PreviewDetails){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    6.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                return StructuralSearchDialog.this.isExistingTemplatesPanelVisible();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    6.$$$reportNull$$$0(2);
                }
                StructuralSearchDialog.this.setExistingTemplatesPanelVisible(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$6";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1, 2 -> new IllegalArgumentException(string2);
                };
            }
        };
        final BadgeIconSupplier filterIcon = new BadgeIconSupplier(AllIcons.General.Filter);
        DumbAwareToggleAction filterAction = new DumbAwareToggleAction(SSRBundle.message("filter.button", new Object[0]), SSRBundle.message("filter.button.description", new Object[0]), filterIcon.getLiveIndicatorIcon(true)){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    7.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(1);
                }
                super.update(e);
                Presentation presentation = e.getPresentation();
                presentation.setIcon(filterIcon.getLiveIndicatorIcon(StructuralSearchDialog.this.myFilterPanel.hasVisibleFilter()));
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(2);
                }
                return StructuralSearchDialog.this.isFilterPanelVisible();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    7.$$$reportNull$$$0(3);
                }
                StructuralSearchDialog.this.setFilterPanelVisible(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$7";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1, 2, 3 -> new IllegalArgumentException(string2);
                };
            }
        };
        this.myFilterPanel = new FilterPanel(this.myProject, this.myFileType, this.getDisposable());
        this.myFilterPanel.setConstraintChangedCallback(() -> this.initValidation());
        this.myFilterPanel.getComponent().setMinimumSize(new Dimension(300, 50));
        DumbAwareToggleAction pinAction = new DumbAwareToggleAction(SSRBundle.message("pin.button", new Object[0]), SSRBundle.message("pin.button.description", new Object[0]), AllIcons.General.Pin_tab){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    8.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                return StructuralSearchDialog.this.myPinned;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    8.$$$reportNull$$$0(2);
                }
                StructuralSearchDialog.this.myPinned = state;
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(3);
                }
                super.update(e);
                e.getPresentation().setEnabledAndVisible(!StructuralSearchDialog.this.myEditConfigOnly);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$8";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1, 2, 3 -> new IllegalArgumentException(string2);
                };
            }
        };
        DefaultActionGroup optionsActionGroup = new DefaultActionGroup(new AnAction[]{this.myFileTypeChooser, showTemplatesAction, filterAction, new Separator(), pinAction, new SwitchAction()});
        ActionManager actionManager = ActionManager.getInstance();
        this.myOptionsToolbar = (ActionToolbarImpl)actionManager.createActionToolbar("StructuralSearchDialog", (ActionGroup)optionsActionGroup, true);
        this.myOptionsToolbar.setTargetComponent((JComponent)this.mySearchCriteriaEdit);
        this.myOptionsToolbar.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        this.myOptionsToolbar.setForceMinimumSize(true);
        this.myOptionsToolbar.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        JPanel searchEditorPanel = new JPanel(new GridBagLayout());
        this.myTargetComboBox = new LinkComboBox(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItemConsumer(item -> {
            MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
            for (String name : matchOptions.getVariableConstraintNames()) {
                matchOptions.getVariableConstraint(name).setPartOfSearchResults(name.equals(item));
            }
            this.initValidation();
        });
        String text2 = SSRBundle.message("search.target.label", new Object[0]);
        JLabel searchTargetLabel = new JLabel(text2);
        this.myTargetComboBox.setLabel(searchTargetLabel);
        this.myInjected = new JBCheckBox(SSRBundle.message("search.in.injected.checkbox", new Object[0]));
        this.myInjected.setOpaque(false);
        this.myInjected.addActionListener(e -> {
            this.myConfiguration.getMatchOptions().setSearchInjectedCode(this.myInjected.isSelected());
            this.initValidation();
        });
        this.myInjected.setVisible(!this.myEditConfigOnly);
        this.myMatchCase = new JBCheckBox(FindBundle.message((String)"find.popup.case.sensitive", (Object[])new Object[0]));
        this.myMatchCase.setOpaque(false);
        this.myMatchCase.addActionListener(e -> {
            this.myConfiguration.getMatchOptions().setCaseSensitiveMatch(this.myMatchCase.isSelected());
            this.initValidation();
        });
        this.mySearchEditorPanel = new OnePixelSplitter(false, 1.0f);
        this.mySearchEditorPanel.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.mySearchCriteriaEdit = this.createEditor(false);
        this.mySearchEditorPanel.setFirstComponent((JComponent)searchEditorPanel);
        this.myComponentsWithEditorBackground.add(searchEditorPanel);
        this.mySearchWrapper = new JPanel(new BorderLayout());
        this.mySearchWrapper.add((Component)this.mySearchEditorPanel, "Center");
        GridBag searchConstraint = new GridBag().setDefaultInsets(4, 10, 4, 0);
        searchEditorPanel.add((Component)this.mySearchCriteriaEdit, searchConstraint.nextLine().fillCell().coverLine().weightx(1.0).weighty(1.0).emptyInsets());
        searchEditorPanel.add((Component)searchTargetLabel, searchConstraint.nextLine());
        searchEditorPanel.add((Component)((Object)this.myTargetComboBox), searchConstraint);
        searchEditorPanel.add((Component)this.myInjected, searchConstraint);
        searchEditorPanel.add((Component)this.myMatchCase, searchConstraint.anchor(17).insetRight(10));
        this.mySearchEditorPanel.setSecondComponent(this.myFilterPanel.getComponent());
        this.myComponentsWithEditorBackground.add((JComponent)this.myFilterPanel.getTable());
        JPanel searchPanel = new JPanel(new GridBagLayout());
        GridBag northConstraint = new GridBag().setDefaultWeightX(1.0);
        searchPanel.add((Component)searchTemplateLabel, northConstraint.nextLine().weightx(0.0).insets((Insets)JBInsets.create((int)0, (int)10)));
        searchPanel.add((Component)this.myOptionsToolbar, northConstraint.anchor(13));
        searchPanel.add((Component)this.mySearchWrapper, northConstraint.nextLine().coverLine().fillCell().emptyInsets().weighty(1.0));
        return searchPanel;
    }

    @NotNull
    private JComponent createReplacePanel() {
        JBLabel replacementTemplateLabel = new JBLabel(SSRBundle.message("replacement.template.label", new Object[0]));
        this.myShortenFqn = new JBCheckBox(SSRBundle.message("shorten.fully.qualified.names.checkbox", new Object[0]));
        this.myShortenFqn.setOpaque(false);
        this.myShortenFqn.addActionListener(e -> this.myConfiguration.getReplaceOptions().setToShortenFQN(this.myShortenFqn.isSelected()));
        this.myStaticImport = new JBCheckBox(SSRBundle.message("use.static.import.checkbox", new Object[0]));
        this.myStaticImport.setOpaque(false);
        this.myStaticImport.addActionListener(e -> this.myConfiguration.getReplaceOptions().setToUseStaticImport(this.myStaticImport.isSelected()));
        this.myReformat = new JBCheckBox(SSRBundle.message("reformat.checkbox", new Object[0]));
        this.myReformat.setOpaque(false);
        this.myReformat.addActionListener(e -> this.myConfiguration.getReplaceOptions().setToReformatAccordingToStyle(this.myReformat.isSelected()));
        this.myReplaceCriteriaEdit = this.createEditor(true);
        this.myReplaceWrapper = new JPanel(new GridBagLayout());
        this.myComponentsWithEditorBackground.add(this.myReplaceWrapper);
        GridBag wrapperConstraint = new GridBag().setDefaultInsets(10, 10, 10, 0);
        this.myReplaceWrapper.add((Component)this.myReplaceCriteriaEdit, wrapperConstraint.nextLine().emptyInsets().fillCell().coverLine().weightx(1.0).weighty(1.0));
        this.myReplaceWrapper.add((Component)this.myShortenFqn, wrapperConstraint.nextLine());
        this.myReplaceWrapper.add((Component)this.myStaticImport, wrapperConstraint);
        this.myReplaceWrapper.add((Component)this.myReformat, wrapperConstraint.weightx(1.0).anchor(17));
        JPanel replacePanel = new JPanel(new GridBagLayout());
        GridBag replaceConstraint = new GridBag().setDefaultWeightX(1.0);
        replacePanel.add((Component)replacementTemplateLabel, replaceConstraint.nextLine().anchor(17).insets(16, 10, 14, 0));
        replacePanel.add((Component)this.myReplaceWrapper, replaceConstraint.nextLine().fillCell().weighty(1.0));
        JPanel jPanel = replacePanel;
        if (jPanel == null) {
            StructuralSearchDialog.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private void updateOptions() {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        this.myShortenFqn.setVisible(profile != null && profile.supportsShortenFQNames());
        this.myStaticImport.setVisible(profile != null && profile.supportsUseStaticImports());
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        if (this.myEditConfigOnly) {
            return null;
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.myOpenInNewTab = new JCheckBox(SSRBundle.message("open.in.new.tab.checkbox", new Object[0]));
        this.myOpenInNewTab.setSelected(FindSettings.getInstance().isShowResultsInSeparateView());
        panel.add((Component)this.myOpenInNewTab, "East");
        return panel;
    }

    @Nullable
    public Point getInitialLocation() {
        DimensionService dimensionService = DimensionService.getInstance();
        Dimension size = dimensionService.getSize(this.myReplace ? REPLACE_DIMENSION_SERVICE_KEY : SEARCH_DIMENSION_SERVICE_KEY, this.myProject);
        if (size != null) {
            this.setSize(size.width, this.myEditConfigOnly ? size.height - this.myScopePanel.getPreferredSize().height : size.height);
        } else {
            this.pack();
            Dimension otherSize = dimensionService.getSize(this.myReplace ? SEARCH_DIMENSION_SERVICE_KEY : REPLACE_DIMENSION_SERVICE_KEY, this.myProject);
            if (otherSize != null) {
                this.setSize(otherSize.width, this.getSize().height);
            }
        }
        if (this.myEditConfigOnly) {
            return super.getInitialLocation();
        }
        Point location = dimensionService.getLocation(SEARCH_DIMENSION_SERVICE_KEY, this.myProject);
        return location == null ? super.getInitialLocation() : location;
    }

    public void show() {
        if (!this.myConfigurationLoaded) {
            this.setTextFromContext();
        }
        super.show();
    }

    private void startTemplate() {
        if (!Registry.is((String)"ssr.template.from.selection.builder")) {
            return;
        }
        Document document = this.mySearchCriteriaEdit.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        assert (psiFile != null);
        TemplateBuilder builder2 = StructuralSearchTemplateBuilder.getInstance().buildTemplate(psiFile);
        if (builder2 == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)SSRBundle.message("command.name.live.search.template.builder", new Object[0]), (String)"Structural Search", () -> builder2.run(Objects.requireNonNull(this.mySearchCriteriaEdit.getEditor()), true), (PsiFile[])new PsiFile[0]);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySearchCriteriaEdit;
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.removeMatchHighlights();
    }

    protected void doOKAction() {
        if (!this.getOKAction().isEnabled()) {
            return;
        }
        if (!this.myPinned) {
            this.close(0);
        }
        this.removeMatchHighlights();
        this.myAlarm.cancelAllRequests();
        this.myConfiguration.removeUnusedVariables();
        if (this.myEditConfigOnly) {
            return;
        }
        SearchScope scope = this.myScopePanel.getScope();
        if (scope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)scope;
            FindInProjectSettings.getInstance((Project)this.myProject).addDirectory(directoryScope.getDirectory().getPresentableUrl());
        }
        FindSettings.getInstance().setShowResultsInSeparateView(this.myOpenInNewTab.isSelected());
        ConfigurationManager.getInstance(this.myProject).addHistoryConfiguration(this.getConfiguration());
        this.startSearching();
    }

    public Configuration getConfiguration() {
        this.saveConfiguration();
        return this.myReplace ? new ReplaceConfiguration(this.myConfiguration) : new SearchConfiguration(this.myConfiguration);
    }

    private void removeMatchHighlights() {
        if (this.myEditConfigOnly || this.myRangeHighlighters.isEmpty()) {
            return;
        }
        Editor editor = this.myEditor;
        if (editor == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            for (RangeHighlighter highlighter : this.myRangeHighlighters) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
            }
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo("");
            this.myRangeHighlighters.clear();
        });
    }

    private void addMatchHighlights() {
        if (this.myEditConfigOnly) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            if (DumbService.isDumb((Project)this.myProject)) {
                return null;
            }
            Editor editor = this.myEditor;
            if (editor == null) {
                return null;
            }
            Document document = editor.getDocument();
            PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (file == null) {
                return null;
            }
            MatchOptions matchOptions = this.getConfiguration().getMatchOptions();
            matchOptions.setScope((SearchScope)new LocalSearchScope((PsiElement)file, PredefinedSearchScopeProviderImpl.getCurrentFileScopeName()));
            CollectingMatchResultSink sink = new CollectingMatchResultSink();
            try {
                new Matcher(this.myProject, matchOptions).findMatches(sink);
                List<MatchResult> matches = sink.getMatches();
                this.removeMatchHighlights();
                this.addMatchHighlights(matches, editor, file, SSRBundle.message("status.bar.text.results.found.in.current.file", matches.size()));
            }
            catch (MalformedPatternException | UnsupportedPatternException e) {
                this.reportMessage(e.getMessage().replace("a3cd264774bf4efb9ab609b250c5165c", ""), true, (JComponent)this.mySearchCriteriaEdit);
                this.removeMatchHighlights();
            }
            return null;
        }).withDocumentsCommitted(this.myProject).expireWith(this.getDisposable()).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void addMatchHighlights(@NotNull List<? extends MatchResult> matchResults, @NotNull Editor editor, @NotNull PsiFile file, @NlsContexts.StatusBarText @Nullable String statusBarText) {
        if (matchResults == null) {
            StructuralSearchDialog.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            StructuralSearchDialog.$$$reportNull$$$0(8);
        }
        if (file == null) {
            StructuralSearchDialog.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (!matchResults.isEmpty()) {
                for (MatchResult result2 : matchResults) {
                    PsiElement match2 = result2.getMatch();
                    if (match2 == null || match2.getContainingFile() != file) continue;
                    int start2 = -1;
                    int end = -1;
                    if ("__multi_line__".equals(result2.getName())) {
                        for (MatchResult child : result2.getChildren()) {
                            int endOffset;
                            TextRange range = child.getMatch().getTextRange();
                            int startOffset = range.getStartOffset();
                            if (start2 == -1 || start2 > startOffset) {
                                start2 = startOffset;
                            }
                            if (end >= (endOffset = range.getEndOffset())) continue;
                            end = endOffset;
                        }
                    } else {
                        TextRange range = match2.getTextRange();
                        start2 = range.getStartOffset();
                        end = range.getEndOffset();
                    }
                    HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
                    highlightManager.addRangeHighlight(editor, start2, end, EditorColors.SEARCH_RESULT_ATTRIBUTES, false, this.myRangeHighlighters);
                }
                HighlightHandlerBase.setupFindModel((Project)this.myProject);
            }
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(statusBarText);
        });
    }

    protected boolean continuousValidation() {
        return false;
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.POOLED_THREAD;
        if (threadToUse == null) {
            StructuralSearchDialog.$$$reportNull$$$0(10);
        }
        return threadToUse;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        JRootPane component = this.getRootPane();
        if (component == null || this.myPerformAction) {
            List<ValidationInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                StructuralSearchDialog.$$$reportNull$$$0(11);
            }
            return list2;
        }
        SmartList errors = new SmartList();
        this.saveConfiguration();
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        try {
            CompiledPattern compiledPattern = null;
            try {
                compiledPattern = PatternCompiler.compilePattern(this.myProject, matchOptions, true, !this.myEditConfigOnly && !this.myPerformAction);
            }
            catch (MalformedPatternException e) {
                this.removeMatchHighlights();
                if (!StringUtil.isEmptyOrSpaces((String)matchOptions.getSearchPattern())) {
                    String message = e.getMessage();
                    errors.add(new ValidationInfo(message == null ? SSRBundle.message("this.pattern.is.malformed.message", new Object[0]) : message, (JComponent)this.mySearchCriteriaEdit));
                }
            }
            catch (NoMatchFoundException | UnsupportedPatternException e) {
                this.removeMatchHighlights();
                errors.add(new ValidationInfo(e.getMessage(), (JComponent)this.mySearchCriteriaEdit));
            }
            if (this.myReplace) {
                try {
                    Replacer.checkReplacementPattern(this.myProject, this.myConfiguration.getReplaceOptions());
                }
                catch (MalformedPatternException | UnsupportedPatternException e) {
                    errors.add(new ValidationInfo(e.getMessage(), (JComponent)this.myReplaceCriteriaEdit));
                }
            }
            this.initializeFilterPanel(compiledPattern);
            if (compiledPattern != null) {
                this.addMatchHighlights();
            } else {
                errors.add(new ValidationInfo(""));
            }
            ApplicationManager.getApplication().invokeLater(() -> this.setSearchTargets(this.myConfiguration.getMatchOptions()), ModalityState.stateForComponent((Component)component));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Logger.getInstance(StructuralSearchDialog.class).error((Throwable)e);
        }
        SmartList smartList = errors;
        if (smartList == null) {
            StructuralSearchDialog.$$$reportNull$$$0(12);
        }
        return smartList;
    }

    private void reportMessage(@NlsContexts.PopupContent @Nullable String message, boolean error, @NotNull JComponent component) {
        if (component == null) {
            StructuralSearchDialog.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDisposed()) {
                return;
            }
            if (this.myBalloon != null) {
                this.myBalloon.hide();
            }
            if (message == null) {
                return;
            }
            this.myBalloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, error ? MessageType.ERROR : MessageType.WARNING, null).setHideOnFrameResize(false).createBalloon();
            this.myBalloon.show(new RelativePoint((Component)component, new Point(component.getWidth() / 2, component.getHeight())), Balloon.Position.below);
            Disposer.register((Disposable)this.myDisposable, (Disposable)this.myBalloon);
        }, ModalityState.stateForComponent((Component)component));
    }

    private void securityCheck() {
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        int scripts = 0;
        for (String name : matchOptions.getVariableConstraintNames()) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (constraint.getScriptCodeConstraint().length() <= 2) continue;
            ++scripts;
        }
        ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
        for (ReplacementVariableDefinition variableDefinition : replaceOptions.getVariableDefinitions()) {
            if (variableDefinition.getScriptCodeConstraint().length() <= 2) continue;
            ++scripts;
        }
        if (scripts > 0) {
            NotificationGroupManager.getInstance().getNotificationGroup("Structural Search").createNotification(SSRBundle.message("import.template.script.warning.title", new Object[0]), SSRBundle.message("import.template.script.warning", ApplicationNamesInfo.getInstance().getFullProductName(), scripts), NotificationType.WARNING).notify(this.myProject);
        }
    }

    private void setFilterPanelVisible(boolean visible) {
        if (visible && this.myFilterPanel.getVariable() == null) {
            this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint("__context__", this.myConfiguration));
        }
        if (this.isFilterPanelVisible() != visible) {
            this.mySearchEditorPanel.setSecondComponent(visible ? this.myFilterPanel.getComponent() : null);
        }
    }

    private boolean isFilterPanelVisible() {
        return this.mySearchEditorPanel.getSecondComponent() != null;
    }

    private void setExistingTemplatesPanelVisible(boolean visible) {
        if (visible) {
            this.myMainSplitter.setFirstComponent(this.myExistingTemplatesComponent.getTemplatesPanel());
        } else {
            this.myMainSplitter.setFirstComponent(null);
        }
    }

    private boolean isExistingTemplatesPanelVisible() {
        return this.myMainSplitter.getFirstComponent() != null;
    }

    private void setSearchTargets(MatchOptions matchOptions) {
        ArrayList<String> names = new ArrayList<String>(matchOptions.getUsedVariableNames());
        Collections.sort(names);
        names.remove("__context__");
        names.add(SSRBundle.message("complete.match.variable.name", new Object[0]));
        this.myTargetComboBox.setItems(names);
        this.myTargetComboBox.setEnabled(names.size() > 1);
        for (String name : names) {
            MatchVariableConstraint constraint = matchOptions.getVariableConstraint(name);
            if (constraint == null || !constraint.isPartOfSearchResults()) continue;
            this.myTargetComboBox.setSelectedItem(name);
            return;
        }
        this.myTargetComboBox.setSelectedItem(SSRBundle.message("complete.match.variable.name", new Object[0]));
    }

    private boolean loadConfiguration(String text2) {
        if (text2 == null) {
            return false;
        }
        try {
            Configuration configuration = ConfigurationUtil.fromXml(text2);
            if (configuration == null) {
                return false;
            }
            if (configuration instanceof ReplaceConfiguration && !this.myReplace) {
                this.switchSearchReplace();
            }
            this.loadConfiguration(configuration);
            this.securityCheck();
        }
        catch (JDOMException e) {
            this.reportMessage(SSRBundle.message("import.template.script.corrupted", new Object[0]) + "\n" + e.getMessage(), false, (JComponent)this.mySearchCriteriaEdit);
        }
        return true;
    }

    public void loadConfiguration(Configuration configuration) {
        this.myConfigurationLoaded = true;
        this.myConfiguration = this.createConfiguration(configuration);
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
        if (this.myEditConfigOnly) {
            this.myMatchCase.setSelected(matchOptions.isCaseSensitiveMatch());
            this.myInjected.setSelected(false);
            this.myReformat.setSelected(replaceOptions.isToReformatAccordingToStyle());
            this.myStaticImport.setSelected(replaceOptions.isToUseStaticImport());
            this.myShortenFqn.setSelected(replaceOptions.isToShortenFQN());
        }
        this.setSearchTargets(matchOptions);
        this.myFileTypeChooser.setSelectedItem(matchOptions.getFileType(), matchOptions.getDialect(), matchOptions.getPatternContext());
        Editor searchEditor = this.mySearchCriteriaEdit.getEditor();
        if (searchEditor != null) {
            searchEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
        this.setEditorContent(false, matchOptions.getSearchPattern());
        Editor replaceEditor = this.myReplaceCriteriaEdit.getEditor();
        if (replaceEditor != null) {
            replaceEditor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
        }
        this.setEditorContent(true, replaceOptions.getReplacement());
        this.updateOptions();
    }

    private void setEditorContent(boolean replace, String text2) {
        this.myChangedConfiguration = true;
        UIUtil.setContent(replace ? this.myReplaceCriteriaEdit : this.mySearchCriteriaEdit, text2);
        this.myChangedConfiguration = false;
    }

    private void saveConfiguration() {
        MatchOptions matchOptions = this.myConfiguration.getMatchOptions();
        if (this.myScopePanel.isVisible()) {
            SearchScope scope = this.myScopePanel.getScope();
            boolean searchWithinHierarchy = IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(scope.getDisplayName());
            matchOptions.setScope((SearchScope)(searchWithinHierarchy && !this.myPerformAction ? GlobalSearchScope.projectScope((Project)this.myProject) : scope));
        } else {
            matchOptions.setScope(null);
        }
        matchOptions.setSearchPattern(this.getPattern(this.mySearchCriteriaEdit));
        matchOptions.setRecursiveSearch(!this.myReplace);
        ReplaceOptions replaceOptions = this.myConfiguration.getReplaceOptions();
        replaceOptions.setReplacement(this.getPattern(this.myReplaceCriteriaEdit));
    }

    private String getPattern(EditorTextField textField) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(this.myFileType);
        if (profile != null) {
            Document document = textField.getDocument();
            String pattern = (String)ReadAction.compute(() -> {
                PsiFile file = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
                assert (file != null);
                return profile.getCodeFragmentText(file);
            });
            return pattern.isEmpty() ? textField.getText() : pattern;
        }
        return textField.getText();
    }

    public void dispose() {
        this.myProject.putUserData(STRUCTURAL_SEARCH_PREVIOUS_CONFIGURATION, (Object)this.myConfiguration);
        this.storeDimensions();
        this.saveUIState();
        StructuralSearchPlugin.getInstance(this.myProject).setDialog(null);
        this.myAlarm.cancelAllRequests();
        this.mySearchCriteriaEdit.removeNotify();
        this.myReplaceCriteriaEdit.removeNotify();
        this.removeRestartHighlightingListenerFromCurrentEditor();
        super.dispose();
    }

    private void loadUIState() {
        UIState uiState = UIState.getInstance();
        if (this.isFilterPanelVisible() != uiState.filtersVisible) {
            this.mySearchEditorPanel.setSecondComponent(uiState.filtersVisible ? this.myFilterPanel.getComponent() : null);
        }
        this.setExistingTemplatesPanelVisible(uiState.existingTemplatesVisible);
        this.myExistingTemplatesComponent.setTreeState(uiState.templatesTreeState);
        if (!this.myEditConfigOnly) {
            this.myPinned = uiState.pinned;
            this.myInjected.setSelected(uiState.searchInjectedCode);
            this.myMatchCase.setSelected(uiState.matchCase);
            if (uiState.scopeDescriptor != null && uiState.scopeType != null) {
                this.myScopePanel.setScope(Scopes.createScope(this.myProject, uiState.scopeDescriptor, uiState.scopeType));
            }
            this.myShortenFqn.setSelected(uiState.shortenFQNames);
            this.myStaticImport.setSelected(uiState.useStaticImport);
            this.myReformat.setSelected(uiState.reformat);
        }
    }

    private void saveUIState() {
        if (this.mySearchEditorPanel == null) {
            return;
        }
        UIState uiState = UIState.getInstance();
        uiState.filtersVisible = this.isFilterPanelVisible();
        uiState.existingTemplatesVisible = this.isExistingTemplatesPanelVisible();
        uiState.templatesTreeState = this.myExistingTemplatesComponent.getTreeState();
        if (!this.myEditConfigOnly) {
            uiState.pinned = this.myPinned;
            if (this.myInjected.isVisible()) {
                uiState.searchInjectedCode = this.myInjected.isSelected();
            }
            uiState.matchCase = this.myMatchCase.isSelected();
            if (this.myScopePanel.isVisible()) {
                SearchScope scope = this.myScopePanel.getScope();
                uiState.scopeDescriptor = Scopes.getDescriptor(scope);
                uiState.scopeType = Scopes.getType(scope);
            }
            if (this.myReplace) {
                if (this.myShortenFqn.isVisible()) {
                    uiState.shortenFQNames = this.myShortenFqn.isSelected();
                }
                if (this.myStaticImport.isVisible()) {
                    uiState.useStaticImport = this.myStaticImport.isSelected();
                }
                uiState.reformat = this.myReformat.isSelected();
            }
        }
    }

    private void storeDimensions() {
        if (this.myEditConfigOnly) {
            return;
        }
        String key1 = this.myReplace ? REPLACE_DIMENSION_SERVICE_KEY : SEARCH_DIMENSION_SERVICE_KEY;
        String key2 = this.myReplace ? SEARCH_DIMENSION_SERVICE_KEY : REPLACE_DIMENSION_SERVICE_KEY;
        Point location = this.getLocation();
        if (location.x < 0) {
            location.x = 0;
        }
        if (location.y < 0) {
            location.y = 0;
        }
        DimensionService dimensionService = DimensionService.getInstance();
        dimensionService.setLocation(SEARCH_DIMENSION_SERVICE_KEY, location, this.myProject);
        Dimension size = this.getSize();
        dimensionService.setSize(key1, size, this.myProject);
        Dimension otherSize = dimensionService.getSize(key2, this.myProject);
        if (otherSize != null && otherSize.width != size.width) {
            otherSize.width = size.width;
            dimensionService.setSize(key2, otherSize, this.myProject);
        }
    }

    protected String getHelpId() {
        return "find.structuredSearch";
    }

    private void updateColors() {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.myComponentsWithEditorBackground.forEach(component -> component.setBackground(scheme.getDefaultBackground()));
        Border borderTopBottom = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)1, (int)0, (int)1, (int)0);
        if (this.myEditConfigOnly) {
            Border borderTopOnly = JBUI.Borders.customLine((Color)JBUI.CurrentTheme.Editor.BORDER_COLOR, (int)1, (int)0, (int)0, (int)0);
            if (this.mySearchWrapper != null) {
                this.mySearchWrapper.setBorder(this.myReplace ? borderTopBottom : borderTopOnly);
            }
            if (this.myReplaceWrapper != null) {
                this.myReplaceWrapper.setBorder(borderTopOnly);
            }
        } else {
            if (this.mySearchWrapper != null) {
                this.mySearchWrapper.setBorder(borderTopBottom);
            }
            if (this.myReplaceWrapper != null) {
                this.myReplaceWrapper.setBorder(borderTopBottom);
            }
        }
        this.myExistingTemplatesComponent.updateColors();
    }

    private void exportToClipboard() {
        String text2 = ConfigurationUtil.toXml(this.getConfiguration());
        String html = "<html><body><pre><code>" + StringUtil.escapeXmlEntities((String)text2) + "</code></pre></body></html>";
        CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(html, text2));
    }

    private void importFromClipboard() {
        String contents = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        if (!this.loadConfiguration(contents)) {
            this.reportMessage(SSRBundle.message("no.template.found.warning", new Object[0]), false, (JComponent)this.mySearchCriteriaEdit);
        }
    }

    private void switchSearchReplace() {
        this.storeDimensions();
        this.myReplace = !this.myReplace;
        this.setTitle(this.getDefaultTitle());
        this.myReplacePanel.setVisible(this.myReplace);
        this.loadConfiguration(this.myConfiguration);
        Dimension size = DimensionService.getInstance().getSize(this.myReplace ? REPLACE_DIMENSION_SERVICE_KEY : SEARCH_DIMENSION_SERVICE_KEY, this.myProject);
        if (size != null) {
            this.setSize(size.width, size.height);
        } else {
            this.pack();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchResults";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTitle";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplacePanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidationThreadToUse";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addMatchHighlights";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reportMessage";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5, 6, 10, 11, 12 -> new IllegalStateException(string2);
        };
    }

    private class MyEditorTextField
    extends EditorTextField {
        private final boolean myReplace;

        MyEditorTextField(Document document, boolean replace) {
            super(document, StructuralSearchDialog.this.myProject, (FileType)StructuralSearchDialog.this.myFileType, false, false);
            this.myReplace = replace;
        }

        @NotNull
        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(StructuralSearchDialog.this.myFileType);
            if (profile != null) {
                TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)UIUtil.getTemplateContextType(profile));
            }
            SubstitutionShortInfoHandler.install((Editor)editor, StructuralSearchDialog.this.myFilterPanel, variableName -> {
                if (variableName.endsWith("$replacement")) {
                    variableName = StringUtil.trimEnd((String)variableName, (String)"$replacement");
                    assert (this.myReplace);
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddReplacementVariable(variableName, StructuralSearchDialog.this.myConfiguration));
                } else {
                    StructuralSearchDialog.this.myFilterPanel.initFilters(UIUtil.getOrAddVariableConstraint(variableName, StructuralSearchDialog.this.myConfiguration));
                }
            }, StructuralSearchDialog.this.myDisposable, this.myReplace);
            editor.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)StructuralSearchDialog.this.myConfiguration);
            this.getDocument().putUserData(StructuralSearchDialogKeys.STRUCTURAL_SEARCH_ERROR_CALLBACK, () -> {
                if (this.getClientProperty("JComponent.outline") == null) {
                    StructuralSearchDialog.this.initValidation();
                }
            });
            TextCompletionUtil.installCompletionHint((EditorEx)editor);
            editor.putUserData(StructuralSearchDialogKeys.STRUCTURAL_SEARCH_DIALOG, (Object)StructuralSearchDialog.this);
            editor.putUserData(StructuralSearchDialogKeys.AI_SUPPORT_KEY, (Object)(!this.myReplace ? 1 : 0));
            editor.setEmbeddedIntoDialogWrapper(true);
            editor.putUserData(IncrementalFindAction.SEARCH_DISABLED, (Object)Boolean.TRUE);
            EditorEx editorEx = editor;
            if (editorEx == null) {
                MyEditorTextField.$$$reportNull$$$0(0);
            }
            return editorEx;
        }

        protected void updateBorder(@NotNull EditorEx editor) {
            if (editor == null) {
                MyEditorTextField.$$$reportNull$$$0(1);
            }
            this.setupBorder(editor);
            JScrollPane scrollPane = editor.getScrollPane();
            scrollPane.setBorder(new ErrorBorder(scrollPane.getBorder()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$MyEditorTextField";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$MyEditorTextField";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "updateBorder";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1 -> new IllegalArgumentException(string2);
            };
        }
    }

    private class ImportConfigurationAction
    extends AnAction
    implements DumbAware {
        ImportConfigurationAction() {
            super(SSRBundle.messagePointer("import.template.action", new Object[0]), AllIcons.ToolbarDecorator.Import);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ImportConfigurationAction.$$$reportNull$$$0(0);
            }
            StructuralSearchDialog.this.importFromClipboard();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$ImportConfigurationAction", "actionPerformed"));
        }
    }

    private class ExportConfigurationAction
    extends AnAction
    implements DumbAware {
        ExportConfigurationAction() {
            super(SSRBundle.messagePointer("export.template.action", new Object[0]), AllIcons.ToolbarDecorator.Export);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExportConfigurationAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(!StringUtil.isEmptyOrSpaces((String)StructuralSearchDialog.this.mySearchCriteriaEdit.getText()));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ExportConfigurationAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExportConfigurationAction.$$$reportNull$$$0(2);
            }
            StructuralSearchDialog.this.exportToClipboard();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$ExportConfigurationAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$ExportConfigurationAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private class SwitchAction
    extends AnAction
    implements DumbAware {
        SwitchAction() {
            this.getTemplatePresentation().setIcon(AllIcons.Actions.Refresh);
            ActionManager actionManager = ActionManager.getInstance();
            ShortcutSet searchShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralSearchAction").getShortcutSet();
            ShortcutSet replaceShortcutSet = actionManager.getAction("StructuralSearchPlugin.StructuralReplaceAction").getShortcutSet();
            CompositeShortcutSet shortcutSet = StructuralSearchDialog.this.myReplace ? new CompositeShortcutSet(new ShortcutSet[]{searchShortcutSet, replaceShortcutSet}) : new CompositeShortcutSet(new ShortcutSet[]{replaceShortcutSet, searchShortcutSet});
            this.registerCustomShortcutSet((ShortcutSet)shortcutSet, StructuralSearchDialog.this.getRootPane());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SwitchAction.$$$reportNull$$$0(0);
            }
            StructuralSearchDialog.this.switchSearchReplace();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SwitchAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setText(SSRBundle.messagePointer(StructuralSearchDialog.this.myReplace ? "switch.to.search.action" : "switch.to.replace.action", new Object[0]));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SwitchAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$SwitchAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/StructuralSearchDialog$SwitchAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }

    private static class ErrorBorder
    implements Border {
        private final Border myErrorBorder;

        ErrorBorder(Border errorBorder) {
            this.myErrorBorder = errorBorder;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            EditorTextField editorTextField = (EditorTextField)ComponentUtil.getParentOfType(EditorTextField.class, (Component)c);
            if (editorTextField == null) {
                return;
            }
            DarculaUIUtil.Outline object = DarculaUIUtil.getOutline((JComponent)editorTextField);
            if (DarculaUIUtil.isWarningOrError((DarculaUIUtil.Outline)object)) {
                this.myErrorBorder.paintBorder(c, g, x, y, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.myErrorBorder.getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

