/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.completion.visitors;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.lang.Language;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.EditorConfigLanguage;
import org.editorconfig.language.codeinsight.completion.visitors.EditorConfigValueCompletionCollector;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptorVisitor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigListDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigOptionDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigPairDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J\t\u0010\u001b\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006'"}, d2={"Lorg/editorconfig/language/codeinsight/completion/visitors/EditorConfigValueCompletionCollectorInitiator;", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptorVisitor;", "childElement", "Lorg/editorconfig/language/psi/interfaces/EditorConfigDescribableElement;", "results", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lorg/editorconfig/language/psi/interfaces/EditorConfigDescribableElement;Lcom/intellij/codeInsight/completion/CompletionResultSet;Lcom/intellij/psi/PsiFile;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "visitOption", "", "option", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigOptionDescriptor;", "visitList", "list", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigListDescriptor;", "visitPair", "pair", "Lorg/editorconfig/language/schema/descriptors/impl/EditorConfigPairDescriptor;", "visitDescriptor", "descriptor", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptor;", "collectCompletions", "element", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.editorconfig"})
public final class EditorConfigValueCompletionCollectorInitiator
implements EditorConfigDescriptorVisitor {
    @NotNull
    private final EditorConfigDescribableElement childElement;
    @NotNull
    private final CompletionResultSet results;
    @NotNull
    private final PsiFile file;

    public EditorConfigValueCompletionCollectorInitiator(@NotNull EditorConfigDescribableElement childElement, @NotNull CompletionResultSet results, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.childElement = childElement;
        this.results = results;
        this.file = file;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @Override
    public void visitOption(@NotNull EditorConfigOptionDescriptor option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        this.collectCompletions(option.getValue());
    }

    @Override
    public void visitList(@NotNull EditorConfigListDescriptor list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this.collectCompletions(list);
    }

    @Override
    public void visitPair(@NotNull EditorConfigPairDescriptor pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"pair");
        this.collectCompletions(pair.getSecond());
    }

    @Override
    public void visitDescriptor(@NotNull EditorConfigDescriptor descriptor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            EditorConfigDescriptor editorConfigDescriptor = descriptor.getParent();
            if (editorConfigDescriptor == null) break block0;
            editorConfigDescriptor.accept(this);
        }
    }

    private final void collectCompletions(EditorConfigDescriptor element) {
        CommonCodeStyleSettings commonCodeStyleSettings = CodeStyle.getLanguageSettings((PsiFile)this.file, (Language)EditorConfigLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)commonCodeStyleSettings, (String)"getLanguageSettings(...)");
        CommonCodeStyleSettings settings = commonCodeStyleSettings;
        EditorConfigValueCompletionCollector collector = new EditorConfigValueCompletionCollector(this.results, this.childElement, settings);
        element.accept(collector);
    }

    private final EditorConfigDescribableElement component1() {
        return this.childElement;
    }

    private final CompletionResultSet component2() {
        return this.results;
    }

    @NotNull
    public final PsiFile component3() {
        return this.file;
    }

    @NotNull
    public final EditorConfigValueCompletionCollectorInitiator copy(@NotNull EditorConfigDescribableElement childElement, @NotNull CompletionResultSet results, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)childElement, (String)"childElement");
        Intrinsics.checkNotNullParameter((Object)results, (String)"results");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new EditorConfigValueCompletionCollectorInitiator(childElement, results, file);
    }

    public static /* synthetic */ EditorConfigValueCompletionCollectorInitiator copy$default(EditorConfigValueCompletionCollectorInitiator editorConfigValueCompletionCollectorInitiator, EditorConfigDescribableElement editorConfigDescribableElement, CompletionResultSet completionResultSet, PsiFile psiFile, int n, Object object) {
        if ((n & 1) != 0) {
            editorConfigDescribableElement = editorConfigValueCompletionCollectorInitiator.childElement;
        }
        if ((n & 2) != 0) {
            completionResultSet = editorConfigValueCompletionCollectorInitiator.results;
        }
        if ((n & 4) != 0) {
            psiFile = editorConfigValueCompletionCollectorInitiator.file;
        }
        return editorConfigValueCompletionCollectorInitiator.copy(editorConfigDescribableElement, completionResultSet, psiFile);
    }

    @NotNull
    public String toString() {
        return "EditorConfigValueCompletionCollectorInitiator(childElement=" + this.childElement + ", results=" + this.results + ", file=" + this.file + ")";
    }

    public int hashCode() {
        int result2 = this.childElement.hashCode();
        result2 = result2 * 31 + this.results.hashCode();
        result2 = result2 * 31 + this.file.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EditorConfigValueCompletionCollectorInitiator)) {
            return false;
        }
        EditorConfigValueCompletionCollectorInitiator editorConfigValueCompletionCollectorInitiator = (EditorConfigValueCompletionCollectorInitiator)other;
        if (!Intrinsics.areEqual((Object)this.childElement, (Object)editorConfigValueCompletionCollectorInitiator.childElement)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.results, (Object)editorConfigValueCompletionCollectorInitiator.results)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.file, (Object)editorConfigValueCompletionCollectorInitiator.file);
    }
}

