/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.assertj.core.util.Lists;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.ComponentMatcher;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.TypeMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.util.TimeoutWatch;

final class JComboBoxDropDownListFinder {
    static final ComponentMatcher LIST_MATCHER = new TypeMatcher(JList.class);
    private final Robot robot;

    JComboBoxDropDownListFinder(Robot robot) {
        this.robot = robot;
    }

    @Nullable
    @RunsInEDT
    JList<?> findDropDownList() {
        JPopupMenu popup = this.robot.findActivePopupMenu();
        if (popup == null) {
            TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(this.robot.settings().timeoutToFindPopup());
            popup = this.robot.findActivePopupMenu();
            while (popup == null) {
                if (watch.isTimeOut()) {
                    return null;
                }
                Pause.pause();
                popup = this.robot.findActivePopupMenu();
            }
        }
        return this.findListIn(popup);
    }

    @Nullable
    private JList<?> findListIn(@Nonnull Container parent) {
        ArrayList<Component> found = Lists.newArrayList(this.robot.finder().findAll(parent, LIST_MATCHER));
        if (found.size() != 1) {
            return null;
        }
        return (JList)found.get(0);
    }
}

