/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CompressionUtil;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.io.VersionUpdatedException;
import com.intellij.util.io.WalOpCode;
import com.intellij.util.io.WalRecord;
import com.intellij.util.io.WriteAheadLogKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003BG\b\u0007\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u000f\u0010\u0010J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u001a\u001a\u00020\u0018*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\f\u0010\u001d\u001a\u00020\u001b*\u00020\u001eH\u0002J\u001d\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010#J\u001d\u0010$\u001a\u00020 2\u0006\u0010!\u001a\u00028\u00002\u0006\u0010%\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00020 2\u0006\u0010!\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010(J\f\u0010)\u001a\u00020\u0018*\u00020 H\u0002J\u001b\u0010*\u001a\u00020\u00182\u0006\u0010!\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u001e\u00a2\u0006\u0002\u0010+J\u001b\u0010,\u001a\u00020\u00182\u0006\u0010!\u001a\u00028\u00002\u0006\u0010%\u001a\u00028\u0001\u00a2\u0006\u0002\u0010-J\u0013\u0010.\u001a\u00020\u00182\u0006\u0010!\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\u0006\u00100\u001a\u00020\u0018J\b\u00101\u001a\u00020\u0018H\u0016J\u0006\u00102\u001a\u00020\u0018R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00063"}, d2={"Lcom/intellij/util/io/PersistentMapWal;", "K", "V", "Ljava/io/Closeable;", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "valueExternalizer", "Lcom/intellij/util/io/DataExternalizer;", "useCompression", "", "file", "Ljava/nio/file/Path;", "walIoExecutor", "Ljava/util/concurrent/ExecutorService;", "compact", "<init>", "(Lcom/intellij/util/io/KeyDescriptor;Lcom/intellij/util/io/DataExternalizer;ZLjava/nio/file/Path;Ljava/util/concurrent/ExecutorService;Z)V", "out", "Lcom/intellij/util/io/DataOutputStream;", "version", "", "getVersion", "()I", "ensureCompatible", "", "expectedVersion", "write", "", "outputStream", "writeToByteArray", "Lcom/intellij/util/io/AppendablePersistentMap$ValueDataAppender;", "appendRecord", "Lcom/intellij/util/io/WalRecord;", "key", "appender", "(Ljava/lang/Object;Lcom/intellij/util/io/AppendablePersistentMap$ValueDataAppender;)Lcom/intellij/util/io/WalRecord;", "putRecord", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Lcom/intellij/util/io/WalRecord;", "removeRecord", "(Ljava/lang/Object;)Lcom/intellij/util/io/WalRecord;", "submitWrite", "appendData", "(Ljava/lang/Object;Lcom/intellij/util/io/AppendablePersistentMap$ValueDataAppender;)V", "put", "(Ljava/lang/Object;Ljava/lang/Object;)V", "remove", "(Ljava/lang/Object;)V", "flush", "close", "closeAndDelete", "intellij.platform.util"})
public final class PersistentMapWal<K, V>
implements Closeable {
    @NotNull
    private final KeyDescriptor<K> keyDescriptor;
    @NotNull
    private final DataExternalizer<V> valueExternalizer;
    private final boolean useCompression;
    @NotNull
    private final Path file;
    @NotNull
    private final ExecutorService walIoExecutor;
    @NotNull
    private final DataOutputStream out;
    private final int version;

    @JvmOverloads
    public PersistentMapWal(@NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer, boolean useCompression, @NotNull Path file, @NotNull ExecutorService walIoExecutor, boolean compact) throws IOException {
        Intrinsics.checkNotNullParameter(keyDescriptor, "keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, "valueExternalizer");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(walIoExecutor, "walIoExecutor");
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
        this.useCompression = useCompression;
        this.file = file;
        this.walIoExecutor = walIoExecutor;
        if (compact) {
            Path path = WriteAheadLogKt.access$tryCompact(this.file, this.keyDescriptor, this.valueExternalizer);
            if (path != null) {
                Path compactedWal = path;
                boolean bl = false;
                FileUtil.deleteWithRenaming(this.file);
                FileUtil.rename(compactedWal.toFile(), this.file.toFile());
            }
        }
        this.ensureCompatible(this.version, this.useCompression, this.file);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.APPEND};
        OutputStream outputStream = Files.newOutputStream(this.file, openOptionArray);
        Intrinsics.checkNotNullExpressionValue(outputStream, "newOutputStream(...)");
        OutputStream outputStream2 = outputStream;
        int n = 8192;
        this.out = new DataOutputStream(outputStream2 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream2 : new BufferedOutputStream(outputStream2, n));
    }

    public /* synthetic */ PersistentMapWal(KeyDescriptor keyDescriptor, DataExternalizer dataExternalizer, boolean bl, Path path, ExecutorService executorService, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(keyDescriptor, dataExternalizer, bl, path, executorService, bl2);
    }

    public final int getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureCompatible(int expectedVersion, boolean useCompression, Path file) throws IOException {
        Pair<Integer, Boolean> pair;
        if (!Files.exists(file, new LinkOption[0])) {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Object object = new OpenOption[]{StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE};
            object = new DataOutputStream(Files.newOutputStream(file, object));
            Throwable throwable = null;
            try {
                Object it = (DataOutputStream)object;
                boolean bl = false;
                DataInputOutputUtil.writeINT((DataOutput)it, expectedVersion);
                ((java.io.DataOutputStream)it).writeBoolean(useCompression);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
            return;
        }
        Object object = new OpenOption[]{StandardOpenOption.READ};
        object = new DataInputStream(Files.newInputStream(file, object));
        Throwable it = null;
        try {
            DataInputStream it2 = (DataInputStream)object;
            boolean bl = false;
            pair = TuplesKt.to(DataInputOutputUtil.readINT(it2), it2.readBoolean());
        }
        catch (Throwable throwable) {
            it = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, it);
        }
        Pair<Integer, Boolean> pair2 = pair;
        int actualVersion = ((Number)pair2.component1()).intValue();
        boolean actualUsesCompression = pair2.component2();
        if (actualVersion != expectedVersion) {
            throw new VersionUpdatedException(file, expectedVersion, actualVersion);
        }
        if (actualUsesCompression != useCompression) {
            throw new VersionUpdatedException(file, useCompression, actualUsesCompression);
        }
    }

    private final void write(byte[] $this$write, DataOutputStream outputStream) {
        if (this.useCompression) {
            CompressionUtil.writeCompressed(outputStream, $this$write, 0, $this$write.length);
        } else {
            outputStream.writeInt($this$write.length);
            outputStream.write($this$write);
        }
    }

    private final byte[] writeToByteArray(AppendablePersistentMap.ValueDataAppender $this$writeToByteArray) {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        $this$writeToByteArray.append(new DataOutputStream(baos));
        byte[] byArray = baos.toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
        return byArray;
    }

    private final WalRecord appendRecord(K key, AppendablePersistentMap.ValueDataAppender appender) {
        return WalRecord.Companion.writeRecord(WalOpCode.APPEND, arg_0 -> PersistentMapWal.appendRecord$lambda$3(this, key, appender, arg_0));
    }

    private final WalRecord putRecord(K key, V value) {
        return WalRecord.Companion.writeRecord(WalOpCode.PUT, arg_0 -> PersistentMapWal.putRecord$lambda$4(this, key, value, arg_0));
    }

    private final WalRecord removeRecord(K key) {
        return WalRecord.Companion.writeRecord(WalOpCode.REMOVE, arg_0 -> PersistentMapWal.removeRecord$lambda$5(this, key, arg_0));
    }

    private final void submitWrite(WalRecord $this$submitWrite) {
        this.walIoExecutor.submit(() -> PersistentMapWal.submitWrite$lambda$6($this$submitWrite, this));
    }

    public final void appendData(K key, @NotNull AppendablePersistentMap.ValueDataAppender appender) throws IOException {
        Intrinsics.checkNotNullParameter(appender, "appender");
        this.submitWrite(this.appendRecord(key, appender));
    }

    public final void put(K key, V value) throws IOException {
        this.submitWrite(this.putRecord(key, value));
    }

    public final void remove(K key) throws IOException {
        this.submitWrite(this.removeRecord(key));
    }

    public final void flush() throws IOException {
        this.walIoExecutor.submit(() -> PersistentMapWal.flush$lambda$7(this)).get();
    }

    @Override
    public void close() throws IOException {
        this.walIoExecutor.submit(() -> PersistentMapWal.close$lambda$8(this)).get();
    }

    public final void closeAndDelete() throws IOException {
        this.close();
        FileUtil.deleteWithRenaming(this.file);
    }

    @JvmOverloads
    public PersistentMapWal(@NotNull KeyDescriptor<K> keyDescriptor, @NotNull DataExternalizer<V> valueExternalizer, boolean useCompression, @NotNull Path file, @NotNull ExecutorService walIoExecutor) throws IOException {
        Intrinsics.checkNotNullParameter(keyDescriptor, "keyDescriptor");
        Intrinsics.checkNotNullParameter(valueExternalizer, "valueExternalizer");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(walIoExecutor, "walIoExecutor");
        this(keyDescriptor, valueExternalizer, useCompression, file, walIoExecutor, false, 32, null);
    }

    private static final Unit appendRecord$lambda$3(PersistentMapWal this$0, Object $key, AppendablePersistentMap.ValueDataAppender $appender, DataOutputStream it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyDescriptor.save(it, $key);
        this$0.write(this$0.writeToByteArray($appender), it);
        return Unit.INSTANCE;
    }

    private static final Unit putRecord$lambda$4(PersistentMapWal this$0, Object $key, Object $value, DataOutputStream it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyDescriptor.save(it, $key);
        this$0.write(WriteAheadLogKt.access$writeData($value, this$0.valueExternalizer), it);
        return Unit.INSTANCE;
    }

    private static final Unit removeRecord$lambda$5(PersistentMapWal this$0, Object $key, DataOutputStream it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.keyDescriptor.save(it, $key);
        return Unit.INSTANCE;
    }

    private static final void submitWrite$lambda$6(WalRecord $this_submitWrite, PersistentMapWal this$0) {
        if (WriteAheadLogKt.getDebugWalRecords()) {
            System.out.println((Object)("write: " + $this_submitWrite));
        }
        $this_submitWrite.write(this$0.out);
    }

    private static final void flush$lambda$7(PersistentMapWal this$0) {
        this$0.out.flush();
    }

    private static final void close$lambda$8(PersistentMapWal this$0) {
        this$0.out.close();
    }
}

