/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class CompletionStageResponseHandler
implements ServerRestHandler {
    @Override
    public void handle(ResteasyReactiveRequestContext requestContext) throws Exception {
        Object object = requestContext.getResult();
        if (object instanceof CompletionStage) {
            final CompletionStage result = (CompletionStage)object;
            requestContext.suspend();
            final AtomicBoolean done = new AtomicBoolean();
            final AtomicBoolean canceled = new AtomicBoolean();
            result.handle((? super T v, Throwable t) -> {
                done.set(true);
                if (canceled.get()) {
                    try {
                        requestContext.close();
                    }
                    catch (Exception exception) {}
                } else {
                    if (t != null) {
                        if (t instanceof CompletionException) {
                            CompletionException ce = (CompletionException)t;
                            requestContext.handleException(ce.getCause(), true);
                        } else {
                            requestContext.handleException((Throwable)t, true);
                        }
                    } else {
                        requestContext.setResult(v);
                    }
                    requestContext.resume();
                }
                return null;
            });
            requestContext.serverResponse().addCloseHandler(new Runnable(){

                @Override
                public void run() {
                    if (!done.get() && result instanceof CompletableFuture) {
                        CompletableFuture cf = (CompletableFuture)result;
                        canceled.set(true);
                        cf.cancel(true);
                    }
                }
            });
        }
    }
}

