/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.authentication.AuthenticationFlow;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormAuthenticator;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

public class FormAuthenticationFlow
implements AuthenticationFlow {
    AuthenticationProcessor processor;
    AuthenticationExecutionModel formExecution;
    private final List<AuthenticationExecutionModel> formActionExecutions;
    private final FormAuthenticator formAuthenticator;

    public FormAuthenticationFlow(AuthenticationProcessor processor, AuthenticationExecutionModel execution) {
        this.processor = processor;
        this.formExecution = execution;
        this.formActionExecutions = processor.getRealm().getAuthenticationExecutionsStream(execution.getFlowId()).collect(Collectors.toList());
        this.formAuthenticator = (FormAuthenticator)processor.getSession().getProvider(FormAuthenticator.class, execution.getAuthenticator());
    }

    public Response processAction(String actionExecution) {
        if (!actionExecution.equals(this.formExecution.getId())) {
            throw new AuthenticationFlowException("action is not current execution", AuthenticationFlowError.INTERNAL_ERROR);
        }
        HashMap<String, CommonClientSessionModel.ExecutionStatus> executionStatus = new HashMap<String, CommonClientSessionModel.ExecutionStatus>();
        LinkedList<FormAction> requiredActions = new LinkedList<FormAction>();
        LinkedList<ValidationContextImpl> successes = new LinkedList<ValidationContextImpl>();
        LinkedList<ValidationContextImpl> errors = new LinkedList<ValidationContextImpl>();
        for (AuthenticationExecutionModel authenticationExecutionModel : this.formActionExecutions) {
            if (!authenticationExecutionModel.isEnabled()) {
                executionStatus.put(authenticationExecutionModel.getId(), CommonClientSessionModel.ExecutionStatus.SKIPPED);
                continue;
            }
            FormActionFactory factory = (FormActionFactory)this.processor.getSession().getKeycloakSessionFactory().getProviderFactory(FormAction.class, authenticationExecutionModel.getAuthenticator());
            FormAction action = (FormAction)factory.create(this.processor.getSession());
            UserModel authUser = this.processor.getAuthenticationSession().getAuthenticatedUser();
            if (action.requiresUser() && authUser == null) {
                throw new AuthenticationFlowException("form action: " + this.formExecution.getAuthenticator() + " requires user", AuthenticationFlowError.UNKNOWN_USER);
            }
            boolean configuredFor = false;
            if (action.requiresUser() && authUser != null && !(configuredFor = action.configuredFor(this.processor.getSession(), this.processor.getRealm(), authUser))) {
                if (authenticationExecutionModel.isRequired()) {
                    if (factory.isUserSetupAllowed()) {
                        AuthenticationProcessor.logger.debugv("authenticator SETUP_REQUIRED: {0}", (Object)this.formExecution.getAuthenticator());
                        executionStatus.put(authenticationExecutionModel.getId(), CommonClientSessionModel.ExecutionStatus.SETUP_REQUIRED);
                        requiredActions.add(action);
                        continue;
                    }
                    throw new AuthenticationFlowException(AuthenticationFlowError.CREDENTIAL_SETUP_REQUIRED);
                }
                if (authenticationExecutionModel.isConditional()) {
                    executionStatus.put(authenticationExecutionModel.getId(), CommonClientSessionModel.ExecutionStatus.SKIPPED);
                    continue;
                }
            }
            ValidationContextImpl result = new ValidationContextImpl(authenticationExecutionModel, action);
            action.validate((ValidationContext)result);
            if (result.success) {
                executionStatus.put(authenticationExecutionModel.getId(), CommonClientSessionModel.ExecutionStatus.SUCCESS);
                successes.add(result);
                continue;
            }
            executionStatus.put(authenticationExecutionModel.getId(), CommonClientSessionModel.ExecutionStatus.CHALLENGED);
            errors.add(result);
        }
        if (!errors.isEmpty()) {
            this.processor.logFailure();
            LinkedList<FormMessage> messages = new LinkedList<FormMessage>();
            HashSet<String> hashSet = new HashSet<String>();
            block1: for (ValidationContextImpl v : errors) {
                for (FormMessage m : v.errors) {
                    if (hashSet.contains(m.getField())) continue;
                    if (v.excludeOthers) {
                        hashSet.clear();
                        messages.clear();
                    }
                    hashSet.add(m.getField());
                    messages.add(m);
                    if (!v.excludeOthers) continue;
                    continue block1;
                }
            }
            ValidationContextImpl first = (ValidationContextImpl)errors.get(0);
            first.getEvent().error(first.error);
            return this.renderForm(first.formData, messages);
        }
        for (ValidationContextImpl validationContextImpl : successes) {
            validationContextImpl.action.success((FormContext)validationContextImpl);
        }
        for (Map.Entry entry : executionStatus.entrySet()) {
            this.processor.getAuthenticationSession().setExecutionStatus((String)entry.getKey(), (CommonClientSessionModel.ExecutionStatus)entry.getValue());
        }
        for (FormAction formAction : requiredActions) {
            formAction.setRequiredActions(this.processor.getSession(), this.processor.getRealm(), this.processor.getAuthenticationSession().getAuthenticatedUser());
        }
        this.processor.getAuthenticationSession().setExecutionStatus(actionExecution, CommonClientSessionModel.ExecutionStatus.SUCCESS);
        this.processor.getAuthenticationSession().removeAuthNote("current.authentication.execution");
        return null;
    }

    public URI getActionUrl(String executionId, String code) {
        ClientModel client = this.processor.getAuthenticationSession().getClient();
        UriBuilder builder = LoginActionsService.registrationFormProcessor(this.processor.getUriInfo()).queryParam("session_code", new Object[]{code}).queryParam("execution", new Object[]{executionId}).queryParam("client_id", new Object[]{client.getClientId()}).queryParam("tab_id", new Object[]{this.processor.getAuthenticationSession().getTabId()}).queryParam("client_data", new Object[]{AuthenticationProcessor.getClientData(this.processor.getSession(), this.processor.getAuthenticationSession())});
        MultivaluedMap query = this.processor.getSession().getContext().getUri().getQueryParameters();
        List token = (List)query.get((Object)"token");
        if (token != null && !token.isEmpty()) {
            builder.queryParam("token", new Object[]{token.get(0)});
        }
        return builder.build(new Object[]{this.processor.getRealm().getName()});
    }

    public Response processFlow() {
        FormMessage forwardedErrorMessage = this.processor.getAndRemoveForwardedErrorMessage();
        List<FormMessage> errors = forwardedErrorMessage != null ? Collections.singletonList(forwardedErrorMessage) : null;
        return this.renderForm(null, errors);
    }

    public Response renderForm(MultivaluedMap<String, String> formData, List<FormMessage> errors) {
        String executionId = this.formExecution.getId();
        this.processor.getAuthenticationSession().setAuthNote("current.authentication.execution", executionId);
        String code = this.processor.generateCode();
        URI actionUrl = this.getActionUrl(executionId, code);
        LoginFormsProvider form = ((LoginFormsProvider)this.processor.getSession().getProvider(LoginFormsProvider.class)).setAuthenticationSession(this.processor.getAuthenticationSession()).setActionUri(actionUrl).setExecution(executionId).setClientSessionCode(code).setFormData(formData).setErrors(errors);
        for (AuthenticationExecutionModel formActionExecution : this.formActionExecutions) {
            if (!formActionExecution.isEnabled()) continue;
            FormAction action = (FormAction)this.processor.getSession().getProvider(FormAction.class, formActionExecution.getAuthenticator());
            FormContextImpl result = new FormContextImpl(formActionExecution);
            action.buildPage((FormContext)result, form);
        }
        FormContextImpl context = new FormContextImpl(this.formExecution);
        return this.formAuthenticator.render((FormContext)context, form);
    }

    public boolean isSuccessful() {
        return false;
    }

    private class ValidationContextImpl
    extends FormContextImpl
    implements ValidationContext {
        FormAction action;
        String error;
        boolean excludeOthers;
        boolean success;
        List<FormMessage> errors;
        MultivaluedMap<String, String> formData;

        private ValidationContextImpl(AuthenticationExecutionModel executionModel, FormAction action) {
            super(executionModel);
            this.errors = null;
            this.formData = null;
            this.action = action;
        }

        public void validationError(MultivaluedMap<String, String> formData, List<FormMessage> errors) {
            this.errors = errors;
            this.formData = formData;
        }

        public void error(String error) {
            this.error = error;
        }

        public void success() {
            this.success = true;
        }

        public void excludeOtherErrors() {
            this.excludeOthers = true;
        }
    }

    private class FormContextImpl
    implements FormContext {
        AuthenticationExecutionModel executionModel;
        AuthenticatorConfigModel authenticatorConfig;

        private FormContextImpl(AuthenticationExecutionModel executionModel) {
            this.executionModel = executionModel;
        }

        public EventBuilder newEvent() {
            return FormAuthenticationFlow.this.processor.newEvent();
        }

        public EventBuilder getEvent() {
            return FormAuthenticationFlow.this.processor.getEvent();
        }

        public AuthenticationExecutionModel getExecution() {
            return this.executionModel;
        }

        public AuthenticatorConfigModel getAuthenticatorConfig() {
            if (this.executionModel.getAuthenticatorConfig() == null) {
                return null;
            }
            if (this.authenticatorConfig != null) {
                return this.authenticatorConfig;
            }
            this.authenticatorConfig = this.getRealm().getAuthenticatorConfigById(this.executionModel.getAuthenticatorConfig());
            return this.authenticatorConfig;
        }

        public UserModel getUser() {
            return this.getAuthenticationSession().getAuthenticatedUser();
        }

        public void setUser(UserModel user) {
            FormAuthenticationFlow.this.processor.setAutheticatedUser(user);
        }

        public RealmModel getRealm() {
            return FormAuthenticationFlow.this.processor.getRealm();
        }

        public AuthenticationSessionModel getAuthenticationSession() {
            return FormAuthenticationFlow.this.processor.getAuthenticationSession();
        }

        public ClientConnection getConnection() {
            return FormAuthenticationFlow.this.processor.getConnection();
        }

        public UriInfo getUriInfo() {
            return FormAuthenticationFlow.this.processor.getUriInfo();
        }

        public KeycloakSession getSession() {
            return FormAuthenticationFlow.this.processor.getSession();
        }

        public HttpRequest getHttpRequest() {
            return FormAuthenticationFlow.this.processor.getRequest();
        }
    }
}

