/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.component.ComponentFactory;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.OID4VCEnvironmentProviderFactory;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningProperties;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;
import org.keycloak.provider.ConfigurationValidationHelper;
import org.keycloak.provider.ProviderConfigurationBuilder;

public interface VCSigningServiceProviderFactory
extends ComponentFactory<VerifiableCredentialsSigningService, VerifiableCredentialsSigningService>,
OID4VCEnvironmentProviderFactory {
    public static ProviderConfigurationBuilder configurationBuilder() {
        return ProviderConfigurationBuilder.create().property(SigningProperties.ALGORITHM_TYPE.asConfigProperty());
    }

    default public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel model) throws ComponentValidationException {
        ConfigurationValidationHelper.check((ComponentModel)model).checkRequired(SigningProperties.ALGORITHM_TYPE.asConfigProperty());
        this.validateSpecificConfiguration(session, realm, model);
    }

    default public void close() {
    }

    default public void init(Config.Scope config) {
    }

    default public void postInit(KeycloakSessionFactory factory) {
    }

    @Override
    default public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.OID4VC_VCI);
    }

    public void validateSpecificConfiguration(KeycloakSession var1, RealmModel var2, ComponentModel var3) throws ComponentValidationException;

    public String supportedFormat();
}

