/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AuthenticatorData<T extends ExtensionAuthenticatorOutput>
implements Serializable {
    public static final byte BIT_UP = 1;
    public static final byte BIT_UV = 4;
    public static final byte BIT_BE = 8;
    public static final byte BIT_BS = 16;
    public static final byte BIT_AT = 64;
    public static final byte BIT_ED = -128;
    private final byte[] rpIdHash;
    private final byte flags;
    private final long signCount;
    private final AttestedCredentialData attestedCredentialData;
    private final AuthenticationExtensionsAuthenticatorOutputs<T> extensions;

    public AuthenticatorData(@NonNull byte[] rpIdHash, byte flags, long counter, @Nullable AttestedCredentialData attestedCredentialData, @Nullable AuthenticationExtensionsAuthenticatorOutputs<T> extensions) {
        this.assertRpIdHash(rpIdHash);
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = attestedCredentialData;
        this.extensions = extensions;
    }

    public AuthenticatorData(@NonNull byte[] rpIdHash, byte flags, long counter, @Nullable AttestedCredentialData attestedCredentialData) {
        this.assertRpIdHash(rpIdHash);
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = attestedCredentialData;
        this.extensions = new AuthenticationExtensionsAuthenticatorOutputs();
    }

    public AuthenticatorData(@NonNull byte[] rpIdHash, byte flags, long counter, @Nullable AuthenticationExtensionsAuthenticatorOutputs<T> extensions) {
        this.assertRpIdHash(rpIdHash);
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = null;
        this.extensions = extensions;
    }

    public AuthenticatorData(@NonNull byte[] rpIdHash, byte flags, long counter) {
        this.assertRpIdHash(rpIdHash);
        this.rpIdHash = rpIdHash;
        this.flags = flags;
        this.signCount = counter;
        this.attestedCredentialData = null;
        this.extensions = new AuthenticationExtensionsAuthenticatorOutputs();
    }

    public static boolean checkFlagUP(byte flags) {
        return (flags & 1) != 0;
    }

    public static boolean checkFlagUV(byte flags) {
        return (flags & 4) != 0;
    }

    public static boolean checkFlagBE(byte flags) {
        return (flags & 8) != 0;
    }

    public static boolean checkFlagBS(byte flags) {
        return (flags & 0x10) != 0;
    }

    public static boolean checkFlagAT(byte flags) {
        return (flags & 0x40) != 0;
    }

    public static boolean checkFlagED(byte flags) {
        return (flags & 0xFFFFFF80) != 0;
    }

    public @NonNull byte[] getRpIdHash() {
        return ArrayUtil.clone((byte[])this.rpIdHash);
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean isFlagUP() {
        return AuthenticatorData.checkFlagUP(this.flags);
    }

    public boolean isFlagUV() {
        return AuthenticatorData.checkFlagUV(this.flags);
    }

    public boolean isFlagBE() {
        return AuthenticatorData.checkFlagBE(this.flags);
    }

    public boolean isFlagBS() {
        return AuthenticatorData.checkFlagBS(this.flags);
    }

    public boolean isFlagAT() {
        return AuthenticatorData.checkFlagAT(this.flags);
    }

    public boolean isFlagED() {
        return AuthenticatorData.checkFlagED(this.flags);
    }

    public long getSignCount() {
        return this.signCount;
    }

    public @Nullable AttestedCredentialData getAttestedCredentialData() {
        return this.attestedCredentialData;
    }

    public @Nullable AuthenticationExtensionsAuthenticatorOutputs<T> getExtensions() {
        return this.extensions;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorData that = (AuthenticatorData)o;
        return this.flags == that.flags && this.signCount == that.signCount && Arrays.equals(this.rpIdHash, that.rpIdHash) && Objects.equals(this.attestedCredentialData, that.attestedCredentialData) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        int result = Objects.hash(this.flags, this.signCount, this.attestedCredentialData, this.extensions);
        result = 31 * result + Arrays.hashCode(this.rpIdHash);
        return result;
    }

    public String toString() {
        return "AuthenticatorData(rpIdHash=" + ArrayUtil.toHexString((byte[])this.rpIdHash) + ", flags=" + String.format("%02X", this.flags) + ", signCount=" + this.signCount + ", attestedCredentialData=" + this.attestedCredentialData + ", extensions=" + this.extensions + ')';
    }

    private void assertRpIdHash(@Nullable @NonNull byte[] rpIdHash) {
        AssertUtil.notNull((Object)rpIdHash, (String)"rpIdHash must not be null");
    }
}

