/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.deployment;

import io.quarkus.agroal.runtime.DataSourcesJdbcBuildTimeConfig;
import io.quarkus.agroal.runtime.TransactionIntegration;
import io.quarkus.agroal.runtime.health.DataSourceHealthCheck;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.agroal.spi.JdbcDriverBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BuildTimeConditionBuildItem;
import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceResultBuildItem;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import io.quarkus.hibernate.orm.deployment.HibernateOrmConfig;
import io.quarkus.hibernate.orm.deployment.PersistenceXmlDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationRuntimeConfiguredBuildItem;
import io.quarkus.hibernate.orm.deployment.spi.AdditionalJpaModelBuildItem;
import io.quarkus.narayana.jta.runtime.TransactionManagerBuildTimeConfig;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import jakarta.persistence.Entity;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Handler;
import org.eclipse.microprofile.health.Readiness;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.boot.internal.PersistenceXmlParser;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticatorSpi;
import org.keycloak.authentication.authenticators.browser.DeployedScriptAuthenticatorFactory;
import org.keycloak.authorization.policy.provider.PolicySpi;
import org.keycloak.authorization.policy.provider.js.DeployedScriptPolicyFactory;
import org.keycloak.common.Profile;
import org.keycloak.common.crypto.FipsMode;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.config.DatabaseOptions;
import org.keycloak.config.HealthOptions;
import org.keycloak.config.HttpOptions;
import org.keycloak.config.ManagementOptions;
import org.keycloak.config.MetricsOptions;
import org.keycloak.config.Option;
import org.keycloak.config.SecurityOptions;
import org.keycloak.config.TracingOptions;
import org.keycloak.connections.jpa.DefaultJpaConnectionProviderFactory;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionSpi;
import org.keycloak.connections.jpa.updater.liquibase.LiquibaseJpaUpdaterProviderFactory;
import org.keycloak.connections.jpa.updater.liquibase.conn.DefaultLiquibaseConnectionProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.policy.BlacklistPasswordPolicyProviderFactory;
import org.keycloak.protocol.ProtocolMapperSpi;
import org.keycloak.protocol.oidc.mappers.DeployedScriptOIDCProtocolMapper;
import org.keycloak.protocol.saml.mappers.DeployedScriptSAMLProtocolMapper;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderManager;
import org.keycloak.provider.Spi;
import org.keycloak.quarkus.deployment.CheckJdbcBuildStep;
import org.keycloak.quarkus.deployment.CheckMultipleDatasourcesBuildStep;
import org.keycloak.quarkus.deployment.ConfigBuildItem;
import org.keycloak.quarkus.deployment.CryptoProviderInitBuildItem;
import org.keycloak.quarkus.deployment.IsIntegrationTest;
import org.keycloak.quarkus.deployment.IsManagementEnabled;
import org.keycloak.quarkus.deployment.IsReAugmentation;
import org.keycloak.quarkus.deployment.KeycloakSessionFactoryPreInitBuildItem;
import org.keycloak.quarkus.deployment.ProfileBuildItem;
import org.keycloak.quarkus.deployment.UserProfileBuildItem;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.KeycloakRecorder;
import org.keycloak.quarkus.runtime.Providers;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.KeycloakConfigSourceProvider;
import org.keycloak.quarkus.runtime.configuration.MicroProfileConfigProvider;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.quarkus.runtime.integration.resteasy.KeycloakHandlerChainCustomizer;
import org.keycloak.quarkus.runtime.integration.resteasy.KeycloakTracingCustomizer;
import org.keycloak.quarkus.runtime.services.health.KeycloakReadyHealthCheck;
import org.keycloak.quarkus.runtime.storage.database.jpa.NamedJpaConnectionProviderFactory;
import org.keycloak.quarkus.runtime.themes.FlatClasspathThemeResourceProviderFactory;
import org.keycloak.representations.provider.ScriptProviderDescriptor;
import org.keycloak.representations.provider.ScriptProviderMetadata;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.services.DefaultKeycloakSessionFactory;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.resources.LoadBalancerResource;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.theme.ClasspathThemeProviderFactory;
import org.keycloak.theme.ClasspathThemeResourceProviderFactory;
import org.keycloak.theme.FolderThemeProviderFactory;
import org.keycloak.theme.JarThemeProviderFactory;
import org.keycloak.theme.ThemeResourceSpi;
import org.keycloak.transaction.JBossJtaTransactionManagerLookup;
import org.keycloak.userprofile.config.UPConfigUtils;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;
import org.keycloak.vault.FilesKeystoreVaultProviderFactory;
import org.keycloak.vault.FilesPlainTextVaultProviderFactory;

class KeycloakProcessor {
    private static final Logger logger = Logger.getLogger(KeycloakProcessor.class);
    private static final String JAR_FILE_SEPARATOR = "!/";
    private static final Map<String, Function<ScriptProviderMetadata, ProviderFactory>> DEPLOYEABLE_SCRIPT_PROVIDERS = new HashMap<String, Function<ScriptProviderMetadata, ProviderFactory>>();
    private static final String KEYCLOAK_SCRIPTS_JSON_PATH = "META-INF/keycloak-scripts.json";
    private static final List<Class<? extends ProviderFactory>> IGNORED_PROVIDER_FACTORY = List.of(JBossJtaTransactionManagerLookup.class, DefaultJpaConnectionProviderFactory.class, DefaultLiquibaseConnectionProvider.class, FolderThemeProviderFactory.class, LiquibaseJpaUpdaterProviderFactory.class, FilesKeystoreVaultProviderFactory.class, FilesPlainTextVaultProviderFactory.class, BlacklistPasswordPolicyProviderFactory.class, ClasspathThemeResourceProviderFactory.class, JarThemeProviderFactory.class);

    KeycloakProcessor() {
    }

    private static ProviderFactory registerScriptAuthenticator(ScriptProviderMetadata metadata) {
        return new DeployedScriptAuthenticatorFactory(metadata);
    }

    private static ProviderFactory registerScriptPolicy(ScriptProviderMetadata metadata) {
        return new DeployedScriptPolicyFactory(metadata);
    }

    private static ProviderFactory registerScriptMapper(ScriptProviderMetadata metadata) {
        return new DeployedScriptOIDCProtocolMapper(metadata);
    }

    private static ProviderFactory registerSAMLScriptMapper(ScriptProviderMetadata metadata) {
        return new DeployedScriptSAMLProtocolMapper(metadata);
    }

    @BuildStep
    FeatureBuildItem getFeature() {
        return new FeatureBuildItem("keycloak");
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    @Produce(value=ConfigBuildItem.class)
    void initConfig(KeycloakRecorder recorder) {
        Config.init((Config.ConfigProvider)new MicroProfileConfigProvider());
        recorder.initConfig();
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    @Consume(value=ConfigBuildItem.class)
    @Produce(value=ProfileBuildItem.class)
    void configureProfile(KeycloakRecorder recorder) {
        Profile profile = Environment.getCurrentOrCreateFeatureProfile();
        recorder.configureProfile(profile.getName(), profile.getFeatures());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    @Consume(value=ConfigBuildItem.class)
    void configureRedirectForRootPath(BuildProducer<RouteBuildItem> routes, HttpRootPathBuildItem httpRootPathBuildItem, KeycloakRecorder recorder) {
        Configuration.getOptionalKcValue((Option)HttpOptions.HTTP_RELATIVE_PATH).filter(StringUtil::isNotBlank).filter(f -> !f.equals("/")).ifPresent(relativePath -> routes.produce((BuildItem)httpRootPathBuildItem.routeBuilder().route("/").handler(recorder.getRedirectHandler(relativePath)).build()));
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep(onlyIf={IsManagementEnabled.class})
    @Consume(value=ConfigBuildItem.class)
    void configureManagementInterface(BuildProducer<RouteBuildItem> routes, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, KeycloakRecorder recorder) {
        String relativePath = Configuration.getOptionalKcValue((Option)ManagementOptions.HTTP_MANAGEMENT_RELATIVE_PATH).orElse("/");
        if (StringUtil.isNotBlank((String)relativePath) && !relativePath.equals("/")) {
            routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().management().route("/").handler(recorder.getRedirectHandler(relativePath)).build());
        }
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().management().route(relativePath).handler(recorder.getManagementHandler()).build());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    @Consume(value=ConfigBuildItem.class)
    void configureTruststore(KeycloakRecorder recorder) {
        recorder.configureTruststore();
    }

    @BuildStep
    @Produce(value=CheckJdbcBuildStep.class)
    void checkJdbcDriver(BuildProducer<JdbcDriverBuildItem> ignore) {
        Optional dbDriver = Configuration.getOptionalValue((String)"quarkus.datasource.jdbc.driver");
        if (dbDriver.isPresent()) {
            try {
                Class.forName((String)dbDriver.get(), false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                this.throwConfigError(String.format("Unable to find the JDBC driver (%s). You need to install it.", dbDriver.get()));
            }
        }
    }

    @BuildStep
    @Produce(value=CheckMultipleDatasourcesBuildStep.class)
    void checkMultipleDatasourcesUseXA(TransactionManagerBuildTimeConfig transactionManagerConfig, DataSourcesBuildTimeConfig dataSourcesConfig, DataSourcesJdbcBuildTimeConfig jdbcConfig) {
        if (transactionManagerConfig.unsafeMultipleLastResources.orElse(TransactionManagerBuildTimeConfig.UnsafeMultipleLastResourcesMode.DEFAULT) != TransactionManagerBuildTimeConfig.UnsafeMultipleLastResourcesMode.FAIL) {
            return;
        }
        long nonXADatasourcesCount = dataSourcesConfig.dataSources().keySet().stream().map(ds -> ((DataSourcesJdbcBuildTimeConfig.DataSourceJdbcOuterNamedBuildTimeConfig)jdbcConfig.dataSources().get(ds)).jdbc()).filter(jdbc -> jdbc.enabled() && jdbc.transactions() != TransactionIntegration.XA).count();
        if (nonXADatasourcesCount > 1L) {
            this.throwConfigError("Multiple datasources are configured but more than 1 is using non-XA transactions. All the datasources except one must must be XA to be able to use Last Resource Commit Optimization (LRCO). Please update your configuration by setting --transaction-xa-enabled=true and/or quarkus.datasource.<your-datasource-name>.jdbc.transactions=xa.");
        }
    }

    private void throwConfigError(String msg) {
        InitialConfigurator.DELAYED_HANDLER.setBuildTimeHandlers(new Handler[0]);
        throw new ConfigurationException(msg);
    }

    @BuildStep
    @Produce(value=UserProfileBuildItem.class)
    UserProfileBuildItem parseDefaultUserProfileConfig() {
        UPConfig defaultConfig = UPConfigUtils.parseSystemDefaultConfig();
        logger.debug((Object)"Parsing default configuration for the User Profile provider");
        return new UserProfileBuildItem(defaultConfig);
    }

    @BuildStep
    @Consume(value=ProfileBuildItem.class)
    @Record(value=ExecutionTime.STATIC_INIT)
    void setDefaultUserProfileConfig(KeycloakRecorder recorder, UserProfileBuildItem configuration) {
        recorder.setDefaultUserProfileConfiguration(configuration.getDefaultConfig());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configurePersistenceUnits(HibernateOrmConfig config, List<PersistenceXmlDescriptorBuildItem> descriptors, List<JdbcDataSourceBuildItem> jdbcDataSources, BuildProducer<AdditionalJpaModelBuildItem> additionalJpaModel, CombinedIndexBuildItem indexBuildItem, BuildProducer<HibernateOrmIntegrationRuntimeConfiguredBuildItem> runtimeConfigured, KeycloakRecorder recorder) {
        ParsedPersistenceXmlDescriptor defaultUnitDescriptor = null;
        ArrayList<String> userManagedEntities = new ArrayList<String>();
        for (PersistenceXmlDescriptorBuildItem item : descriptors) {
            ParsedPersistenceXmlDescriptor descriptor = (ParsedPersistenceXmlDescriptor)item.getDescriptor();
            if ("keycloak-default".equals(descriptor.getName())) {
                defaultUnitDescriptor = descriptor;
                this.configureDefaultPersistenceUnitProperties(defaultUnitDescriptor, config, KeycloakProcessor.getDefaultDataSource(jdbcDataSources));
                runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem("keycloak", defaultUnitDescriptor.getName()).setInitListener(recorder.createDefaultUnitListener()));
                continue;
            }
            Properties properties = descriptor.getProperties();
            runtimeConfigured.produce((BuildItem)new HibernateOrmIntegrationRuntimeConfiguredBuildItem("keycloak", descriptor.getName()).setInitListener(recorder.createUserDefinedUnitListener(properties.getProperty("hibernate.connection.datasource"))));
            userManagedEntities.addAll(descriptor.getManagedClassNames());
        }
        if (defaultUnitDescriptor == null) {
            throw new RuntimeException("No default persistence unit found.");
        }
        this.configureDefaultPersistenceUnitEntities(defaultUnitDescriptor, indexBuildItem, userManagedEntities);
    }

    @BuildStep
    @Consume.List(value={@Consume(value=CheckJdbcBuildStep.class), @Consume(value=CheckMultipleDatasourcesBuildStep.class)})
    void produceDefaultPersistenceUnit(BuildProducer<PersistenceXmlDescriptorBuildItem> producer) {
        ParsedPersistenceXmlDescriptor descriptor = PersistenceXmlParser.locateIndividualPersistenceUnit((URL)Thread.currentThread().getContextClassLoader().getResource("default-persistence.xml"));
        producer.produce((BuildItem)new PersistenceXmlDescriptorBuildItem((PersistenceUnitDescriptor)descriptor));
    }

    private void configureDefaultPersistenceUnitProperties(ParsedPersistenceXmlDescriptor descriptor, HibernateOrmConfig config, JdbcDataSourceBuildItem defaultDataSource) {
        if (defaultDataSource == null || !defaultDataSource.isDefault()) {
            throw new RuntimeException("The server datasource must be the default datasource.");
        }
        Properties unitProperties = descriptor.getProperties();
        Optional dialect = Configuration.getOptionalKcValue((String)DatabaseOptions.DB_DIALECT.getKey());
        dialect.ifPresent(d -> unitProperties.setProperty("hibernate.dialect", (String)d));
        Optional defaultSchema = Configuration.getOptionalKcValue((String)DatabaseOptions.DB_SCHEMA.getKey());
        defaultSchema.ifPresent(ds -> unitProperties.setProperty("hibernate.default_schema", (String)ds));
        unitProperties.setProperty("jakarta.persistence.transactionType", PersistenceUnitTransactionType.JTA.name());
        descriptor.setTransactionType(PersistenceUnitTransactionType.JTA);
        unitProperties.setProperty("hibernate.query.startup_check", Boolean.FALSE.toString());
        String dbKind = defaultDataSource.getDbKind();
        for (Map.Entry<Object, Object> query : JpaUtils.loadSpecificNamedQueries((String)dbKind.toLowerCase()).entrySet()) {
            unitProperties.setProperty("kc.query." + String.valueOf(query.getKey()), query.getValue().toString());
        }
    }

    private void configureDefaultPersistenceUnitEntities(ParsedPersistenceXmlDescriptor descriptor, CombinedIndexBuildItem indexBuildItem, List<String> userManagedEntities) {
        IndexView index = indexBuildItem.getIndex();
        Collection annotations = index.getAnnotations(DotName.createSimple((String)Entity.class.getName()));
        for (AnnotationInstance annotation : annotations) {
            AnnotationTarget target = annotation.target();
            String targetName = target.asClass().name().toString();
            if (userManagedEntities.contains(targetName) || targetName.startsWith("org.keycloak") && !targetName.startsWith("org.keycloak.testsuite")) continue;
            descriptor.addClasses(new String[]{targetName});
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    @Consume(value=CryptoProviderInitBuildItem.class)
    @Produce(value=KeycloakSessionFactoryPreInitBuildItem.class)
    void configureKeycloakSessionFactory(KeycloakRecorder recorder, List<PersistenceXmlDescriptorBuildItem> descriptors) {
        HashMap<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories = new HashMap<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>>();
        HashMap<Class<? extends Provider>, String> defaultProviders = new HashMap<Class<? extends Provider>, String>();
        HashMap<String, ProviderFactory> preConfiguredProviders = new HashMap<String, ProviderFactory>();
        for (Map.Entry<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> entry : this.loadFactories(preConfiguredProviders).entrySet()) {
            Spi spi = entry.getKey();
            this.checkProviders(spi, entry.getValue(), defaultProviders);
            for (Map.Entry<Class<? extends Provider>, Map<String, ProviderFactory>> value : entry.getValue().entrySet()) {
                for (ProviderFactory factory : value.getValue().values()) {
                    factories.computeIfAbsent(spi, key -> new HashMap()).computeIfAbsent(spi.getProviderClass(), aClass -> new HashMap()).put(factory.getId(), factory.getClass());
                }
            }
            if (spi instanceof JpaConnectionSpi) {
                this.configureUserDefinedPersistenceUnits(descriptors, factories, preConfiguredProviders, spi);
            }
            if (!(spi instanceof ThemeResourceSpi)) continue;
            this.configureThemeResourceProviders(factories, spi);
        }
        recorder.configSessionFactory(factories, defaultProviders, preConfiguredProviders, this.loadThemesFromClassPath());
    }

    private List<ClasspathThemeProviderFactory.ThemesRepresentation> loadThemesFromClassPath() {
        try {
            ArrayList<ClasspathThemeProviderFactory.ThemesRepresentation> themes = new ArrayList<ClasspathThemeProviderFactory.ThemesRepresentation>();
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/keycloak-themes.json");
            while (resources.hasMoreElements()) {
                themes.add((ClasspathThemeProviderFactory.ThemesRepresentation)JsonSerialization.readValue((InputStream)resources.nextElement().openStream(), ClasspathThemeProviderFactory.ThemesRepresentation.class));
            }
            return themes;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load themes", e);
        }
    }

    private void configureThemeResourceProviders(Map<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories, Spi spi) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = classLoader.getResources("theme-resources");
            if (resources.hasMoreElements()) {
                factories.computeIfAbsent(spi, key -> new HashMap()).computeIfAbsent(spi.getProviderClass(), aClass -> new HashMap()).put("flat-classpath", FlatClasspathThemeResourceProviderFactory.class);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to install default theme resource provider", e);
        }
    }

    private void configureUserDefinedPersistenceUnits(List<PersistenceXmlDescriptorBuildItem> descriptors, Map<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories, Map<String, ProviderFactory> preConfiguredProviders, Spi spi) {
        descriptors.stream().map(PersistenceXmlDescriptorBuildItem::getDescriptor).map(PersistenceUnitDescriptor::getName).filter(Predicate.not("keycloak-default"::equals)).forEach(unitName -> {
            NamedJpaConnectionProviderFactory factory = new NamedJpaConnectionProviderFactory();
            factory.setUnitName(unitName);
            ((Map)((Map)factories.get(spi)).get(JpaConnectionProvider.class)).put(unitName, NamedJpaConnectionProviderFactory.class);
            preConfiguredProviders.put((String)unitName, (ProviderFactory)factory);
        });
    }

    @BuildStep(onlyIfNot={IsIntegrationTest.class})
    void configureConfigSources(BuildProducer<StaticInitConfigBuilderBuildItem> configSources) {
        configSources.produce((BuildItem)new StaticInitConfigBuilderBuildItem(KeycloakConfigSourceProvider.class.getName()));
    }

    @BuildStep(onlyIf={IsIntegrationTest.class})
    void prepareTestEnvironment(BuildProducer<StaticInitConfigBuilderBuildItem> configSources, DevServicesDatasourceResultBuildItem dbConfig) {
        configSources.produce((BuildItem)new StaticInitConfigBuilderBuildItem("org.keycloak.quarkus.runtime.configuration.test.TestKeycloakConfigSourceProvider"));
        if (dbConfig != null && dbConfig.getDefaultDatasource() != null) {
            Map configProperties = dbConfig.getDefaultDatasource().getConfigProperties();
            for (Map.Entry dbConfigProperty : configProperties.entrySet()) {
                String kcProperty;
                PropertyMapper mapper = PropertyMappers.getMapper((String)((String)dbConfigProperty.getKey()));
                if (mapper == null || (kcProperty = mapper.getFrom()).endsWith("db")) continue;
                System.setProperty(kcProperty, (String)dbConfigProperty.getValue());
            }
        }
    }

    @BuildStep(onlyIf={IsReAugmentation.class})
    void persistBuildTimeProperties(BuildProducer<GeneratedResourceBuildItem> resources) {
        Properties properties = Picocli.getNonPersistedBuildTimeOptions();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            properties.store(outputStream, " Auto-generated, DO NOT change this file");
            resources.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/keycloak-persisted.properties", outputStream.toByteArray()));
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to persist configuration", cause);
        }
    }

    @BuildStep
    void index(BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        indexDependencyBuildItemBuildProducer.produce((BuildItem)new IndexDependencyBuildItem("org.liquibase", "liquibase-core"));
        indexDependencyBuildItemBuildProducer.produce((BuildItem)new IndexDependencyBuildItem("org.keycloak", "keycloak-services"));
    }

    @BuildStep
    @Consume(value=CheckJdbcBuildStep.class)
    void indexJpaStore(BuildProducer<IndexDependencyBuildItem> indexDependencyBuildItemBuildProducer) {
        indexDependencyBuildItemBuildProducer.produce((BuildItem)new IndexDependencyBuildItem("org.keycloak", "keycloak-model-jpa"));
    }

    @BuildStep
    void disableHealthCheckBean(BuildProducer<BuildTimeConditionBuildItem> removeBeans, CombinedIndexBuildItem index) {
        if (!this.isHealthEnabled() || !this.isMetricsEnabled()) {
            ClassInfo disabledBean = index.getIndex().getClassByName(DotName.createSimple((String)KeycloakReadyHealthCheck.class.getName()));
            removeBeans.produce((BuildItem)new BuildTimeConditionBuildItem((AnnotationTarget)disabledBean.asClass(), false));
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem disableDefaultDataSourceHealthCheck() {
        return new AnnotationsTransformerBuildItem(AnnotationTransformation.forClasses().whenClass(c -> c.name().equals((Object)DotName.createSimple(DataSourceHealthCheck.class))).transform(t -> t.remove(a -> a.name().equals((Object)DotName.createSimple(Readiness.class)))));
    }

    @BuildStep
    void configureResteasy(CombinedIndexBuildItem index, BuildProducer<BuildTimeConditionBuildItem> buildTimeConditionBuildItemBuildProducer, BuildProducer<MethodScannerBuildItem> scanner) {
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_API)) {
            buildTimeConditionBuildItemBuildProducer.produce((BuildItem)new BuildTimeConditionBuildItem((AnnotationTarget)index.getIndex().getClassByName(DotName.createSimple((String)AdminRoot.class.getName())), false));
        }
        if (!MultiSiteUtils.isMultiSiteEnabled()) {
            buildTimeConditionBuildItemBuildProducer.produce((BuildItem)new BuildTimeConditionBuildItem((AnnotationTarget)index.getIndex().getClassByName(DotName.createSimple((String)LoadBalancerResource.class.getName())), false));
        }
        final ArrayList<Object> chainCustomizers = new ArrayList<Object>();
        chainCustomizers.add(new KeycloakHandlerChainCustomizer());
        if (Configuration.isTrue((Option)TracingOptions.TRACING_ENABLED)) {
            chainCustomizers.add(new KeycloakTracingCustomizer());
        }
        scanner.produce((BuildItem)new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                return chainCustomizers;
            }
        }));
    }

    @Consume(value=ProfileBuildItem.class)
    @Produce(value=CryptoProviderInitBuildItem.class)
    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setCryptoProvider(KeycloakRecorder recorder) {
        FipsMode fipsMode = Configuration.getOptionalValue((String)("kc." + SecurityOptions.FIPS_MODE.getKey())).map(FipsMode::valueOfOption).orElse(FipsMode.DISABLED);
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.FIPS) && !fipsMode.isFipsEnabled()) {
            fipsMode = FipsMode.NON_STRICT;
        } else if (fipsMode.isFipsEnabled() && !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.FIPS)) {
            throw new RuntimeException("FIPS mode cannot be enabled without enabling the FIPS feature --features=fips");
        }
        recorder.setCryptoProvider(fipsMode);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void configureDevMode(BuildProducer<HotDeploymentWatchedFileBuildItem> hotFiles) {
        hotFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem("META-INF/keycloak.conf"));
    }

    private Map<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> loadFactories(Map<String, ProviderFactory> preConfiguredProviders) {
        Config.init((Config.ConfigProvider)new MicroProfileConfigProvider());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ProviderManager pm = Providers.getProviderManager((ClassLoader)classLoader);
        HashMap<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>> factories = new HashMap<Spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>>>();
        for (Spi spi : pm.loadSpis()) {
            HashMap<Class, Map> providers = new HashMap<Class, Map>();
            ArrayList<Object> loadedFactories = new ArrayList<Object>();
            String provider = Config.getProvider((String)spi.getName());
            if (provider == null) {
                loadedFactories.addAll(pm.load(spi));
            } else {
                ProviderFactory factory = pm.load(spi, provider);
                if (factory != null) {
                    loadedFactories.add(factory);
                }
            }
            Map<String, ProviderFactory<?>> deployedScriptProviders = this.loadDeployedScriptProviders(classLoader, spi);
            loadedFactories.addAll(deployedScriptProviders.values());
            preConfiguredProviders.putAll(deployedScriptProviders);
            for (ProviderFactory providerFactory : loadedFactories) {
                if (IGNORED_PROVIDER_FACTORY.contains(providerFactory.getClass())) continue;
                Config.Scope scope = Config.scope((String[])new String[]{spi.getName(), providerFactory.getId()});
                if (this.isEnabled(providerFactory, scope)) {
                    if (spi.isInternal() && !this.isInternal(providerFactory)) {
                        ServicesLogger.LOGGER.spiMayChange(providerFactory.getId(), providerFactory.getClass().getName(), spi.getName());
                    }
                    providers.computeIfAbsent(spi.getProviderClass(), aClass -> new HashMap()).put(providerFactory.getId(), providerFactory);
                    continue;
                }
                logger.debugv("SPI {0} provider {1} disabled", (Object)spi.getName(), (Object)providerFactory.getId());
            }
            factories.put(spi, providers);
        }
        return factories;
    }

    private Map<String, ProviderFactory<?>> loadDeployedScriptProviders(ClassLoader classLoader, Spi spi) {
        HashMap providers = new HashMap();
        if (this.supportsDeployeableScripts(spi)) {
            try {
                Enumeration<URL> descriptorsUrls = classLoader.getResources(KEYCLOAK_SCRIPTS_JSON_PATH);
                while (descriptorsUrls.hasMoreElements()) {
                    URL url = descriptorsUrls.nextElement();
                    List<ScriptProviderDescriptor> descriptors = this.getScriptProviderDescriptorsFromJarFile(url);
                    if (!Environment.isDistribution()) {
                        descriptors = new ArrayList<ScriptProviderDescriptor>(descriptors);
                        descriptors.addAll(this.getScriptProviderDescriptorsFromClassPath(url));
                    }
                    for (ScriptProviderDescriptor descriptor : descriptors) {
                        for (Map.Entry entry : descriptor.getProviders().entrySet()) {
                            if (!this.isScriptForSpi(spi, (String)entry.getKey())) continue;
                            for (ScriptProviderMetadata metadata : (List)entry.getValue()) {
                                ProviderFactory factory = DEPLOYEABLE_SCRIPT_PROVIDERS.get(entry.getKey()).apply(metadata);
                                providers.put(metadata.getId(), factory);
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to discover script providers", e);
            }
        }
        return providers;
    }

    private List<ScriptProviderDescriptor> getScriptProviderDescriptorsFromClassPath(URL url) throws IOException {
        String file = url.getFile();
        if (!file.endsWith(".json")) {
            return List.of();
        }
        ArrayList<ScriptProviderDescriptor> descriptors = new ArrayList<ScriptProviderDescriptor>();
        try (InputStream is = url.openStream();){
            ScriptProviderDescriptor descriptor = (ScriptProviderDescriptor)JsonSerialization.readValue((InputStream)is, ScriptProviderDescriptor.class);
            KeycloakProcessor.configureScriptDescriptor(descriptor, fileName -> {
                Path basePath = Path.of(url.getPath(), new String[0]).getParent().getParent();
                try {
                    return basePath.resolve((String)fileName).toUri().toURL().openStream();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read script file from: " + fileName);
                }
            });
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    private List<ScriptProviderDescriptor> getScriptProviderDescriptorsFromJarFile(URL url) throws IOException {
        String file = url.getFile();
        if (!file.contains(JAR_FILE_SEPARATOR)) {
            return List.of();
        }
        ArrayList<ScriptProviderDescriptor> descriptors = new ArrayList<ScriptProviderDescriptor>();
        try (JarFile jarFile = new JarFile(file.substring("file:".length(), file.indexOf(JAR_FILE_SEPARATOR)));){
            JarEntry descriptorEntry = jarFile.getJarEntry(KEYCLOAK_SCRIPTS_JSON_PATH);
            try (InputStream is = jarFile.getInputStream(descriptorEntry);){
                ScriptProviderDescriptor descriptor = (ScriptProviderDescriptor)JsonSerialization.readValue((InputStream)is, ScriptProviderDescriptor.class);
                KeycloakProcessor.configureScriptDescriptor(descriptor, fileName -> {
                    try {
                        JarEntry scriptFile = jarFile.getJarEntry((String)fileName);
                        return jarFile.getInputStream(scriptFile);
                    }
                    catch (IOException cause) {
                        throw new RuntimeException("Failed to read script file from file: " + fileName, cause);
                    }
                });
                descriptors.add(descriptor);
            }
        }
        return descriptors;
    }

    private static void configureScriptDescriptor(ScriptProviderDescriptor descriptor, Function<String, InputStream> jsFileLoader) throws IOException {
        for (List metadatas : descriptor.getProviders().values()) {
            for (ScriptProviderMetadata metadata : metadatas) {
                String fileName = metadata.getFileName();
                if (fileName == null) {
                    throw new RuntimeException("You must provide the script file name");
                }
                try (InputStream in = jsFileLoader.apply(fileName);){
                    metadata.setCode(StreamUtil.readString((InputStream)in, (Charset)StandardCharsets.UTF_8));
                }
                metadata.setId("script" + "-" + fileName);
                String name = metadata.getName();
                if (name == null) {
                    name = fileName;
                }
                metadata.setName(name);
            }
        }
    }

    private boolean isScriptForSpi(Spi spi, String type) {
        if (spi instanceof ProtocolMapperSpi && ("mappers".equals(type) || "saml-mappers".equals(type))) {
            return true;
        }
        if (spi instanceof PolicySpi && "policies".equals(type)) {
            return true;
        }
        return spi instanceof AuthenticatorSpi && "authenticators".equals(type);
    }

    private boolean supportsDeployeableScripts(Spi spi) {
        return spi instanceof ProtocolMapperSpi || spi instanceof PolicySpi || spi instanceof AuthenticatorSpi;
    }

    private boolean isEnabled(ProviderFactory factory, Config.Scope scope) {
        if (!scope.getBoolean("enabled", Boolean.valueOf(true)).booleanValue()) {
            return false;
        }
        if (factory instanceof EnvironmentDependentProviderFactory) {
            EnvironmentDependentProviderFactory environmentDependentProviderFactory = (EnvironmentDependentProviderFactory)factory;
            return environmentDependentProviderFactory.isSupported(scope);
        }
        return true;
    }

    private boolean isInternal(ProviderFactory<?> factory) {
        String packageName = factory.getClass().getPackage().getName();
        return packageName.startsWith("org.keycloak") && !packageName.startsWith("org.keycloak.examples");
    }

    private void checkProviders(Spi spi, Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoriesMap, Map<Class<? extends Provider>, String> defaultProviders) {
        String provider = Config.getProvider((String)spi.getName());
        if (provider != null) {
            Map<String, ProviderFactory> map = factoriesMap.get(spi.getProviderClass());
            if (map == null || map.get(provider) == null) {
                throw new RuntimeException("Failed to find provider " + provider + " for " + spi.getName());
            }
            defaultProviders.put(spi.getProviderClass(), provider);
        } else {
            Map<String, ProviderFactory> factories = factoriesMap.get(spi.getProviderClass());
            String defaultProvider = DefaultKeycloakSessionFactory.resolveDefaultProvider(factories, (Spi)spi);
            if (defaultProvider != null) {
                defaultProviders.put(spi.getProviderClass(), defaultProvider);
            }
        }
    }

    private boolean isMetricsEnabled() {
        return Configuration.isTrue((Option)MetricsOptions.METRICS_ENABLED);
    }

    private boolean isHealthEnabled() {
        return Configuration.isTrue((Option)HealthOptions.HEALTH_ENABLED);
    }

    static JdbcDataSourceBuildItem getDefaultDataSource(List<JdbcDataSourceBuildItem> jdbcDataSources) {
        for (JdbcDataSourceBuildItem jdbcDataSource : jdbcDataSources) {
            if (!jdbcDataSource.isDefault()) continue;
            return jdbcDataSource;
        }
        throw new RuntimeException("No default datasource found. The server datasource must be the default datasource.");
    }

    static {
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("authenticators", KeycloakProcessor::registerScriptAuthenticator);
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("policies", KeycloakProcessor::registerScriptPolicy);
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("mappers", KeycloakProcessor::registerScriptMapper);
        DEPLOYEABLE_SCRIPT_PROVIDERS.put("saml-mappers", KeycloakProcessor::registerSAMLScriptMapper);
    }
}

