/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHapticActionInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTION;
    public static final int SUBACTIONPATH;

    public XrHapticActionInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrHapticActionInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHapticActionInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHapticActionInfo.nnext(this.address());
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrHapticActionInfo.naction(this.address());
    }

    @NativeType(value="XrPath")
    public long subactionPath() {
        return XrHapticActionInfo.nsubactionPath(this.address());
    }

    public XrHapticActionInfo type(@NativeType(value="XrStructureType") int value) {
        XrHapticActionInfo.ntype(this.address(), value);
        return this;
    }

    public XrHapticActionInfo type$Default() {
        return this.type(59);
    }

    public XrHapticActionInfo next(@NativeType(value="void const *") long value) {
        XrHapticActionInfo.nnext(this.address(), value);
        return this;
    }

    public XrHapticActionInfo action(XrAction value) {
        XrHapticActionInfo.naction(this.address(), value);
        return this;
    }

    public XrHapticActionInfo subactionPath(@NativeType(value="XrPath") long value) {
        XrHapticActionInfo.nsubactionPath(this.address(), value);
        return this;
    }

    public XrHapticActionInfo set(int type, long next, XrAction action, long subactionPath) {
        this.type(type);
        this.next(next);
        this.action(action);
        this.subactionPath(subactionPath);
        return this;
    }

    public XrHapticActionInfo set(XrHapticActionInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrHapticActionInfo malloc() {
        return (XrHapticActionInfo)XrHapticActionInfo.wrap(XrHapticActionInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrHapticActionInfo calloc() {
        return (XrHapticActionInfo)XrHapticActionInfo.wrap(XrHapticActionInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrHapticActionInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrHapticActionInfo)XrHapticActionInfo.wrap(XrHapticActionInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrHapticActionInfo create(long address) {
        return (XrHapticActionInfo)XrHapticActionInfo.wrap(XrHapticActionInfo.class, (long)address);
    }

    @Nullable
    public static XrHapticActionInfo createSafe(long address) {
        return address == 0L ? null : (XrHapticActionInfo)XrHapticActionInfo.wrap(XrHapticActionInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrHapticActionInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrHapticActionInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrHapticActionInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHapticActionInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrHapticActionInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrHapticActionInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrHapticActionInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrHapticActionInfo malloc(MemoryStack stack) {
        return (XrHapticActionInfo)XrHapticActionInfo.wrap(XrHapticActionInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHapticActionInfo calloc(MemoryStack stack) {
        return (XrHapticActionInfo)XrHapticActionInfo.wrap(XrHapticActionInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrHapticActionInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrHapticActionInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ACTION));
    }

    public static long nsubactionPath(long struct) {
        return UNSAFE.getLong(null, struct + (long)SUBACTIONPATH);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTION), (long)value.address());
    }

    public static void nsubactionPath(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SUBACTIONPATH, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ACTION)));
    }

    static {
        Struct.Layout layout = XrHapticActionInfo.__struct((Struct.Member[])new Struct.Member[]{XrHapticActionInfo.__member((int)4), XrHapticActionInfo.__member((int)POINTER_SIZE), XrHapticActionInfo.__member((int)POINTER_SIZE), XrHapticActionInfo.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTION = layout.offsetof(2);
        SUBACTIONPATH = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrHapticActionInfo, Buffer>
    implements NativeResource {
        private static final XrHapticActionInfo ELEMENT_FACTORY = XrHapticActionInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrHapticActionInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHapticActionInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHapticActionInfo.nnext(this.address());
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrHapticActionInfo.naction(this.address());
        }

        @NativeType(value="XrPath")
        public long subactionPath() {
            return XrHapticActionInfo.nsubactionPath(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHapticActionInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(59);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHapticActionInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer action(XrAction value) {
            XrHapticActionInfo.naction(this.address(), value);
            return this;
        }

        public Buffer subactionPath(@NativeType(value="XrPath") long value) {
            XrHapticActionInfo.nsubactionPath(this.address(), value);
            return this;
        }
    }
}

