/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.other;

import java.util.Collections;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.hints.other.Bundle;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;

public class RemoveSurroundingTag
extends Hint {
    public static final Rule RULE = new RemoveSurroundingTagRule();

    public RemoveSurroundingTag(RuleContext context, OffsetRange range) {
        super(RULE, Bundle.MSG_RemoveSurroundingTag(), context.parserResult.getSnapshot().getSource().getFileObject(), range, Collections.singletonList(new SurroundWithTagHintFix(context)), 10);
    }

    private static Element[] findPairNodesAtSelection(RuleContext context) {
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        if (context.selectionStart == -1 || context.selectionEnd == -1) {
            OpenTag ot;
            CloseTag ct;
            Node containing;
            Snapshot snap = result.getSnapshot();
            int embeddedCaret = snap.getEmbeddedOffset(context.caretOffset);
            if (embeddedCaret != -1 && (containing = result.findBySemanticRange(embeddedCaret, false)) != null && containing.type() == ElementType.OPEN_TAG && (ct = (ot = (OpenTag)containing).matchingCloseTag()) != null) {
                return new Element[]{ot, ct};
            }
        } else {
            Element open = result.findByPhysicalRange(context.selectionStart, true);
            if (open == null || open.type() != ElementType.OPEN_TAG) {
                return null;
            }
            Element close = result.findByPhysicalRange(context.selectionEnd, false);
            if (close == null || close.type() != ElementType.CLOSE_TAG) {
                return null;
            }
            OpenTag openTag = (OpenTag)open;
            if (openTag.matchingCloseTag() != close) {
                return null;
            }
            return new Element[]{open, close};
        }
        return null;
    }

    private static class SurroundWithTagHintFix
    implements HintFix {
        RuleContext context;

        public SurroundWithTagHintFix(RuleContext context) {
            this.context = context;
        }

        public String getDescription() {
            return Bundle.MSG_RemoveSurroundingTag();
        }

        public void implement() throws Exception {
            this.context.doc.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        Element[] surroundingPair = RemoveSurroundingTag.findPairNodesAtSelection(context);
                        if (surroundingPair == null) {
                            return;
                        }
                        Snapshot s = context.parserResult.getSnapshot();
                        int otfrom = s.getOriginalOffset(surroundingPair[0].from());
                        int otto = s.getOriginalOffset(surroundingPair[0].to());
                        int otlen = otto - otfrom;
                        int ctfrom = s.getOriginalOffset(surroundingPair[1].from());
                        int ctto = s.getOriginalOffset(surroundingPair[1].to());
                        if (otfrom == -1 || otto == -1 || ctfrom == -1 || ctto == -1) {
                            return;
                        }
                        context.doc.remove(otfrom, otlen);
                        context.doc.remove(ctfrom - otlen, ctto - ctfrom);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static class RemoveSurroundingTagRule
    implements Rule {
        private RemoveSurroundingTagRule() {
        }

        public boolean appliesTo(RuleContext context) {
            return RemoveSurroundingTag.findPairNodesAtSelection(context) != null;
        }

        public String getDisplayName() {
            return Bundle.MSG_RemoveSurroundingTag();
        }

        public boolean showInTasklist() {
            return false;
        }

        public HintSeverity getDefaultSeverity() {
            return HintSeverity.INFO;
        }
    }
}

