/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteConsoleHistoryRequest
extends BmcRequest<Void> {
    private String instanceConsoleHistoryId;
    private String ifMatch;

    public String getInstanceConsoleHistoryId() {
        return this.instanceConsoleHistoryId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().instanceConsoleHistoryId(this.instanceConsoleHistoryId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceConsoleHistoryId=").append(String.valueOf(this.instanceConsoleHistoryId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteConsoleHistoryRequest)) {
            return false;
        }
        DeleteConsoleHistoryRequest other = (DeleteConsoleHistoryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceConsoleHistoryId, other.instanceConsoleHistoryId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceConsoleHistoryId == null ? 43 : this.instanceConsoleHistoryId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteConsoleHistoryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceConsoleHistoryId = null;
        private String ifMatch = null;

        public Builder instanceConsoleHistoryId(String instanceConsoleHistoryId) {
            this.instanceConsoleHistoryId = instanceConsoleHistoryId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteConsoleHistoryRequest o) {
            this.instanceConsoleHistoryId(o.getInstanceConsoleHistoryId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteConsoleHistoryRequest build() {
            DeleteConsoleHistoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteConsoleHistoryRequest buildWithoutInvocationCallback() {
            DeleteConsoleHistoryRequest request = new DeleteConsoleHistoryRequest();
            request.instanceConsoleHistoryId = this.instanceConsoleHistoryId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

