/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetTagRequest
extends BmcRequest<Void> {
    private String tagNamespaceId;
    private String tagName;

    public String getTagNamespaceId() {
        return this.tagNamespaceId;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Builder toBuilder() {
        return new Builder().tagNamespaceId(this.tagNamespaceId).tagName(this.tagName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",tagNamespaceId=").append(String.valueOf(this.tagNamespaceId));
        sb.append(",tagName=").append(String.valueOf(this.tagName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetTagRequest)) {
            return false;
        }
        GetTagRequest other = (GetTagRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.tagNamespaceId, other.tagNamespaceId) && Objects.equals(this.tagName, other.tagName);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.tagNamespaceId == null ? 43 : this.tagNamespaceId.hashCode());
        result = result * 59 + (this.tagName == null ? 43 : this.tagName.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetTagRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String tagNamespaceId = null;
        private String tagName = null;

        public Builder tagNamespaceId(String tagNamespaceId) {
            this.tagNamespaceId = tagNamespaceId;
            return this;
        }

        public Builder tagName(String tagName) {
            this.tagName = tagName;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetTagRequest o) {
            this.tagNamespaceId(o.getTagNamespaceId());
            this.tagName(o.getTagName());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetTagRequest build() {
            GetTagRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetTagRequest buildWithoutInvocationCallback() {
            GetTagRequest request = new GetTagRequest();
            request.tagNamespaceId = this.tagNamespaceId;
            request.tagName = this.tagName;
            return request;
        }
    }
}

