/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.CharConversionException;
import java.io.File;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.netbeans.core.multitabs.TabDecorator;
import org.netbeans.core.multitabs.prefs.SettingsImpl;
import org.netbeans.swing.popupswitcher.SwitcherTable;
import org.netbeans.swing.tabcontrol.TabData;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;
import org.openide.xml.XMLUtil;

public class FolderNameTabDecorator
extends TabDecorator {
    private final SettingsImpl settings = new SettingsImpl();
    private final String fadeColor;
    private final boolean isTab;

    public FolderNameTabDecorator() {
        this.fadeColor = this.fadeColor(Objects.requireNonNullElse(UIManager.getColor("nb.multitabs.foreground"), UIManager.getColor("TabbedPane.foreground")), Objects.requireNonNullElse(UIManager.getColor("nb.multitabs.background"), UIManager.getColor("TabbedPane.background")));
        this.isTab = true;
    }

    FolderNameTabDecorator(SwitcherTable switcher) {
        this.fadeColor = this.fadeColor(switcher.getForeground(), switcher.getBackground());
        this.isTab = false;
    }

    @Override
    public String getText(TabData tab) {
        FileObject folder;
        FileObject fo;
        TopComponent tc;
        DataObject dob;
        if (!this.settings.isShowFolderName()) {
            return null;
        }
        if (tab.getComponent() instanceof TopComponent && null != (dob = (DataObject)(tc = (TopComponent)tab.getComponent()).getLookup().lookup(DataObject.class)) && (fo = dob.getPrimaryFile()).isData() && null != (folder = fo.getParent())) {
            String folderName = folder.getNameExt() + File.separator;
            if (!this.isTab || !this.settings.isSameProjectSameColor()) {
                folderName = "<font color=\"" + this.fadeColor + "\">" + folderName + "</font>";
            }
            return FolderNameTabDecorator.merge(folderName, tab.getText());
        }
        return null;
    }

    @Override
    public Icon getIcon(TabData tab) {
        return null;
    }

    @Override
    public Color getBackground(TabData tab, boolean selected) {
        return null;
    }

    @Override
    public Color getForeground(TabData tab, boolean selected) {
        return null;
    }

    @Override
    public void paintAfter(TabData tab, Graphics g, Rectangle tabRect, boolean isSelected) {
    }

    private static String merge(String prefix, String baseText) {
        if (null == baseText) {
            baseText = "";
        }
        StringBuilder res = new StringBuilder(prefix.length() + baseText.length());
        if (baseText.toLowerCase().startsWith("<html>")) {
            res.append("<html>");
            res.append(prefix);
            res.append(baseText.substring(6));
        } else if (prefix.startsWith("<font")) {
            res.append("<html>");
            res.append(prefix);
            try {
                res.append(XMLUtil.toElementContent((String)baseText));
            }
            catch (CharConversionException ex) {
                res.append(baseText);
            }
        } else {
            res.append(prefix);
            res.append(baseText);
        }
        return res.toString();
    }

    private String fadeColor(Color f, Color b) {
        float a = FolderNameTabDecorator.isDarkLaF() ? 0.7f : 0.6f;
        return String.format("#%02x%02x%02x", (int)((float)b.getRed() + a * (float)(f.getRed() - b.getRed())), (int)((float)b.getGreen() + a * (float)(f.getGreen() - b.getGreen())), (int)((float)b.getBlue() + a * (float)(f.getBlue() - b.getBlue())));
    }

    private static boolean isDarkLaF() {
        return UIManager.getBoolean("nb.dark.theme");
    }
}

