/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Selector;

public class FeatureList {
    private Map<String, List<Feature>> features;
    private Map<String, FeatureList> lists;

    void add(Feature feature) {
        List<Feature> fs;
        Selector selector = feature.getSelector();
        FeatureList list = this;
        if (selector != null) {
            List<String> path = selector.getPath();
            for (int i = path.size() - 1; i >= 0; --i) {
                FeatureList newList;
                String name = path.get(i);
                if (list.lists == null) {
                    list.lists = new HashMap<String, FeatureList>();
                }
                if ((newList = list.lists.get(name)) == null) {
                    newList = new FeatureList();
                    list.lists.put(name, newList);
                }
                list = newList;
            }
        }
        if (list.features == null) {
            list.features = new HashMap<String, List<Feature>>();
        }
        if ((fs = list.features.get(feature.getFeatureName())) == null) {
            fs = new ArrayList<Feature>();
            list.features.put(feature.getFeatureName(), fs);
        }
        fs.add(feature);
    }

    void importFeatures(FeatureList featureList) {
    }

    public List<Feature> getFeatures(String featureName) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        this.collectFeatures(list, featureName);
        return list;
    }

    public Feature getFeature(String featureName) {
        List<Feature> features = this.getFeatures(featureName);
        if (features.isEmpty()) {
            return null;
        }
        return features.get(0);
    }

    private void collectFeatures(List<Feature> result, String featureName) {
        List<Feature> list;
        if (this.features != null && (list = this.features.get(featureName)) != null) {
            result.addAll(list);
        }
        if (this.lists != null) {
            for (Map.Entry<String, FeatureList> entry : this.lists.entrySet()) {
                FeatureList fList = entry.getValue();
                if (fList == null) continue;
                fList.collectFeatures(result, featureName);
            }
        }
    }

    public List<Feature> getFeatures(String featureName, String id) {
        if (this.lists == null) {
            return Collections.emptyList();
        }
        FeatureList list = this.lists.get(id);
        if (list == null) {
            return Collections.emptyList();
        }
        if (list.features == null) {
            return Collections.emptyList();
        }
        List<Feature> result = list.features.get(featureName);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    public Feature getFeature(String featureName, String id) {
        List<Feature> features = this.getFeatures(featureName, id);
        if (features.isEmpty()) {
            return null;
        }
        return features.get(0);
    }

    public List<Feature> getFeatures(String featureName, ASTPath path) {
        ArrayList<Feature> result = null;
        FeatureList list = this;
        for (int i = path.size() - 1; i > 0; --i) {
            List<Feature> l;
            String name;
            ASTItem item = path.get(i);
            String string = name = item instanceof ASTNode ? ((ASTNode)item).getNT() : ((ASTToken)item).getTypeName();
            if (list.lists == null || (list = list.lists.get(name)) == null) break;
            if (list.features == null || (l = list.features.get(featureName)) == null) continue;
            if (result == null) {
                result = new ArrayList<Feature>(l);
                continue;
            }
            result.addAll(l);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public Feature getFeature(String featureName, ASTPath path) {
        List<Feature> features = this.getFeatures(featureName, path);
        if (features.isEmpty()) {
            return null;
        }
        return features.get(0);
    }

    void evaluate(ParserManager.State state, List<ASTItem> path, Map<String, Set<ASTEvaluator>> evaluatorsMap) {
        FeatureList list = this;
        for (int i = path.size() - 1; i > 0; --i) {
            String name;
            ASTItem item = path.get(i);
            String string = name = item instanceof ASTNode ? ((ASTNode)item).getNT() : ((ASTToken)item).getTypeName();
            if (list.lists == null) {
                return;
            }
            list = list.lists.get(name);
            if (list == null) {
                return;
            }
            if (list.features == null) continue;
            for (String featureName : evaluatorsMap.keySet()) {
                if (featureName == null) {
                    Set<ASTEvaluator> evaluators = evaluatorsMap.get(null);
                    for (ASTEvaluator evaluator : evaluators) {
                        Collection<List<Feature>> featureListsC = list.features.values();
                        for (List<Feature> featureList : featureListsC) {
                            Iterator<Feature> it4 = featureList.iterator();
                            while (it4.hasNext()) {
                                evaluator.evaluate(state, path, it4.next());
                            }
                        }
                    }
                    continue;
                }
                List<Feature> features = list.features.get(featureName);
                if (features == null) continue;
                Set<ASTEvaluator> evaluators = evaluatorsMap.get(featureName);
                for (Feature feature : features) {
                    for (ASTEvaluator evaluator : evaluators) {
                        evaluator.evaluate(state, path, feature);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, "");
        return sb.toString();
    }

    private void toString(StringBuilder sb, String selector) {
        sb.append("Selector: ").append(selector).append("\n");
        if (this.features != null) {
            for (String featureName : this.features.keySet()) {
                for (Feature feature : this.features.get(featureName)) {
                    sb.append("  ").append(featureName).append(": ").append(feature).append("\n");
                }
            }
        }
        if (this.lists != null) {
            for (String s : this.lists.keySet()) {
                this.lists.get(s).toString(sb, selector + "." + s);
            }
        }
    }
}

