/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.javadoc;

import com.sun.source.tree.Scope;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.ReferencesCount;
import org.netbeans.api.lsp.Completion;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.modules.editor.java.JavaCompletionCollector;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.base.javadoc.JavadocCompletionUtils;
import org.netbeans.modules.java.editor.javadoc.JavadocCompletionTask;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.lsp.CompletionCollector;
import org.openide.util.Exceptions;

public class JavadocCompletionCollector
implements CompletionCollector {
    public boolean collectCompletions(Document doc, final int offset, final Completion.Context context, final Consumer<Completion> consumer) {
        final AtomicBoolean ret = new AtomicBoolean(true);
        if ((context == null || context.getTriggerKind() != Completion.TriggerKind.TriggerCharacter || context.getTriggerCharacter().charValue() == '#' || context.getTriggerCharacter().charValue() == '@') && JavadocCompletionUtils.isJavadocContext((Document)doc, (int)offset)) {
            try {
                ParserManager.parse(Collections.singletonList(Source.create((Document)doc)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        CompilationController controller = CompilationController.get((Parser.Result)resultIterator.getParserResult(offset));
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        JavadocCompletionTask<Completion> task = JavadocCompletionTask.create(offset, new ItemFactoryImpl((CompilationInfo)controller, offset), context != null && context.getTriggerKind() == Completion.TriggerKind.TriggerForIncompleteCompletions, () -> false);
                        task.run(resultIterator);
                        List<Completion> results = task.getResults();
                        if (results != null) {
                            Iterator<Completion> it = results.iterator();
                            while (it.hasNext()) {
                                Completion item = it.next();
                                if (item != null) continue;
                                it.remove();
                            }
                            results.forEach(consumer);
                        }
                        if (task.hasAdditionalItems()) {
                            ret.set(false);
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return ret.get();
    }

    private static class ItemFactoryImpl
    implements JavadocCompletionTask.ItemFactory<Completion> {
        private final CompilationInfo info;
        private final Document doc;
        private final int offset;
        private final Scope scope;

        public ItemFactoryImpl(CompilationInfo info, int offset) throws IOException {
            this.info = info;
            this.doc = info.getDocument();
            this.offset = offset;
            this.scope = this.getScope();
        }

        @Override
        public Completion createTagItem(String name, int startOffset) {
            CompletionCollector.Builder builder = CompletionCollector.newBuilder((String)name).kind(Completion.Kind.Keyword).sortText(String.format("%04d%s", 1500, name)).insertTextFormat(Completion.TextFormat.PlainText);
            if (startOffset < this.offset) {
                builder.textEdit(new TextEdit(startOffset, this.offset, name + " "));
            } else {
                builder.insertText(name + " ");
            }
            return builder.build();
        }

        @Override
        public Completion createNameItem(String name, int startOffset) {
            return CompletionCollector.newBuilder((String)name).kind(name.charAt(0) == '<' ? Completion.Kind.TypeParameter : Completion.Kind.Variable).insertText(name + " ").sortText(String.format("%04d%s", 1100, name)).insertTextFormat(Completion.TextFormat.PlainText).build();
        }

        @Override
        public Completion createJavadocExecutableItem(CompilationInfo info, ExecutableElement elem, ExecutableType type, int startOffset, boolean isInherited, boolean isDeprecated) {
            ElementHandle handle;
            TypeMirror tm;
            String simpleName = (elem.getKind() == ElementKind.METHOD ? elem : elem.getEnclosingElement()).getSimpleName().toString();
            Iterator<? extends VariableElement> it = elem.getParameters().iterator();
            Iterator<? extends TypeMirror> tIt = type.getParameterTypes().iterator();
            StringBuilder label = new StringBuilder();
            StringBuilder insertText = new StringBuilder();
            StringBuilder sortParams = new StringBuilder();
            label.append(simpleName).append('(');
            insertText.append(simpleName).append('(');
            sortParams.append('(');
            int cnt = 0;
            while (it.hasNext() && tIt.hasNext() && (tm = tIt.next()) != null) {
                ++cnt;
                String paramTypeName = Utilities.getTypeName(info, tm, false, elem.isVarArgs() && !tIt.hasNext()).toString();
                String paramName = it.next().getSimpleName().toString();
                label.append(paramTypeName).append(' ').append(paramName);
                sortParams.append(paramTypeName);
                insertText.append(paramTypeName);
                if (!tIt.hasNext()) continue;
                label.append(", ");
                sortParams.append(',');
                insertText.append(", ");
            }
            sortParams.append(')');
            label.append(')');
            insertText.append(')');
            TypeMirror retType = type.getReturnType();
            if (elem.getKind() == ElementKind.METHOD) {
                label.append(" : ").append(Utilities.getTypeName(info, retType, false).toString());
            }
            int priority = elem.getKind() == ElementKind.METHOD ? 1500 : 1650;
            CompletionCollector.Builder builder = CompletionCollector.newBuilder((String)label.toString()).kind(JavaCompletionCollector.elementKind2CompletionItemKind(elem.getKind())).insertTextFormat(Completion.TextFormat.PlainText).sortText(String.format("%04d%s#%02d%s", priority, simpleName, cnt, sortParams.toString())).insertText(insertText.toString());
            ElementHandle elementHandle = handle = JavaCompletionCollector.SUPPORTED_ELEMENT_KINDS.contains(elem.getKind().name()) ? ElementHandle.create((Element)elem) : null;
            if (handle != null) {
                builder.documentation(JavaCompletionCollector.getDocumentation(this.doc, this.offset, handle));
            }
            if (isDeprecated) {
                builder.addTag(Completion.Tag.Deprecated);
            }
            return builder.build();
        }

        @Override
        public Completion createJavadocTypeItem(CompilationInfo info, TypeElement elem, int startOffset, boolean isDeprecated) {
            ElementHandle handle = JavaCompletionCollector.SUPPORTED_ELEMENT_KINDS.contains(elem.getKind().name()) ? ElementHandle.create((Element)elem) : null;
            return this.createTypeItem((ElementHandle<TypeElement>)handle, elem, (DeclaredType)elem.asType(), '#', null, isDeprecated, false);
        }

        @Override
        public Completion createJavaTypeItem(CompilationInfo info, TypeElement elem, DeclaredType type, int startOffset, ReferencesCount referencesCount, boolean isDeprecated, boolean smartType) {
            ElementHandle handle = JavaCompletionCollector.SUPPORTED_ELEMENT_KINDS.contains(elem.getKind().name()) ? ElementHandle.create((Element)elem) : null;
            return this.createTypeItem((ElementHandle<TypeElement>)handle, elem, type, '\uffff', referencesCount, isDeprecated, false);
        }

        @Override
        public Completion createLazyTypeItem(ElementHandle<TypeElement> handle, EnumSet<ElementKind> kinds, int startOffset, ReferencesCount referencesCount, Source source) {
            TypeElement te = (TypeElement)handle.resolve(this.info);
            if (te != null && (this.scope == null || this.info.getTrees().isAccessible(this.scope, te)) && JavaCompletionCollector.isOfKind(te, kinds) && (!JavaCompletionCollector.isInDefaultPackage(te) || JavaCompletionCollector.isInDefaultPackage(this.scope.getEnclosingClass()))) {
                return this.createTypeItem(handle, te, (DeclaredType)te.asType(), '\uffff', referencesCount, this.info.getElements().isDeprecated(te), false);
            }
            return null;
        }

        @Override
        public Completion createJavaVariableItem(CompilationInfo info, VariableElement elem, TypeMirror type, int startOffset, boolean isInherited, boolean isDeprecated) {
            ElementHandle handle;
            int priority = elem.getKind() == ElementKind.ENUM_CONSTANT || elem.getKind() == ElementKind.FIELD ? 1300 : 1200;
            StringBuilder label = new StringBuilder();
            label.append(elem.getSimpleName());
            if (type != null) {
                label.append(" : ").append(Utilities.getTypeName(info, type, false));
            }
            CompletionCollector.Builder builder = CompletionCollector.newBuilder((String)label.toString()).kind(JavaCompletionCollector.elementKind2CompletionItemKind(elem.getKind())).sortText(String.format("%04d%s", priority, elem.getSimpleName().toString())).insertTextFormat(Completion.TextFormat.PlainText).insertText(elem.getSimpleName().toString());
            if (type != null && !type.getKind().isPrimitive()) {
                builder.addCommitCharacter('.');
            }
            ElementHandle elementHandle = handle = JavaCompletionCollector.SUPPORTED_ELEMENT_KINDS.contains(elem.getKind().name()) ? ElementHandle.create((Element)elem) : null;
            if (handle != null) {
                builder.documentation(JavaCompletionCollector.getDocumentation(this.doc, this.offset, handle));
            }
            if (isDeprecated) {
                builder.addTag(Completion.Tag.Deprecated);
            }
            return builder.build();
        }

        @Override
        public Completion createPackageItem(String pkgFQN, int startOffset) {
            String simpleName = pkgFQN.substring(pkgFQN.lastIndexOf(46) + 1);
            return CompletionCollector.newBuilder((String)simpleName).kind(Completion.Kind.Folder).sortText(String.format("%04d%s#%s", 1900, simpleName, pkgFQN)).insertText(simpleName + ".").insertTextFormat(Completion.TextFormat.PlainText).build();
        }

        private Completion createTypeItem(ElementHandle<TypeElement> handle, TypeElement elem, DeclaredType type, char commitChar, ReferencesCount referencesCount, boolean isDeprecated, boolean smartType) {
            String name = elem.getQualifiedName().toString();
            int idx = name.lastIndexOf(46);
            String pkgName = idx < 0 ? "" : name.substring(0, idx);
            StringBuilder label = new StringBuilder();
            StringBuilder insertText = new StringBuilder();
            label.append(elem.getSimpleName());
            if (pkgName.length() > 0) {
                label.append(" (").append(pkgName).append(')');
            }
            if (referencesCount == null) {
                insertText.append(elem.getSimpleName());
            } else if ((type == null || type.getKind() != TypeKind.ERROR) && EnumSet.range(ElementKind.PACKAGE, ElementKind.INTERFACE).contains((Object)elem.getEnclosingElement().getKind())) {
                insertText.append(elem.getSimpleName());
            } else {
                insertText.append(elem.getQualifiedName());
            }
            CompletionCollector.Builder builder = CompletionCollector.newBuilder((String)label.toString()).kind(JavaCompletionCollector.elementKind2CompletionItemKind(elem.getKind())).sortText(String.format("%04d%s#%02d#%s", smartType ? 800 : 1800, elem.getSimpleName().toString(), Utilities.getImportanceLevel(name), pkgName)).insertText(insertText.toString()).insertTextFormat(Completion.TextFormat.PlainText);
            if (commitChar != '\uffffffff') {
                builder.addCommitCharacter('#');
            }
            if (handle != null) {
                builder.documentation(JavaCompletionCollector.getDocumentation(this.doc, this.offset, handle));
                builder.additionalTextEdits(JavaCompletionCollector.addImport(this.doc, this.offset, handle));
            }
            if (isDeprecated) {
                builder.addTag(Completion.Tag.Deprecated);
            }
            return builder.build();
        }

        private Scope getScope() {
            try {
                return this.info.getTrees().getScope(this.info.getTreeUtilities().pathFor(this.offset));
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

