/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.Bundle;
import org.netbeans.modules.apisupport.project.ui.customizer.CustomizerComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.EditDependencyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.JavaPlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.java.api.common.project.ui.customizer.ClassPathListCellRenderer;
import org.netbeans.modules.java.api.common.project.ui.customizer.EditMediator;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

public final class CustomizerLibraries
extends NbPropertyPanel.Single {
    private EditMediator.ListComponent emListComp;
    private Map<File, Boolean> isJarExportedMap = Collections.synchronizedMap(new HashMap());
    private ProjectXMLManager pxml;
    private static final Pattern checkWrappedJarPat = Pattern.compile("^(.*)release[\\\\/]modules[\\\\/]ext[\\\\/]([^\\\\/]+)$");
    private JButton addDepButton;
    private JButton addJarButton;
    private JButton addLibrary;
    private JButton addTokenButton;
    private JList dependencyList;
    private JScrollPane dependencySP;
    private JButton editButton;
    private JButton editDepButton;
    private JButton exportButton;
    private JLabel jLabel1;
    private JPanel jPanelJars;
    private JPanel jPanelModules;
    private JPanel jPanelTokens;
    private JTabbedPane jTabbedPane1;
    private JButton javaPlatformButton;
    private JComboBox javaPlatformCombo;
    private JLabel javaPlatformLabel;
    private JButton managePlafsButton;
    private JLabel moduleDepsLabel;
    private JLabel platform;
    private JComboBox platformValue;
    private JPanel platformsPanel;
    private JButton removeButton;
    private JButton removeDepButton;
    private JButton removeTokenButton;
    private JList reqTokenList;
    private JScrollPane reqTokenSP;
    private JLabel requiredTokensLabel;
    private JList wrappedJarsList;
    private JScrollPane wrappedJarsSP;
    private static final RequestProcessor RP = new RequestProcessor(CustomizerLibraries.class.getName(), 1);
    private RequestProcessor.Task updateMapTask;
    private final AtomicReference<Set<String>> selectedPackages = new AtomicReference();
    private final AtomicReference<File[]> wrappedJars = new AtomicReference();

    public CustomizerLibraries(SingleModuleProperties props, ProjectCustomizer.Category category, @NonNull NbModuleProject p) {
        super(props, CustomizerLibraries.class, category);
        this.initComponents();
        if (!this.getProperties().isSuiteComponent()) {
            this.addLibrary.setVisible(false);
            Mnemonics.setLocalizedText((AbstractButton)this.addDepButton, (String)Bundle.CTL_AddSimple());
        }
        this.refresh();
        this.dependencyList.setCellRenderer(CustomizerComponentFactory.getDependencyCellRenderer(false));
        this.javaPlatformCombo.setRenderer(JavaPlatformComponentFactory.javaPlatformListCellRenderer());
        this.removeTokenButton.setEnabled(false);
        this.wrappedJarsList.setCellRenderer(ClassPathListCellRenderer.createClassPathListRenderer((PropertyEvaluator)this.getProperties().getEvaluator(), (FileObject)FileUtil.toFileObject((File)this.getProperties().getProjectDirectoryFile())));
        DefaultButtonModel dummy = new DefaultButtonModel();
        EditMediator.register((Project)p, (AntProjectHelper)this.getProperties().getHelper(), (ReferenceHelper)this.getProperties().getRefHelper(), (EditMediator.ListComponent)this.emListComp, (ButtonModel)dummy, (ButtonModel)dummy, (ButtonModel)dummy, (ButtonModel)this.removeButton.getModel(), (ButtonModel)dummy, (ButtonModel)dummy, (ButtonModel)this.editButton.getModel(), null, null);
        this.attachListeners();
        this.pxml = new ProjectXMLManager(p);
    }

    @Override
    protected void refresh() {
        this.refreshJavaPlatforms();
        this.refreshPlatforms();
        this.platformValue.setEnabled(this.getProperties().isStandalone());
        this.managePlafsButton.setEnabled(this.getProperties().isStandalone());
        this.reqTokenList.setModel(this.getProperties().getRequiredTokenListModel());
        DefaultListModel model = this.getProperties().getWrappedJarsListModel();
        this.wrappedJarsList.setModel(model);
        this.emListComp = EditMediator.createListComponent((JList)this.wrappedJarsList);
        this.updateJarExportedMap();
        this.runDependenciesListModelRefresh();
        this.dependencyList.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                CustomizerLibraries.this.updateEnabled();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                CustomizerLibraries.this.updateEnabled();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                CustomizerLibraries.this.updateEnabled();
            }
        });
    }

    private void attachListeners() {
        this.platformValue.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CustomizerLibraries.this.getProperties().setActivePlatform((NbPlatform)CustomizerLibraries.this.platformValue.getSelectedItem());
                    CustomizerLibraries.this.runDependenciesListModelRefresh();
                }
            }
        });
        this.dependencyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CustomizerLibraries.this.updateEnabled();
                }
            }
        });
        this.javaPlatformCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CustomizerLibraries.this.getProperties().setActiveJavaPlatform((JavaPlatform)CustomizerLibraries.this.javaPlatformCombo.getSelectedItem());
                }
            }
        });
        this.reqTokenList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CustomizerLibraries.this.removeTokenButton.setEnabled(CustomizerLibraries.this.reqTokenList.getSelectedIndex() != -1);
                }
            }
        });
        this.getProperties().getPublicPackagesModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0 && e.getColumn() == 0) {
                    CustomizerLibraries.this.updateJarExportedMap();
                }
            }
        });
    }

    private void runDependenciesListModelRefresh() {
        this.dependencyList.setModel(this.getProperties().getDependenciesListModelInBg(new Runnable(){

            @Override
            public void run() {
                CustomizerLibraries.this.updateEnabled();
            }
        }));
        this.updateEnabled();
    }

    private void refreshJavaPlatforms() {
        this.javaPlatformCombo.setModel(JavaPlatformComponentFactory.javaPlatformListModel());
        this.javaPlatformCombo.setSelectedItem(this.getProperties().getActiveJavaPlatform());
    }

    private void refreshPlatforms() {
        this.platformValue.setModel(new PlatformComponentFactory.NbPlatformListModel(this.getProperties().getActivePlatform()));
        this.platformValue.requestFocusInWindow();
    }

    private void updateEnabled() {
        Boolean value;
        int i;
        ClassPathSupport.Item item;
        boolean okEnabled = !UIUtil.isWaitModel(this.dependencyList.getModel());
        boolean enabled = this.dependencyList.getModel().getSize() > 0 && okEnabled && this.getProperties().isActivePlatformValid() && this.dependencyList.getSelectedIndex() != -1;
        this.editDepButton.setEnabled(enabled);
        this.removeDepButton.setEnabled(enabled);
        this.addDepButton.setEnabled(okEnabled && this.getProperties().isActivePlatformValid());
        boolean javaEnabled = this.getProperties().isNetBeansOrg() || this.getProperties().isStandalone() && ((NbPlatform)this.platformValue.getSelectedItem()).getHarnessVersion().compareTo(HarnessVersion.V50u1) >= 0;
        this.javaPlatformCombo.setEnabled(javaEnabled);
        this.javaPlatformButton.setEnabled(javaEnabled);
        int[] selectedIndices = this.emListComp.getSelectedIndices();
        DefaultListModel listModel = this.getProperties().getWrappedJarsListModel();
        boolean exportEnabled = false;
        int[] nArray = selectedIndices;
        int n = nArray.length;
        for (int j = 0; !(j >= n || (item = (ClassPathSupport.Item)listModel.getElementAt(i = nArray[j])).getType() == 0 && (exportEnabled |= (value = this.isJarExportedMap.get(item.getResolvedFile())) == null || value == false)); ++j) {
        }
        this.exportButton.setEnabled(exportEnabled);
    }

    private CustomizerComponentFactory.DependencyListModel getDepListModel() {
        return (CustomizerComponentFactory.DependencyListModel)this.dependencyList.getModel();
    }

    private void initComponents() {
        this.platformsPanel = new JPanel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.platform = new JLabel();
        this.managePlafsButton = new JButton();
        this.javaPlatformLabel = new JLabel();
        this.javaPlatformCombo = new JComboBox();
        this.javaPlatformButton = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelModules = new JPanel();
        this.dependencySP = new JScrollPane();
        this.dependencyList = new JList();
        this.addDepButton = new JButton();
        this.addLibrary = new JButton();
        this.removeDepButton = new JButton();
        this.moduleDepsLabel = new JLabel();
        this.editDepButton = new JButton();
        this.jPanelTokens = new JPanel();
        this.reqTokenSP = new JScrollPane();
        this.reqTokenList = new JList();
        this.requiredTokensLabel = new JLabel();
        this.addTokenButton = new JButton();
        this.removeTokenButton = new JButton();
        this.jPanelJars = new JPanel();
        this.jLabel1 = new JLabel();
        this.wrappedJarsSP = new JScrollPane();
        this.wrappedJarsList = new JList();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.addJarButton = new JButton();
        this.exportButton = new JButton();
        this.setLayout(new BorderLayout());
        this.platformsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 12);
        this.platformsPanel.add((Component)this.platformValue, gridBagConstraints);
        this.platformValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_PlatformValue"));
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 12, 12);
        this.platformsPanel.add((Component)this.platform, gridBagConstraints);
        this.platform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_PlatformLbl"));
        Mnemonics.setLocalizedText((AbstractButton)this.managePlafsButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_ManagePlatform"));
        this.managePlafsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.managePlatforms(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.platformsPanel.add((Component)this.managePlafsButton, gridBagConstraints);
        this.managePlafsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_ManagePlafsButton"));
        this.javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_Java_Platform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformLabel, gridBagConstraints);
        this.javaPlatformLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_JavaPlatformLbl"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.platformsPanel.add((Component)this.javaPlatformCombo, gridBagConstraints);
        this.javaPlatformCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_JavaPlatformCombo"));
        Mnemonics.setLocalizedText((AbstractButton)this.javaPlatformButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_Manage_Java_Platforms"));
        this.javaPlatformButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.javaPlatformButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.platformsPanel.add((Component)this.javaPlatformButton, gridBagConstraints);
        this.javaPlatformButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_JavaPlatformButton"));
        this.add((Component)this.platformsPanel, "First");
        this.jPanelModules.setLayout(new GridBagLayout());
        this.dependencySP.setViewportView(this.dependencyList);
        this.dependencyList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_DependencyList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 5, 12);
        this.jPanelModules.add((Component)this.dependencySP, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addDepButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_AddDependency"));
        this.addDepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.addModuleDependency(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 4, 9);
        this.jPanelModules.add((Component)this.addDepButton, gridBagConstraints);
        this.addDepButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_AddDepButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.addLibrary, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_AddNewLibrary"));
        this.addLibrary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.addLibraryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 4, 9);
        this.jPanelModules.add((Component)this.addLibrary, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeDepButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_RemoveButton"));
        this.removeDepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.removeModuleDependency(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 4, 9);
        this.jPanelModules.add((Component)this.removeDepButton, gridBagConstraints);
        this.removeDepButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_RemoveDepButton"));
        this.moduleDepsLabel.setLabelFor(this.dependencySP);
        Mnemonics.setLocalizedText((JLabel)this.moduleDepsLabel, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_ModuleDependencies"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.jPanelModules.add((Component)this.moduleDepsLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editDepButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_EditButton"));
        this.editDepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.editModuleDependency(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 4, 9);
        this.jPanelModules.add((Component)this.editDepButton, gridBagConstraints);
        this.editDepButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_EditDepButton"));
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_ModulesPanel"), this.jPanelModules);
        this.jPanelTokens.setLayout(new GridBagLayout());
        this.reqTokenSP.setViewportView(this.reqTokenList);
        this.reqTokenList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_ReqTokenList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 5, 12);
        this.jPanelTokens.add((Component)this.reqTokenSP, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.requiredTokensLabel, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_RequiredTokens"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.jPanelTokens.add((Component)this.requiredTokensLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addTokenButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_AddButton"));
        this.addTokenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.addToken(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 4, 9);
        this.jPanelTokens.add((Component)this.addTokenButton, gridBagConstraints);
        this.addTokenButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_AddTokenButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeTokenButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_RemoveButton"));
        this.removeTokenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.removeToken(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(5, 0, 4, 9);
        this.jPanelTokens.add((Component)this.removeTokenButton, gridBagConstraints);
        this.removeTokenButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerLibraries.class, (String)"ACSD_RemoveTokenButton"));
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_TokensPanel"), this.jPanelTokens);
        this.jPanelJars.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_WrappedJars"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.jPanelJars.add((Component)this.jLabel1, gridBagConstraints);
        this.wrappedJarsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                CustomizerLibraries.this.wrappedJarsListValueChanged(evt);
            }
        });
        this.wrappedJarsSP.setViewportView(this.wrappedJarsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 5, 12);
        this.jPanelJars.add((Component)this.wrappedJarsSP, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_EditButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 4, 9);
        this.jPanelJars.add((Component)this.editButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_RemoveButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 4, 9);
        this.jPanelJars.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addJarButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_AddJarButton"));
        this.addJarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.addJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 4, 9);
        this.jPanelJars.add((Component)this.addJarButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.exportButton, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"CTL_ExportButton"));
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerLibraries.this.exportButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 4, 9);
        this.jPanelJars.add((Component)this.exportButton, gridBagConstraints);
        this.jTabbedPane1.addTab(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_JarsPanel"), this.jPanelJars);
        this.add((Component)this.jTabbedPane1, "Center");
    }

    private void addLibraryActionPerformed(ActionEvent evt) {
        block4: {
            NbModuleProject project;
            Project p = this.getProperties().getProject();
            NbModuleProject nbModuleProject = project = p != null ? ApisupportAntUIUtils.runLibraryWrapperWizard(p) : null;
            if (project != null) {
                try {
                    this.getProperties().resetUniverseDependencies();
                    ModuleDependency dep = new ModuleDependency(this.getProperties().getModuleList().getEntry(project.getCodeNameBase()));
                    String warn = this.pxml.getDependencyCycleWarning(Collections.singleton(dep));
                    if (warn != null) {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)warn, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        return;
                    }
                    this.getDepListModel().addDependency(dep);
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError((Object)e);
                }
            }
        }
    }

    private void javaPlatformButtonActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.javaPlatformCombo.getSelectedItem()));
        this.refreshJavaPlatforms();
    }

    private void removeToken(ActionEvent evt) {
        CustomizerComponentFactory.RequiredTokenListModel model = (CustomizerComponentFactory.RequiredTokenListModel)this.reqTokenList.getModel();
        Object[] selected = this.reqTokenList.getSelectedValues();
        for (int i = 0; i < selected.length; ++i) {
            model.removeToken((String)selected[i]);
        }
        if (model.getSize() > 0) {
            this.reqTokenList.setSelectedIndex(0);
        }
        this.reqTokenList.requestFocusInWindow();
    }

    private void addToken(ActionEvent evt) {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        panel.setLayout(new BorderLayout(0, 2));
        JList<String> tokenList = new JList<String>(this.getProperties().getAllTokens());
        JScrollPane tokenListSP = new JScrollPane(tokenList);
        JLabel provTokensTxt = new JLabel();
        provTokensTxt.setLabelFor(tokenList);
        Mnemonics.setLocalizedText((JLabel)provTokensTxt, (String)Bundle.LBL_ProvidedTokens_T());
        panel.getAccessibleContext().setAccessibleDescription(Bundle.ACS_ProvidedTokensTitle());
        tokenList.getAccessibleContext().setAccessibleDescription(Bundle.ACS_LBL_ProvidedTokens());
        tokenListSP.getVerticalScrollBar().getAccessibleContext().setAccessibleName(Bundle.ACS_CTL_ProvidedTokensVerticalScroll());
        tokenListSP.getVerticalScrollBar().getAccessibleContext().setAccessibleDescription(Bundle.ACSD_CTL_ProvidedTokensVerticalScroll());
        tokenListSP.getHorizontalScrollBar().getAccessibleContext().setAccessibleName(Bundle.ACS_CTL_ProvidedTokensHorizontalScroll());
        tokenListSP.getHorizontalScrollBar().getAccessibleContext().setAccessibleDescription(Bundle.ACSD_CTL_ProvidedTokensHorizontalScroll());
        panel.add((Component)provTokensTxt, "North");
        panel.add((Component)tokenListSP, "Center");
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.LBL_ProvidedTokens_NoMnem());
        Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        d.setVisible(true);
        d.dispose();
        if (descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            Object[] selected = tokenList.getSelectedValues();
            CustomizerComponentFactory.RequiredTokenListModel model = (CustomizerComponentFactory.RequiredTokenListModel)this.reqTokenList.getModel();
            for (int i = 0; i < selected.length; ++i) {
                model.addToken((String)selected[i]);
            }
            if (selected.length > 0) {
                this.reqTokenList.clearSelection();
                this.reqTokenList.setSelectedValue(selected[0], true);
            }
        }
        this.reqTokenList.requestFocusInWindow();
    }

    private void managePlatforms(ActionEvent evt) {
        Object returnedPlaf = NbPlatformCustomizer.showCustomizer();
        this.refreshPlatforms();
        this.platformValue.setSelectedItem(returnedPlaf);
    }

    private void editModuleDependency(ActionEvent evt) {
        ModuleDependency origDep = this.getDepListModel().getDependency(this.dependencyList.getSelectedIndex());
        EditDependencyPanel editPanel = new EditDependencyPanel(origDep, this.getProperties().getActivePlatform());
        DialogDescriptor descriptor = new DialogDescriptor((Object)editPanel, Bundle.CTL_EditModuleDependencyTitle());
        descriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.apisupport.project.ui.customizer.EditDependencyPanel"));
        Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
        d.setVisible(true);
        if (descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            this.getDepListModel().editDependency(origDep, editPanel.getEditedDependency());
        }
        d.dispose();
        this.dependencyList.requestFocusInWindow();
    }

    private void removeModuleDependency(ActionEvent evt) {
        List deps = NbCollections.checkedListByCopy(Arrays.asList(this.dependencyList.getSelectedValues()), ModuleDependency.class, (boolean)false);
        if (deps.size() > 0) {
            this.getDepListModel().removeDependencies(deps);
            if (this.dependencyList.getModel().getSize() > 0) {
                this.dependencyList.setSelectedIndex(0);
            }
        }
        this.dependencyList.requestFocusInWindow();
    }

    private void addModuleDependency(ActionEvent evt) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                ModuleDependency[] newDeps = AddModulePanel.selectDependencies(CustomizerLibraries.this.getProperties());
                ModuleDependency dep = null;
                for (int i = 0; i < newDeps.length; ++i) {
                    String warn;
                    dep = newDeps[i];
                    if ("0".equals(dep.getReleaseVersion()) && !dep.hasImplementationDependency()) {
                        dep = new ModuleDependency(dep.getModuleEntry(), "0-1", dep.getSpecificationVersion(), dep.hasCompileDependency(), dep.hasImplementationDependency());
                    }
                    if ((warn = CustomizerLibraries.this.pxml.getDependencyCycleWarning(Collections.singleton(dep))) != null) {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)warn, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        break;
                    }
                    CustomizerLibraries.this.getDepListModel().addDependency(dep);
                }
                if (dep != null) {
                    final ModuleDependency fDep = dep;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CustomizerLibraries.this.dependencyList.setSelectedValue(fDep, true);
                            CustomizerLibraries.this.dependencyList.requestFocusInWindow();
                        }
                    });
                }
            }
        });
    }

    private void addJarButtonActionPerformed(ActionEvent evt) {
        AntProjectHelper helper = this.getProperties().getHelper();
        Project project = this.getProperties().getProject();
        if (project == null) {
            return;
        }
        FileChooser chooser = new FileChooser(helper, true);
        chooser.setFileHidingEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(Bundle.LBL_AddJar_DialogTitle());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(EditMediator.JAR_ZIP_FILTER);
        File curDir = EditMediator.getLastUsedClassPathFolder();
        chooser.setCurrentDirectory(curDir);
        chooser.getAccessibleContext().setAccessibleDescription(Bundle.LBL_AddJar_DialogTitle());
        int option = chooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(this.emListComp.getComponent()));
        if (option == 0) {
            String[] filePaths;
            try {
                filePaths = chooser.getSelectedPaths();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            File base = FileUtil.toFile((FileObject)helper.getProjectDirectory());
            ArrayList<String> newPaths = new ArrayList<String>();
            for (String path : filePaths) {
                block12: {
                    File fl = PropertyUtils.resolveFile((File)base, (String)path);
                    FileObject fo = FileUtil.toFileObject((File)fl);
                    if (fo == null) continue;
                    if (FileUtil.isArchiveFile((FileObject)fo)) {
                        try {
                            new JarFile(fl).close();
                        }
                        catch (IOException ex) {
                            JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(this.emListComp.getComponent()), Bundle.LBL_Corrupted_JAR(fl), Bundle.LBL_Corrupted_JAR_title(), 2);
                            continue;
                        }
                    }
                    Matcher m = checkWrappedJarPat.matcher(fl.getAbsolutePath());
                    File prjDir = this.getProperties().getProjectDirectoryFile();
                    if (!m.matches() || !new File(m.group(1)).equals(prjDir)) {
                        try {
                            String[] entry = ApisupportAntUtils.copyClassPathExtensionJar(prjDir, fl);
                            if (entry == null) break block12;
                            path = entry[1];
                        }
                        catch (IOException ex) {
                            Logger.getLogger(CustomizerLibraries.class.getName()).log(Level.INFO, "could not copy " + fl + " to " + prjDir, ex);
                            continue;
                        }
                    }
                }
                newPaths.add(path);
            }
            filePaths = newPaths.toArray(new String[0]);
            DefaultListModel model = this.getProperties().getWrappedJarsListModel();
            int[] newSelection = ClassPathUiSupport.addJarFiles((DefaultListModel)model, (int[])this.emListComp.getSelectedIndices(), (String[])filePaths, (File)base, (String[])chooser.getSelectedPathVariables(), null);
            this.emListComp.setSelectedIndices(newSelection);
            for (int i : newSelection) {
                this.isJarExportedMap.put(((ClassPathSupport.Item)model.getElementAt(i)).getResolvedFile(), Boolean.FALSE);
            }
            curDir = FileUtil.normalizeFile((File)chooser.getCurrentDirectory());
            EditMediator.setLastUsedClassPathFolder((File)curDir);
        }
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        int[] selectedIndices = this.emListComp.getSelectedIndices();
        ArrayList<File> jars = new ArrayList<File>();
        DefaultListModel listModel = this.getProperties().getWrappedJarsListModel();
        for (int i : selectedIndices) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)listModel.getElementAt(i);
            if (item.getType() != 0) continue;
            jars.add(item.getResolvedFile());
        }
        if (jars.size() > 0) {
            int dif = this.getProperties().exportPackagesFromJars(jars);
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.MSG_PublicPackagesAddedFmt(dif));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            for (File jar : jars) {
                this.isJarExportedMap.put(jar, Boolean.TRUE);
            }
        }
        this.exportButton.setEnabled(false);
    }

    private void wrappedJarsListValueChanged(ListSelectionEvent evt) {
        this.updateEnabled();
    }

    private void updateJarExportedMap() {
        this.selectedPackages.set(this.getProperties().getPublicPackagesModel().getSelectedPackages());
        Object[] items = this.getProperties().getWrappedJarsListModel().toArray();
        File[] jars = new File[items.length];
        for (int i = 0; i < items.length; ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)items[i];
            jars[i] = item.getResolvedFile();
        }
        this.wrappedJars.set(jars);
        if (this.updateMapTask == null) {
            this.updateMapTask = RP.create(new Runnable(){

                @Override
                public void run() {
                    for (File jar : CustomizerLibraries.this.wrappedJars.get()) {
                        HashSet<String> pkgs = new HashSet<String>();
                        ApisupportAntUtils.scanJarForPackageNames(pkgs, jar);
                        pkgs.removeAll((Collection)CustomizerLibraries.this.selectedPackages.get());
                        CustomizerLibraries.this.isJarExportedMap.put(jar, pkgs.isEmpty());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CustomizerLibraries.this.updateEnabled();
                        }
                    });
                }
            });
        }
        this.updateMapTask.schedule(0);
    }
}

