/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.tregex.nodes.input.InputRegionMatchesNodeGen;
import com.oracle.truffle.regex.tregex.string.Encodings;

@GenerateInline
public abstract class InputRegionMatchesNode
extends Node {
    public abstract boolean execute(Node var1, TruffleString var2, int var3, TruffleString var4, int var5, int var6, TruffleString.WithMask var7, Encodings.Encoding var8);

    @Specialization(guards={"mask == null"})
    public boolean doTString(TruffleString input, int fromIndex1, TruffleString match, int fromIndex2, int length, TruffleString.WithMask mask, Encodings.Encoding encoding, @Cached(inline=false) @Cached.Shared TruffleString.RegionEqualByteIndexNode regionEqualsNode) {
        int fromByteIndexA = fromIndex1 << encoding.getStride();
        int fromByteIndexB = fromIndex2 << encoding.getStride();
        int byteLength = length << encoding.getStride();
        return input.byteLength(encoding.getTStringEncoding()) >= fromByteIndexA + byteLength && regionEqualsNode.execute((AbstractTruffleString)input, fromByteIndexA, (AbstractTruffleString)match, fromByteIndexB, byteLength, encoding.getTStringEncoding());
    }

    @Fallback
    public boolean doTStringMask(TruffleString input, int fromIndex1, TruffleString match, int fromIndex2, int length, TruffleString.WithMask mask, Encodings.Encoding encoding, @Cached(inline=false) @Cached.Shared TruffleString.RegionEqualByteIndexNode regionEqualsNode) {
        int fromByteIndexA = fromIndex1 << encoding.getStride();
        int fromByteIndexB = fromIndex2 << encoding.getStride();
        int byteLength = length << encoding.getStride();
        return input.byteLength(encoding.getTStringEncoding()) >= fromByteIndexA + byteLength && regionEqualsNode.execute((AbstractTruffleString)input, fromByteIndexA, mask, fromByteIndexB, byteLength, encoding.getTStringEncoding());
    }

    @NeverDefault
    public static InputRegionMatchesNode create() {
        return InputRegionMatchesNodeGen.create();
    }
}

