/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.ImageIcon;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.refactoring.java.Bundle;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaWhereUsedFilters;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.java.ui.WhereUsedPanel;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.FiltersManager;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedElement
extends SimpleRefactoringElementImplementation
implements FiltersManager.Filterable {
    private final PositionBounds bounds;
    private final String htmlText;
    private final String elementText;
    private final FileObject parentFile;
    private final JavaWhereUsedFilters.ReadWrite access;
    private final boolean inComment;
    private final boolean inImport;
    private final boolean inPlatform;
    private final boolean inDependency;
    private final boolean inTestclass;

    public WhereUsedElement(PositionBounds bounds, String htmlText, String elementText, FileObject parentFile, TreePath tp, CompilationInfo info, JavaWhereUsedFilters.ReadWrite access, boolean inTestclass, boolean inPlatform, boolean inDependency, boolean inComment, boolean inImport) {
        this.bounds = bounds;
        this.htmlText = htmlText;
        this.elementText = elementText;
        this.parentFile = parentFile;
        if (tp != null) {
            ElementGripFactory.getDefault().put(parentFile, tp, info);
        }
        ElementGripFactory.getDefault().put(parentFile, inTestclass);
        this.access = access;
        this.inTestclass = inTestclass;
        this.inPlatform = inPlatform;
        this.inDependency = inDependency;
        this.inComment = inComment;
        this.inImport = inImport;
    }

    public String getDisplayText() {
        return this.htmlText;
    }

    public Lookup getLookup() {
        Object composite = null;
        if (this.bounds != null) {
            composite = ElementGripFactory.getDefault().get(this.parentFile, this.bounds.getBegin().getOffset());
        }
        if (composite == null) {
            composite = this.parentFile;
        }
        ImageIcon icon = null;
        if (this.access != null) {
            switch (this.access) {
                case WRITE: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_write.png", (boolean)false);
                    break;
                }
                case READ_WRITE: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_readwrite.png", (boolean)false);
                    break;
                }
                default: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_read.png", (boolean)false);
                    break;
                }
            }
        } else if (this.inComment) {
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_comment.png", (boolean)false);
        } else if (this.inImport) {
            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_import.png", (boolean)false);
        }
        return icon != null ? Lookups.fixed((Object[])new Object[]{composite, icon}) : Lookups.singleton((Object)composite);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.elementText;
    }

    public void performChange() {
    }

    public void openInEditor() {
        if (this.parentFile == null || !this.parentFile.isValid()) {
            StatusDisplayer.getDefault().setStatusText(Bundle.WARN_ElementNotFound());
        } else {
            super.openInEditor();
        }
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    public JavaWhereUsedFilters.ReadWrite getAccess() {
        return this.access;
    }

    public static WhereUsedElement create(CompilationInfo compiler, TreePath tree, boolean inTest) {
        return WhereUsedElement.create(compiler, tree, inTest, false, false);
    }

    public static WhereUsedElement create(CompilationInfo compiler, TreePath tree, boolean inTest, boolean inPlatform, boolean inDependency) {
        return WhereUsedElement.create(compiler, tree, null, inTest, inPlatform, inDependency, new AtomicBoolean());
    }

    public static WhereUsedElement create(CompilationInfo compiler, TreePath tree, boolean inTest, boolean inPlatform, boolean inDependency, AtomicBoolean inImport) {
        return WhereUsedElement.create(compiler, tree, null, inTest, inPlatform, inDependency, inImport);
    }

    public static WhereUsedElement create(CompilationInfo compiler, TreePath tree, JavaWhereUsedFilters.ReadWrite access, boolean inTest, boolean inPlatform, boolean inDependency, AtomicBoolean inImport) {
        int end;
        int start;
        TreePath enclosingTree;
        CompilationUnitTree unit = tree.getCompilationUnit();
        CharSequence content = compiler.getSnapshot().getText();
        SourcePositions sp = compiler.getTrees().getSourcePositions();
        Tree t = tree.getLeaf();
        boolean anonClassNameBug128074 = false;
        TreeUtilities treeUtils = compiler.getTreeUtilities();
        if (t.getKind() == Tree.Kind.IDENTIFIER && "super".contentEquals(((IdentifierTree)t).getName()) && treeUtils.isSynthetic(tree)) {
            if (treeUtils.isSynthetic(tree = WhereUsedElement.getEnclosingTree(tree))) {
                tree = WhereUsedElement.getEnclosingTree(tree.getParentPath());
            }
            t = tree.getLeaf();
        }
        boolean elementInImport = false;
        if ((t.getKind() == Tree.Kind.IDENTIFIER || t.getKind() == Tree.Kind.MEMBER_SELECT) && (enclosingTree = WhereUsedElement.getEnclosingImportTree(tree)) != null) {
            elementInImport = true;
            inImport.set(true);
        }
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)t.getKind())) {
            pos = treeUtils.findNameSpan((ClassTree)t);
            if (pos == null) {
                TreePath parentPath;
                Tree tr = tree.getParentPath().getLeaf();
                if (tr instanceof NewClassTree) {
                    NewClassTree newClass = (NewClassTree)tr;
                    start = (int)sp.getStartPosition(unit, newClass.getIdentifier());
                    end = (int)sp.getEndPosition(unit, newClass.getIdentifier());
                } else {
                    anonClassNameBug128074 = true;
                    start = end = (int)sp.getStartPosition(unit, t);
                }
                if (start < 0 && (parentPath = tree.getParentPath()) != null && (parentPath = parentPath.getParentPath()) != null && parentPath.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                    VariableTree enum_var = (VariableTree)parentPath.getLeaf();
                    pos = treeUtils.findNameSpan(enum_var);
                    if (pos == null) {
                        start = end = (int)sp.getStartPosition(unit, enum_var);
                    } else {
                        start = pos[0];
                        end = pos[1];
                    }
                }
            } else {
                start = pos[0];
                end = pos[1];
            }
        } else if (t.getKind() == Tree.Kind.METHOD) {
            pos = treeUtils.findNameSpan((MethodTree)t);
            if (pos == null) {
                start = end = (int)sp.getStartPosition(unit, t);
            } else {
                start = pos[0];
                end = pos[1];
            }
        } else if (t.getKind() == Tree.Kind.NEW_CLASS) {
            Tree ident = ((NewClassTree)t).getIdentifier();
            if (ident.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                ident = ((ParameterizedTypeTree)ident).getType();
            }
            if (ident.getKind() == Tree.Kind.MEMBER_SELECT) {
                int[] pos = treeUtils.findNameSpan((MemberSelectTree)ident);
                if (pos == null) {
                    start = end = (int)sp.getStartPosition(unit, ident);
                } else {
                    start = pos[0];
                    end = pos[1];
                }
            } else {
                TreePath varTreePath = tree.getParentPath();
                Tree varTree = varTreePath.getLeaf();
                Trees trees = compiler.getTrees();
                Element element = trees.getElement(varTreePath);
                if (element != null && varTree.getKind() == Tree.Kind.VARIABLE && element.getKind() == ElementKind.ENUM_CONSTANT) {
                    int[] pos = treeUtils.findNameSpan((VariableTree)varTree);
                    if (pos == null) {
                        start = end = (int)sp.getStartPosition(unit, varTree);
                    } else {
                        start = pos[0];
                        end = pos[1];
                    }
                } else {
                    start = (int)sp.getStartPosition(unit, ident);
                    end = (int)sp.getEndPosition(unit, ident);
                }
            }
        } else if (t.getKind() == Tree.Kind.MEMBER_SELECT) {
            pos = treeUtils.findNameSpan((MemberSelectTree)t);
            if (pos == null) {
                start = end = (int)sp.getStartPosition(unit, t);
            } else {
                start = pos[0];
                end = pos[1];
            }
        } else {
            start = (int)sp.getStartPosition(unit, t);
            end = (int)sp.getEndPosition(unit, t);
            if (end == -1) {
                if (!compiler.getTreeUtilities().isSynthetic(tree)) {
                    ErrorManager.getDefault().notify(1, (Throwable)new RuntimeException("Cannot get end position for " + t.getClass().getName() + " " + t + " file:" + compiler.getFileObject().getPath()));
                }
                end = start;
            }
        }
        assert (start > 0) : "Cannot find start position in file " + unit.getSourceFile().getName() + "\n tree=" + tree.toString();
        assert (end > 0) : "Cannot find end position in file " + unit.getSourceFile().getName() + "\n tree=" + tree.toString();
        LineMap lm = tree.getCompilationUnit().getLineMap();
        long line = lm.getLineNumber(start);
        long endLine = lm.getLineNumber(end);
        long sta = lm.getStartPosition(line);
        int eof = content.length();
        long lastLine = lm.getLineNumber(eof);
        long en = lastLine > endLine ? lm.getStartPosition(endLine + 1L) - 1L : (long)eof;
        StringBuilder sb = new StringBuilder();
        sb.append(UIUtilities.getHtml(WhereUsedElement.trimStart(content.subSequence((int)sta, start).toString())));
        sb.append("<b>");
        sb.append(content.subSequence(start, end));
        sb.append("</b>");
        sb.append(UIUtilities.getHtml(WhereUsedElement.trimEnd(content.subSequence(end, (int)en).toString())));
        DataObject dob = null;
        try {
            dob = DataObject.find((FileObject)compiler.getFileObject());
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        CloneableEditorSupport ces = JavaWhereUsedQueryPlugin.findCloneableEditorSupport(dob);
        PositionRef ref1 = ces.createPositionRef(start, Position.Bias.Forward);
        PositionRef ref2 = ces.createPositionRef(end, Position.Bias.Forward);
        PositionBounds bounds = new PositionBounds(ref1, ref2);
        TreePath tr = WhereUsedElement.getEnclosingTree(tree);
        return new WhereUsedElement(bounds, start == end && anonClassNameBug128074 ? NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_AnonymousClass") : sb.toString().trim(), start == end && anonClassNameBug128074 ? NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_AnonymousClass") : content.subSequence((int)sta, (int)en).toString().trim(), compiler.getFileObject(), tr, compiler, access, inTest, inPlatform, inDependency, false, elementInImport);
    }

    private static String trimStart(String s) {
        for (int x = 0; x < s.length(); ++x) {
            if (Character.isWhitespace(s.charAt(x))) continue;
            return s.substring(x);
        }
        return "";
    }

    private static String trimEnd(String s) {
        for (int x = s.length() - 1; x >= 0; --x) {
            if (Character.isWhitespace(s.charAt(x))) continue;
            return s.substring(0, x + 1);
        }
        return "";
    }

    public static WhereUsedElement create(int start, int end, CompilationInfo compiler, boolean inTest, boolean inPlatform, boolean inDependency) {
        CharSequence content = compiler.getSnapshot().getText();
        LineMap lm = compiler.getCompilationUnit().getLineMap();
        long line = lm.getLineNumber(start);
        long endLine = lm.getLineNumber(end);
        long sta = lm.getStartPosition(line);
        int eof = content.length();
        long lastLine = lm.getLineNumber(eof);
        long en = lastLine > endLine ? lm.getStartPosition(endLine + 1L) - 1L : (long)eof;
        StringBuilder sb = new StringBuilder();
        sb.append(UIUtilities.getHtml(WhereUsedElement.trimStart(content.subSequence((int)sta, start).toString())));
        sb.append("<b>");
        sb.append(content.subSequence(start, end));
        sb.append("</b>");
        sb.append(UIUtilities.getHtml(WhereUsedElement.trimEnd(content.subSequence(end, (int)en).toString())));
        DataObject dob = null;
        try {
            dob = DataObject.find((FileObject)compiler.getFileObject());
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        CloneableEditorSupport ces = JavaWhereUsedQueryPlugin.findCloneableEditorSupport(dob);
        PositionRef ref1 = ces.createPositionRef(start, Position.Bias.Forward);
        PositionRef ref2 = ces.createPositionRef(end, Position.Bias.Forward);
        PositionBounds bounds = new PositionBounds(ref1, ref2);
        return new WhereUsedElement(bounds, sb.toString().trim(), content.subSequence((int)sta, (int)en).toString(), compiler.getFileObject(), null, compiler, null, inTest, inPlatform, inDependency, true, false);
    }

    private static TreePath getEnclosingImportTree(TreePath tp) {
        while (tp != null) {
            Tree tree = tp.getLeaf();
            if (tree.getKind() == Tree.Kind.IMPORT) {
                return tp;
            }
            tp = tp.getParentPath();
        }
        return null;
    }

    private static TreePath getEnclosingTree(TreePath tp) {
        while (tp != null) {
            Tree tree = tp.getLeaf();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || tree.getKind() == Tree.Kind.METHOD || tree.getKind() == Tree.Kind.IMPORT || tree.getKind() == Tree.Kind.VARIABLE) {
                return tp;
            }
            tp = tp.getParentPath();
        }
        return null;
    }

    public boolean filter(FiltersManager manager) {
        boolean show = true;
        if (JavaWhereUsedQueryPlugin.DEPENDENCIES) {
            if (this.inPlatform) {
                boolean bl = show = show && manager.isSelected(JavaWhereUsedFilters.PLATFORM.getKey());
            }
            if (this.inDependency) {
                boolean bl = show = show && manager.isSelected(JavaWhereUsedFilters.DEPENDENCY.getKey());
            }
        }
        if (this.inTestclass) {
            show = show && manager.isSelected(JavaWhereUsedFilters.TESTFILE.getKey());
        }
        boolean bl = show = show && manager.isSelected(JavaWhereUsedFilters.SOURCEFILE.getKey());
        if (this.access != null) {
            boolean bl2 = show = show && manager.isSelected(this.access.getKey());
        }
        if (this.inComment) {
            boolean bl3 = show = show && manager.isSelected(JavaWhereUsedFilters.COMMENT.getKey());
        }
        if (this.inImport) {
            show = show && manager.isSelected(JavaWhereUsedFilters.IMPORT.getKey());
        }
        return show;
    }
}

