/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.git.ui.history.Bundle;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.RevisionNode;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.swing.etable.ETableColumnModel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

class DiffTreeTable
extends OutlineView {
    private RevisionsRootNode rootNode;
    private List<RepositoryRevision> results;
    private final SearchHistoryPanel master;

    public DiffTreeTable(SearchHistoryPanel master) {
        super(Bundle.LBL_DiffView_TreeColumnLabel());
        this.master = master;
        this.getOutline().setShowHorizontalLines(true);
        this.getOutline().setShowVerticalLines(false);
        this.getOutline().setRootVisible(false);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
        this.setupColumns();
    }

    private void setupColumns() {
        ResourceBundle loc = NbBundle.getBundle(DiffTreeTable.class);
        this.setPropertyColumns(new String[]{"path", loc.getString("LBL_DiffTree_Column_Path"), "date", loc.getString("LBL_DiffTree_Column_Time"), "username", loc.getString("LBL_DiffTree_Column_Username"), "message", loc.getString("LBL_DiffTree_Column_Message")});
        this.setPropertyColumnDescription("path", loc.getString("LBL_DiffTree_Column_Path_Desc"));
        this.setPropertyColumnDescription("date", loc.getString("LBL_DiffTree_Column_Time_Desc"));
        this.setPropertyColumnDescription("username", loc.getString("LBL_DiffTree_Column_Username_Desc"));
        this.setPropertyColumnDescription("message", loc.getString("LBL_DiffTree_Column_Message_Desc"));
        TableColumn msgColumn = this.getOutline().getColumn((Object)loc.getString("LBL_DiffTree_Column_Message"));
        msgColumn.setCellRenderer(new MessageRenderer(this.getOutline().getCellRenderer(0, msgColumn.getModelIndex())));
        TableColumnModel model = this.getOutline().getColumnModel();
        if (model instanceof ETableColumnModel) {
            ((ETableColumnModel)model).setColumnHidden(model.getColumn(1), true);
        }
        this.setDefaultColumnSizes();
    }

    private void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(() -> {
            if (this.getOutline().getColumnCount() == 4) {
                int width1 = this.getWidth();
                this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(width1 * 25 / 100);
                this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(width1 * 15 / 100);
                this.getOutline().getColumnModel().getColumn(2).setPreferredWidth(width1 * 10 / 100);
                this.getOutline().getColumnModel().getColumn(3).setPreferredWidth(width1 * 50 / 100);
            }
        });
    }

    void setSelection(int idx) {
        this.getOutline().getSelectionModel().setValueIsAdjusting(false);
        this.getOutline().scrollRectToVisible(this.getOutline().getCellRect(idx, 1, true));
        this.getOutline().getSelectionModel().setSelectionInterval(idx, idx);
    }

    void setSelection(RepositoryRevision container) {
        RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, container);
        if (node == null) {
            return;
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    void setSelection(RepositoryRevision.Event ... events) {
        ArrayList<RevisionNode> nodes = new ArrayList<RevisionNode>(events.length);
        for (RepositoryRevision.Event event : events) {
            RevisionNode node = (RevisionNode)this.getNode((Node)this.rootNode, event);
            if (node == null) continue;
            nodes.add(node);
        }
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        try {
            em.setSelectedNodes((Node[])nodes.toArray(Node[]::new));
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private Node getNode(Node node, Object obj) {
        Object object = node.getLookup().lookup(obj.getClass());
        if (obj.equals(object)) {
            return node;
        }
        Enumeration children = node.getChildren().nodes();
        while (children.hasMoreElements()) {
            Node child = (Node)children.nextElement();
            Node result = this.getNode(child, obj);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int[] getSelection() {
        return this.getOutline().getSelectedRows();
    }

    public int getRowCount() {
        return this.getOutline().getRowCount();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        em.setRootContext((Node)this.rootNode);
    }

    public void setResults(List<RepositoryRevision> results) {
        this.results = results;
        this.rootNode = new RevisionsRootNode();
        ExplorerManager em = ExplorerManager.find((Component)((Object)this));
        if (em != null) {
            em.setRootContext((Node)this.rootNode);
        }
    }

    public void refreshResults(List<RepositoryRevision> results) {
        this.results = results;
        ((RevisionsRootNodeChildren)this.rootNode.getChildren()).refreshKeys();
    }

    private static class MessageRenderer
    implements TableCellRenderer {
        private final TableCellRenderer delegate;
        private final Map<String, String> tooltips = new HashMap<String, String>();

        public MessageRenderer(TableCellRenderer delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JComponent) {
                JComponent c = (JComponent)comp;
                if (value == null) {
                    c.setToolTipText(null);
                } else {
                    String val = value.toString();
                    Object tooltip = this.tooltips.get(val);
                    if (tooltip == null) {
                        tooltip = val.replace("\r\n", "\n").replace("\r", "\n");
                        boolean highlighterActive = ((String)tooltip).startsWith("<html>");
                        if (!highlighterActive) {
                            try {
                                tooltip = XMLUtil.toElementContent((String)tooltip);
                            }
                            catch (CharConversionException e1) {
                                Logger.getLogger(DiffTreeTable.class.getName()).log(Level.INFO, "Can not HTML escape: " + (String)tooltip);
                            }
                        }
                        if (((String)tooltip).contains("\n")) {
                            tooltip = ((String)tooltip).replace("\n", "<br>");
                            if (!highlighterActive) {
                                tooltip = "<html><body><p>" + (String)tooltip + "</p></body></html>";
                            }
                            c.setToolTipText((String)tooltip);
                        }
                        this.tooltips.put(val, (String)tooltip);
                    }
                    c.setToolTipText((String)tooltip);
                }
            }
            return comp;
        }
    }

    private class RevisionsRootNode
    extends AbstractNode {
        public RevisionsRootNode() {
            super((Children)new RevisionsRootNodeChildren());
        }

        public String getName() {
            return "revision";
        }

        public String getDisplayName() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name");
        }

        public String getShortDescription() {
            return NbBundle.getMessage(DiffTreeTable.class, (String)"LBL_DiffTree_Column_Name_Desc");
        }
    }

    private class RevisionsRootNodeChildren
    extends Children.Keys<RepositoryRevision> {
        private RevisionsRootNodeChildren() {
        }

        protected void addNotify() {
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
        }

        private void refreshKeys() {
            this.setKeys(DiffTreeTable.this.results);
            DiffTreeTable.this.repaint();
        }

        protected Node[] createNodes(RepositoryRevision key) {
            return new Node[]{new RevisionNode(key, DiffTreeTable.this.master)};
        }
    }
}

