/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.numberrange;

import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.steps.numberrange.NumberRangeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberRangeSet {
    public static final String MULTI_VALUE_SEPARATOR = ",";
    private List<NumberRangeRule> rules;
    private String fallBackValue;

    public NumberRangeSet(List<NumberRangeRule> rules, String fallBackValue) {
        this.rules = rules;
        this.fallBackValue = fallBackValue;
    }

    protected String evaluateDouble(double value) {
        StringBuffer result = new StringBuffer();
        for (NumberRangeRule rule : this.rules) {
            String ruleResult = rule.evaluate(value);
            if (ruleResult == null) continue;
            if (result.length() > 0) {
                result.append(NumberRangeSet.getMultiValueSeparator());
            }
            result.append(ruleResult);
        }
        return result.toString();
    }

    public static String getMultiValueSeparator() {
        return MULTI_VALUE_SEPARATOR;
    }

    public String evaluate(String strValue) throws KettleException {
        if (strValue != null) {
            try {
                double doubleValue = Double.parseDouble(strValue);
                String result = this.evaluateDouble(doubleValue);
                if (!"".equals(result)) {
                    return result;
                }
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
        return this.fallBackValue;
    }
}

