/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.cmd.CreateConversionTask;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ImportVolume
extends CreateConversionTask {
    public static final String TASK_TYPE = "ImportVolume";
    public static final String[] AVAILABILITYZONE_DESC = new String[]{"Specifies the availability zone for the imported disk-image. Run the", "'ec2-describe-availability-zones' command for a list of values, and", "see the latest Developer's Guide for their meanings. [REQUIRED]"};
    public static final String[] VOLUME_DASH_SIZE_DESC = new String[]{"The size of the EBS volume, in GiB (2^30 bytes), that will hold the", "converted image. If this option is omitted, the required volume size", "will be computed from the image file."};

    public ImportVolume(String[] args) {
        super("ec2ivol", new String[]{"ec2iv", "ec2-import-volume"});
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("format");
        this.printOption("volume-size");
        this.printOption("availability-zone");
        this.printOption("bucket");
        this.printOption("owner-akid");
        this.printOption("owner-sak");
        this.printOption("prefix");
        this.printOption("manifest-url");
        this.printOption("description");
        this.printOption("expires");
        this.printOption("ignore-region-affinity");
        this.printOption("user-threads");
        this.printOption("dry-run");
        this.printOption("dont-verify-format");
        this.printOption("no-upload");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Create a new import volume task using meta-data from the given disk");
        System.out.println("     image. The volume size for the imported disk-image will be calculated");
        System.out.println("     automatically, unless specified.");
    }

    @Override
    protected void validateParameters() throws GeneralError, VerificationException {
        super.validateParameters();
        this.assertOptionSet("availability-zone");
        this.az = this.getOptionValue("availability-zone");
    }

    @Override
    protected Options getOptions() {
        Options options = super.getOptions();
        OptionBuilder.withLongOpt((String)"availability-zone");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"ZONE");
        OptionBuilder.withDescription((String)ImportVolume.joinDescription(AVAILABILITYZONE_DESC));
        options.addOption(OptionBuilder.create((String)"z"));
        OptionBuilder.withLongOpt((String)"volume-size");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SIZE");
        OptionBuilder.withDescription((String)ImportVolume.joinDescription(VOLUME_DASH_SIZE_DESC));
        options.addOption(OptionBuilder.create((String)"s"));
        return options;
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        try {
            this.validateParameters();
            if (this.dryRun) {
                return true;
            }
            this.createSignedManifestUrl();
            long diskImageSize = this.image.length();
            this.task = jec2.importVolume(this.az, this.description, this.diskImageFormat, this.signedManifestUrl, diskImageSize, this.volumeSize);
            out.output(System.out, this.task, this.task.getImportVolumeConversionTask(), false);
            if (this.noUpload) {
                return true;
            }
            return this.invokeUpload(jec2);
        }
        catch (VerificationException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
        catch (InternalException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
    }

    public static void main(String[] args) {
        new ImportVolume(args).invoke();
    }
}

