/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ConfusingWhenBranchSyntaxChecker;", "", "()V", "prohibitedTokens", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "check", "", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkCondition", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "checkConditionExpression", "rawExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "frontend"})
public final class ConfusingWhenBranchSyntaxChecker {
    @NotNull
    public static final ConfusingWhenBranchSyntaxChecker INSTANCE = new ConfusingWhenBranchSyntaxChecker();
    @NotNull
    private static final TokenSet prohibitedTokens;

    private ConfusingWhenBranchSyntaxChecker() {
    }

    public final void check(@NotNull KtWhenExpression whenExpression, @NotNull LanguageVersionSettings languageVersionSettings2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        if (whenExpression.getSubjectExpression() == null && whenExpression.getSubjectVariable() == null) {
            return;
        }
        for (KtWhenEntry entry : whenExpression.getEntries()) {
            KtWhenCondition[] ktWhenConditionArray;
            Intrinsics.checkNotNullExpressionValue((Object)entry.getConditions(), (String)"entry.conditions");
            for (KtWhenCondition condition : ktWhenConditionArray) {
                Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"condition");
                this.checkCondition(condition, languageVersionSettings2, trace);
            }
        }
    }

    private final void checkCondition(KtWhenCondition condition, LanguageVersionSettings languageVersionSettings2, BindingTrace trace) {
        KtWhenCondition ktWhenCondition = condition;
        if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            this.checkConditionExpression(((KtWhenConditionWithExpression)condition).getExpression(), languageVersionSettings2, trace);
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            this.checkConditionExpression(((KtWhenConditionInRange)condition).getRangeExpression(), languageVersionSettings2, trace);
        }
    }

    private final void checkConditionExpression(KtExpression rawExpression, LanguageVersionSettings languageVersionSettings2, BindingTrace trace) {
        boolean shouldReport;
        if (rawExpression == null) {
            return;
        }
        if (rawExpression instanceof KtParenthesizedExpression) {
            return;
        }
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize(rawExpression);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"safeDeparenthesize(rawExpression)");
        KtExpression expression2 = ktExpression;
        boolean bl = expression2 instanceof KtIsExpression ? true : (shouldReport = expression2 instanceof KtBinaryExpression ? prohibitedTokens.contains(((KtBinaryExpression)expression2).getOperationToken()) : false);
        if (shouldReport) {
            trace.report(Errors.CONFUSING_BRANCH_CONDITION.on(languageVersionSettings2, rawExpression));
        }
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ, KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.ANDAND, KtTokens.OROR};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(\n        IN_KEYWO\u2026       ANDAND, OROR\n    )");
        prohibitedTokens = tokenSet;
    }
}

