/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.model.internal.type.ModelType;

@Contextual
public class WorkValidationException
extends GradleException {
    private static final String MAX_ERR_COUNT_PROPERTY = "org.gradle.internal.max.validation.errors";
    private static final int DEFAULT_MAX_ERR_COUNT = 5;
    private final List<String> problems;

    private WorkValidationException(String message, Collection<String> problems) {
        super(message);
        this.problems = ImmutableList.copyOf(problems);
    }

    public List<String> getProblems() {
        return this.problems;
    }

    public static Builder forProblems(Collection<String> problems) {
        return new Builder(problems);
    }

    public static final class BuilderWithSummary {
        private final List<String> problems;
        private final String summary;

        public BuilderWithSummary(List<String> problems, String summary) {
            this.problems = problems;
            this.summary = summary;
        }

        public WorkValidationException get() {
            return this.build(null);
        }

        public WorkValidationException getWithExplanation(String explanation) {
            return this.build(explanation);
        }

        private WorkValidationException build(@Nullable String explanation) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(this.summary);
            formatter.startChildren();
            for (String problem : this.problems) {
                formatter.node(problem);
            }
            formatter.endChildren();
            if (explanation != null) {
                formatter.node(explanation);
            }
            return new WorkValidationException(formatter.toString(), (Collection)ImmutableList.copyOf(this.problems));
        }
    }

    public static final class Builder {
        private final List<String> problems;

        public Builder(Collection<String> problems) {
            this.problems = (List)problems.stream().limit(Integer.getInteger(WorkValidationException.MAX_ERR_COUNT_PROPERTY, 5).intValue()).collect(ImmutableList.toImmutableList());
        }

        public Builder limitTo(int maxProblems) {
            return new Builder(this.problems.stream().limit(maxProblems).collect(Collectors.toList()));
        }

        public BuilderWithSummary withSummaryForContext(String validatedObjectName, WorkValidationContext validationContext) {
            String summary = this.summarizeInContext(validatedObjectName, validationContext);
            return new BuilderWithSummary(this.problems, summary);
        }

        public BuilderWithSummary withSummaryForPlugin() {
            String summary = "Plugin validation failed with " + this.problems.size() + " problem" + (this.problems.size() == 1 ? "" : "s");
            return new BuilderWithSummary(this.problems, summary);
        }

        private String summarizeInContext(String validatedObjectName, WorkValidationContext validationContext) {
            return String.format("%s found with the configuration of %s (%s).", this.problems.size() == 1 ? "A problem was" : "Some problems were", validatedObjectName, this.describeTypesChecked((ImmutableCollection<Class<?>>)validationContext.getValidatedTypes()));
        }

        private String describeTypesChecked(ImmutableCollection<Class<?>> types) {
            return types.size() == 1 ? "type '" + this.getTypeDisplayName((Class)types.iterator().next()) + "'" : "types '" + types.stream().map(this::getTypeDisplayName).collect(Collectors.joining("', '")) + "'";
        }

        private String getTypeDisplayName(Class<?> type) {
            return ModelType.of(type).getDisplayName();
        }
    }
}

