/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.duo;

import com.google.inject.Inject;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.duo.api.DuoService;
import org.apache.guacamole.auth.duo.conf.ConfigurationService;
import org.apache.guacamole.auth.duo.form.DuoSignedResponseField;
import org.apache.guacamole.language.TranslatableGuacamoleClientException;
import org.apache.guacamole.language.TranslatableGuacamoleInsufficientCredentialsException;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;

public class UserVerificationService {
    @Inject
    private ConfigurationService confService;
    @Inject
    private DuoService duoService;

    public void verifyAuthenticatedUser(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        Credentials credentials = authenticatedUser.getCredentials();
        HttpServletRequest request = credentials.getRequest();
        if (authenticatedUser.getIdentifier().equals("")) {
            return;
        }
        String signedResponse = request.getParameter("guac-duo-signed-response");
        if (signedResponse == null) {
            DuoSignedResponseField signedResponseField = new DuoSignedResponseField(this.confService.getAPIHostname(), this.duoService.createSignedRequest(authenticatedUser));
            CredentialsInfo expectedCredentials = new CredentialsInfo(Collections.singletonList(signedResponseField));
            throw new TranslatableGuacamoleInsufficientCredentialsException("Verification using Duo is required before authentication can continue.", "LOGIN.INFO_DUO_AUTH_REQUIRED", expectedCredentials);
        }
        if (!this.duoService.isValidSignedResponse(authenticatedUser, signedResponse)) {
            throw new TranslatableGuacamoleClientException("Provided Duo validation code is incorrect.", "LOGIN.INFO_DUO_VALIDATION_CODE_INCORRECT");
        }
    }
}

